#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__ = 'GPL v3'
__copyright__ = '2025, Comfy.n'
__docformat__ = 'restructuredtext en'

from PyQt5.QtCore import QUrl
from PyQt5.QtGui import QDesktopServices
import os
from calibre.utils.config import config_dir
from calibre.constants import iswindows
from calibre.gui2 import error_dialog
import zipfile

plugin_name = "calibre_config_reports"

def get_local_resources_dir(subfolder=None):
    '''Returns path to local resources directory, optionally with subfolder'''
    resources_dir = os.path.join(config_dir, 'plugins', plugin_name)
    if subfolder:
        resources_dir = os.path.join(resources_dir, subfolder)
    if iswindows:
        resources_dir = os.path.normpath(resources_dir)
    return resources_dir

def extract_sounds_from_zip():
    '''Extract the sound files from the plugin zip to config dir - now optional'''
    try:
        # Setup destination paths
        plugin_config_dir = os.path.join(config_dir, 'plugins', plugin_name)
        sounds_dir = os.path.join(plugin_config_dir, 'sounds')


        # Create sounds directory
        os.makedirs(sounds_dir, exist_ok=True)

        # Get plugin zip path
        plugin_zip = os.path.join(config_dir, 'plugins', 'Calibre Config Reports.zip')
        if not os.path.exists(plugin_zip):
            plugin_zip = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'Calibre Config Reports.zip')


        # Extract MP3 files and playlist.txt from sounds directory
        if os.path.exists(plugin_zip):
            with zipfile.ZipFile(plugin_zip, 'r') as zf:
                found_sounds = False
                for name in zf.namelist():
                    if name.startswith('sounds/') and (name.lower().endswith('.mp3') or name.lower().endswith('playlist.txt')):
                        zf.extract(name, plugin_config_dir)
                        found_sounds = True
                return found_sounds

        return False

    except Exception as e:
        return False

def ensure_resources():
    '''Ensure sound resources are in place, but make it optional'''
    try:
        # Extract sound files
        if not extract_sounds_from_zip():
            return False

        return True
    except Exception as e:
        import traceback
        traceback.print_exc()
        return False
