package com.twll.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Bitmap.Config;
import android.graphics.BitmapFactory.Options;

import com.twll.MyLog;
import com.twll.MySettings;

public class ShutdownImageUtil {

	private final static String PATH = MySettings.getSettingsPath();
	private final static String NAME_SHUTDOWN_IMG = "shutdown";
	private final static String NAME_SHUTDOWN_RAW = NAME_SHUTDOWN_IMG + ".raw";
	private final static String NO_SHUTDOWN_IMAGE = "";
	private final static int WIDTH = 600;
	private final static int HEIGHT = 800;

	public static synchronized String getShutdownImage() {
		MyLog.debug("starting getShutdownImage..");
		//check if hack is enabled;
		if(!MySettings.isShutdownImageHackEnabled()){
			MyLog.debug("shutdown image hack disabled");
			return NO_SHUTDOWN_IMAGE;
		}
		String shutdownImage = currentShutdownImage();
		if (NO_SHUTDOWN_IMAGE.equals(shutdownImage)) {
			MyLog.debug("current shutdown image not present");
			try {
				// check if a valid source image exists..
				File dir = new File(PATH);
				File[] srcImages = dir.listFiles(new FileFilter() {
					@Override
					public boolean accept(File file) {
						try {
							MyLog.debug("processing: " + file.getName());
							if (!file.isFile())
								return false;
							String filename = file.getName();
							int i = filename.lastIndexOf('.') + 1;
							MyLog.debug("i: " + i);
							String ext = i == 0 || i == filename.length() ? "" : filename.substring(i).toLowerCase();
							MyLog.debug("ext: " + ext);
							String name = i == 0 ? filename : filename.substring(0, i - 1);
							MyLog.debug("name: " + name);
							if (!NAME_SHUTDOWN_IMG.equalsIgnoreCase(name))
								return false;
							if (!(ext.equals("png") || ext.equals("jpg") || ext.equals("jpeg") || ext.equals("gif")))
								return false;
						} catch (Exception e) {
							MyLog.debug("error processing file list, file: "+file.getAbsolutePath(),e);
							return false;
						}
						return true;
					}
				});
				if (srcImages != null && srcImages.length > 0) {
					// take first valid source image and generate row image..
					MyLog.debug("source image found [" + srcImages[0].getName() + "]: generating a new shutdown raw image");
					generateRawImage(srcImages[0].getAbsolutePath(), PATH + NAME_SHUTDOWN_RAW);
					// verify again if raw image exists
					shutdownImage = currentShutdownImage();
				} else {
					MyLog.debug("no source image found in [" + PATH + "]: not generating a new shutdown raw image");
				}
			} catch (Exception e) {
				MyLog.debug("error generating shutdown image: ", e);
			}
		} else {
			MyLog.debug("current shutdown image: " + shutdownImage);
		}
		MyLog.debug("using shutdown image: " + (!NO_SHUTDOWN_IMAGE.equals(shutdownImage) ? "[no image]" : shutdownImage));
		return shutdownImage;
	}

	private static String currentShutdownImage() {
		try {
			// verify if shutdown image exists and its size is correct
			File fileRawImage = new File(PATH + NAME_SHUTDOWN_RAW);
			// correct size : WIDTH * HEIGHT * 2 (16-bit per pixel)
			if (fileRawImage.exists() && fileRawImage.isFile() && fileRawImage.length() == (WIDTH * HEIGHT * 2)) {
				return fileRawImage.getAbsolutePath();
			}
		} catch (Exception e) {
		}
		return NO_SHUTDOWN_IMAGE;
	}

	private static void generateRawImage(String srcImage, String destImage) throws Exception {
		File destImageFile = null;
		try {
			Options options = new Options();
			options.inJustDecodeBounds = true;
			BitmapFactory.decodeFile(srcImage, options);
			options.inJustDecodeBounds = false;
			int w = options.outWidth / WIDTH;
			int h = options.outHeight / HEIGHT;
			MyLog.debug("A) w:" + w + " h:" + h);
			options.inSampleSize = Math.max(w, h);
			Bitmap bitmap = BitmapFactory.decodeFile(srcImage, options);
			w = options.outWidth;
			h = options.outHeight;
			MyLog.debug("B) w:" + w + " h:" + h);
			if (w > h) {
				h = (int) (h * ((float) WIDTH) / ((float) w));
				MyLog.debug("C1) w:" + WIDTH + " h:" + h);
				bitmap = Bitmap.createScaledBitmap(bitmap, WIDTH, h, false);
			} else {
				w = (int) (w * ((float) HEIGHT) / ((float) h));
				MyLog.debug("C2) w:" + w + " h:" + HEIGHT);
				bitmap = Bitmap.createScaledBitmap(bitmap, w, HEIGHT, false);
			}
			Bitmap buffer = Bitmap.createBitmap(WIDTH, HEIGHT, Config.RGB_565);
			Canvas canvas = new Canvas(buffer);
			canvas.drawColor(Color.parseColor("#ff6d6e70"));
			float x = (buffer.getWidth() - bitmap.getWidth()) / ((float) 2);
			float y = (buffer.getHeight() - bitmap.getHeight()) / ((float) 2);
			MyLog.debug("D) x:" + x + " y:" + y);
			canvas.drawBitmap(bitmap, x, y, null);

			ByteBuffer byteBuffer = ByteBuffer.allocate(WIDTH * HEIGHT * 2);
			buffer.copyPixelsToBuffer(byteBuffer);
			destImageFile = new File(destImage);
			FileOutputStream fos = new FileOutputStream(destImageFile, false);
			FileChannel channel = fos.getChannel();
			byteBuffer.rewind();
			channel.write(byteBuffer, 0);
			channel.close();
		} catch(Exception e) {
			if(destImageFile!=null)
				destImageFile.delete();
			throw e;
		}
	}

}
