package com.twll.ereader;

import java.io.File;

import com.twll.MyLog;
import com.twll.MySettings;

public class FontUtil {
	private final static String FONT_FOLDER = "/system/media/sdcard/my fonts/";

	private static String[] fontNames = new String[3];
	private static boolean fontNamesInited = false;

	private static String getFontName(int index) {
		if (!fontNamesInited) {
			MyLog.debug("loading custom font info");
			for (int i = 1; i <= 3; i++) {
				File dir = new File(FONT_FOLDER + "font" + i);
				boolean fontExist = false;
				if (dir.exists() && dir.isDirectory()) {
					MyLog.debug("dir " + FONT_FOLDER + "font" + i + " exists: true");
					for (File file : dir.listFiles()) {
						if (file.getName().toLowerCase().endsWith(".fontname")) {
							fontNames[i - 1] = file.getName().substring(0, file.getName().length() - 9);
						} else if (file.getName().equals("normal.ttf")) {
							fontExist = true;
						}
					}
					if (fontNames[i - 1] == null && fontExist)
						fontNames[i - 1] = "Unknown Font " + i;
					else if (!fontExist)
						fontNames[i - 1] = null;
					if (fontExist)
						MyLog.debug("font" + i + " name: '" + fontNames[i - 1] + "'");
					else
						MyLog.debug("font" + i + " not found");
				} else {
					MyLog.debug("dir " + FONT_FOLDER + "font" + i + " exists: false");
				}
			}
			fontNamesInited = true;
		}
		return fontNames[index - 1];
	}

	public static String getFontName(String defaultName) {
		MyLog.debug("decoding font: '" + defaultName + "'");
		if (!MySettings.isReaderFontHackEnabled()) {
			return defaultName;
		}
		String fontName = null;
		int index;
		for (index = 1; fontName == null && index <= 3; index++)
			if (defaultName != null && defaultName.equals(getFontName(index))) {
				fontName = defaultName;
				MyLog.debug("phase 1 - found; index:" + index + "; decoded:'" + fontName + "'");
			}
		if (fontName == null) {
			if ("Amasis".equals(defaultName))
				index = 1;
			else if ("Helvetica Neue".equals(defaultName))
				index = 2;
			else
				// if ("Light Classic".equals(defaultName))
				index = 3;
			fontName = getFontName(index);
			if (fontName == null) {
				fontName = defaultName;
				MyLog.debug("phase 3 - not found, returning input name");
			} else {
				MyLog.debug("phase 2 - found; index:" + index + "; decoded:'" + fontName + "'");
			}
		}
		return fontName;
	}
}
