package com.twll;

import java.text.SimpleDateFormat;
import java.util.Date;

public class MyLog {
	private static final SimpleDateFormat logFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

	public static final void debug(String msg) {
		logImpl(msg, null, false, false);
	}

	public static final void debug(String msg, Throwable t) {
		logImpl(msg, t, false, false);
	}

	public static final void forceLog(String msg, Throwable t, boolean logCallerClass) {
		logImpl(msg, t, true, logCallerClass);
	}

	public static final void logImpl(String msg, Throwable t, boolean force, boolean logCallerClass) {
		if (!MySettings.isDebugMode() && !force)
			return;
		Throwable stack = new Throwable();
		StackTraceElement[] stackTrace = stack.getStackTrace();
		String className = null;
		if (stackTrace != null && stackTrace.length > 2) {
			StackTraceElement caller = stack.getStackTrace()[2];
			className = caller.getClassName();
			int idx = className.lastIndexOf('.');
			if (idx != -1 && idx != className.length() - 1)
				className = className.substring(idx + 1);
			if (caller.getLineNumber() >= 0)
				className += "(" + caller.getLineNumber() + ")";
		} else {
			className = "?";
		}
		String callerClassName = null;
		if (logCallerClass) {
			if (stackTrace != null && stackTrace.length > 3) {
				StackTraceElement caller = stack.getStackTrace()[3];
				callerClassName = caller.getClassName();
				int idx = callerClassName.lastIndexOf('.');
				if (idx != -1 && idx != callerClassName.length() - 1)
					callerClassName = callerClassName.substring(idx + 1);
				if (caller.getLineNumber() >= 0)
					callerClassName += "(" + caller.getLineNumber() + ")";
			} else {
				callerClassName = "?";
			}
			callerClassName += "->";
		}
		System.out.println("[" + logFormat.format(new Date()) + "] [" + (callerClassName != null ? callerClassName : "") + className + "] " + msg);
		if (t != null)
			t.printStackTrace();
	}

}
