package com.twll;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.Properties;

public class MySettings {
	private final static String FONT_DIR = "/system/media/sdcard/my fonts/";
	private final static String FONT_DIR_DISABLED = "/system/media/sdcard/my fonts_disabled/";
	private final static String SETTINGS_PATH = "/system/media/sdcard/settings/";
	private final static String SETTINGS_FILE = "settings.ini";

	private static Properties props = null;
	private static boolean debugMode = false;
	private static int maxLevel = -1;

	static {
		MyLog.forceLog("MySettings class initialization..", null, true);
		loadSettings();
		debugMode = isBooleanPropEnabled("debug_mode");
	}

	public static void init() {
		// do nothing, just used to be sure class is loaded
	}

	private static void createDefaultSettingsFileIfMissing() {
		PrintWriter out = null;
		try {
			File settingDir = new File(SETTINGS_PATH);
			if (!settingDir.exists()) {
				settingDir.mkdir();
			}
			File settingFile = new File(SETTINGS_PATH + SETTINGS_FILE);
			if (!settingFile.exists()) {
				out = new PrintWriter(settingFile);
				out.println("# properties for Nook Firmware Improvements");
				out.println("# by traycold.");
				out.println("# Further info and downloads on:");
				out.println("# http://twll.blogspot.com");
				out.println("#");
				out.println("# debug_mode: if true, some logs are enabled on logcat.");
				out.println("#             [default: false]");
				out.println("#debug_mode=true");
				out.println("#");
				out.println("# enable_font_hack: if true, the reader font hack is enabled.");
				out.println("#                   [default: true]");
				out.println("#enable_font_hack=true");
				out.println("#");
				out.println("# enable_shutdown_image: if true, the shutdown image hack is enabled.");
				out.println("#                        [default: true]");
				out.println("#enable_shutdown_image=true");
				out.println("#");
				out.println("# max_chapter_level: the max level on epub documents that is showed on");
				out.println("#                    reader \"go to\" menu. [default: 3]");
				out.println("#max_chapter_level=3");	
			}
		} catch (Exception e) {
			MyLog.forceLog("error creating settings file", e, false);
		} finally {
			if (out != null)
				out.close();
		}
	}

	private static void loadSettings() {
		props = new Properties();
		createDefaultSettingsFileIfMissing();
		File settingsFile = new File(SETTINGS_PATH + SETTINGS_FILE);
		if (settingsFile.exists() && settingsFile.isFile()) {
			FileInputStream fis = null;
			try {
				fis = new FileInputStream(settingsFile);
				props.load(fis);
			} catch (Exception e) {

			} finally {
				if (fis != null)
					try {
						fis.close();
					} catch (Exception e) {
					}
			}
		}
	}

	static boolean isDebugMode() {
		return debugMode;
	}

	private static boolean isBooleanPropEnabled(String propName) {
		return "true".equalsIgnoreCase(props.getProperty(propName)) || "Y".equalsIgnoreCase(props.getProperty(propName));
	}

	private static boolean isBooleanPropDisabled(String propName) {
		return "false".equalsIgnoreCase(props.getProperty(propName)) || "N".equalsIgnoreCase(props.getProperty(propName));
	}

	public static String getSettingsPath() {
		return SETTINGS_PATH;
	}

	public static boolean isShutdownImageHackEnabled() {
		return !isBooleanPropDisabled("enable_shutdown_image");
	}

	public static boolean isReaderFontHackEnabled() {
		return !isBooleanPropDisabled("enable_font_hack");
	} 

	public static int getMaxChapterLevel() {
		if (maxLevel == -1) {
			try {
				MyLog.debug("setting maxChapterLevel");
				String maxLevelString = props.getProperty("max_chapter_level", "3");
				MyLog.debug("string max_chapter_level: " + maxLevelString);
				maxLevel = Integer.parseInt(maxLevelString);
				if (maxLevel < 1 || maxLevel > 9) {
					MyLog.debug("setting default because invalid value: " + maxLevel);
					maxLevel = 3;
				}
			} catch (Exception e) {
				MyLog.debug("setting default because exception: " + e);
				maxLevel = 3;
			}
			MyLog.debug("returning value: " + maxLevel);
		}
		return maxLevel;
	}
}
