<?php

///provide information on codec
function rtf_codec_info() {
	return "\tRich text format";
}

///check dependencies
function check_deps_rtf() {
	//there are no internal dependencies for rtf, so only check external ones
	if(!shell_exec('which pandoc')) printFatalErr('Dependency pandoc is missing!');
}

///convert story format to RTF
function convert_story_rtf($story) {
	//convert to html
	$html = convert_story_html($story, true);

	//run html through pandoc
	$descriptorspec = array(
		0 => array('pipe', 'r'),
		1 => array('pipe', 'w'),
		2 => array('file', '/dev/null', 'w')
	);
	$ph = proc_open('pandoc -s -f html -t rtf', $descriptorspec, $pipes, '/tmp');
	fwrite($pipes[0], "$html");
	fclose($pipes[0]);
	while(!feof($pipes[1])) {
		$rtf .= fread($pipes[1], 8192);
	}
	fclose($pipes[1]);
	proc_close($ph);
	
	return $rtf;
}

?>