<?php

//Provide info on codec
function epub_codec_info() {

	//Return the info
	return "\tOpen ebook format based on xml / zip";
}

//Check Dependencies
function check_deps_epub() {

	//No Internal Dependecies for epub, check the external ones
	if (!shell_exec('which html2epub') && !shell_exec('html2epub')) printFatalErr('Dependency html2epub (part of Calibre is missing - is Calibre installed?');
}

//Convert story format to EPUB
function convert_story_epub($story) {

	//Get global references
	global $config;

	//Set up file names
	$fname = 'fflag' . PID . $config['storyid'];
	$temp_fname = TEMP . '/' . $fname;

	//Get the converted HTML story
	file_put_contents("$temp_fname.html", convert_story_html($story));
	
	//Goto to the temp folder
	chdir(TEMP);

	//Create the epub content and store it in a temp file
	exec("html2epub -t \"{$story['meta']['title']}\" -a \"{$story['meta']['author']}\" --publisher \"{$ffurl}\" --comment \"{$story['meta']['description']}\" \"$temp_fname.html\"");
	$result = file_get_contents("$temp_fname.epub");

	//Delete the files used
	unlink("$temp_fname.html");
	unlink("$temp_fname.epub");

	//Return the result
	return $result;
}

?>