/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodePredicate;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.linked.NodeImpl;

abstract class TreeEnumeration
implements AxisIterator,
LookaheadIterator {
    protected NodeImpl start;
    protected NodeImpl nextNode;
    protected NodePredicate nodeTest;
    protected NodeImpl current = null;
    protected int position = 0;

    public TreeEnumeration(NodeImpl origin, NodePredicate nodeTest) {
        this.nextNode = origin;
        this.start = origin;
        this.nodeTest = nodeTest;
    }

    protected boolean conforms(NodeImpl node) {
        return node == null || this.nodeTest == null || this.nodeTest.test(node);
    }

    protected final void advance() {
        do {
            this.step();
        } while (!this.conforms(this.nextNode));
    }

    protected abstract void step();

    @Override
    public boolean hasNext() {
        return this.nextNode != null;
    }

    @Override
    public final NodeInfo next() {
        if (this.nextNode == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.nextNode;
        ++this.position;
        this.advance();
        return this.current;
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }
}

