/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.api.FeatureReport;
import com.adobe.epubcheck.api.LocalizableReport;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFContainer;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.PublicationType;
import com.adobe.epubcheck.overlay.OverlayTextChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.URLResourceProvider;
import com.adobe.epubcheck.vocab.Property;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import org.w3c.epubcheck.core.references.ReferenceRegistry;
import org.w3c.epubcheck.core.references.ResourceRegistry;
import org.w3c.epubcheck.util.url.URLUtils;

public final class ValidationContext {
    public final URL url;
    public final String path;
    public final String mimeType;
    public final EPUBVersion version;
    public final EPUBProfile profile;
    public final Report report;
    public final Locale locale;
    public final FeatureReport featureReport;
    public final GenericResourceProvider resourceProvider;
    public final Optional<OPFItem> opfItem;
    public final Optional<OCFContainer> container;
    public final Optional<ResourceRegistry> resourceRegistry;
    public final Optional<ReferenceRegistry> referenceRegistry;
    public final Optional<OverlayTextChecker> overlayTextChecker;
    public final Set<PublicationType> pubTypes;
    public final Set<Property> properties;

    private ValidationContext(ValidationContextBuilder builder) {
        Preconditions.checkState((builder.url != null ? 1 : 0) != 0, (Object)"URL must be set");
        Preconditions.checkState((builder.report != null ? 1 : 0) != 0, (Object)"report must be set");
        this.url = builder.url;
        this.container = Optional.fromNullable((Object)builder.container);
        this.resourceRegistry = Optional.fromNullable((Object)builder.resourceRegistry);
        this.referenceRegistry = Optional.fromNullable((Object)builder.referenceRegistry);
        this.mimeType = Strings.nullToEmpty((String)builder.mimeType);
        this.version = (EPUBVersion)((Object)Optional.fromNullable((Object)((Object)builder.version)).or((Object)EPUBVersion.Unknown));
        this.profile = (EPUBProfile)((Object)Optional.fromNullable((Object)((Object)builder.profile)).or((Object)EPUBProfile.DEFAULT));
        this.report = builder.report;
        this.locale = (Locale)MoreObjects.firstNonNull(this.report instanceof LocalizableReport ? ((LocalizableReport)this.report).getLocale() : null, (Object)Locale.getDefault());
        this.featureReport = (FeatureReport)Optional.fromNullable((Object)builder.featureReport).or((Object)new FeatureReport());
        this.resourceProvider = (GenericResourceProvider)Iterables.find(Arrays.asList(builder.container, builder.resourceProvider, new URLResourceProvider()), (Predicate)Predicates.notNull());
        this.opfItem = Optional.fromNullable(builder.resourceRegistry != null ? (OPFItem)builder.resourceRegistry.getOPFItem(builder.url).orElse(null) : null);
        this.overlayTextChecker = Optional.fromNullable((Object)builder.overlayTextChecker);
        this.pubTypes = builder.pubTypes != null ? Sets.immutableEnumSet((Iterable)builder.pubTypes) : EnumSet.noneOf(PublicationType.class);
        this.properties = builder.properties.build();
        this.path = this.computePath();
    }

    private String computePath() {
        if (this.container.isPresent() && !((OCFContainer)this.container.get()).isRemote(this.url)) {
            if (this.url.path() != null && !this.url.path().isEmpty()) {
                return this.url.path().substring(1);
            }
            return "";
        }
        if ("file".equals(this.url.scheme())) {
            try {
                return new File(this.url.toJavaURI()).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                return this.url.toHumanString();
            }
        }
        return this.url.toHumanString();
    }

    public ValidationContextBuilder copy() {
        return new ValidationContextBuilder().copy(this);
    }

    public boolean isRemote(URL url) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"URL is null");
        if (this.container.isPresent()) {
            return ((OCFContainer)this.container.get()).isRemote(url);
        }
        return URLUtils.isRemote(url, this.url);
    }

    public String relativize(URL url) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"URL is null");
        if (this.container.isPresent()) {
            return ((OCFContainer)this.container.get()).relativize(url);
        }
        return this.url.relativize(url);
    }

    public static final ValidationContextBuilder of(URL url) {
        return new ValidationContextBuilder().url(url);
    }

    public static final ValidationContextBuilder test() {
        try {
            return new ValidationContextBuilder().url(URL.parse((String)"https://test.example.org"));
        }
        catch (GalimatiasParseException e) {
            throw new AssertionError();
        }
    }

    public String getMimeType(URL url) {
        if (url == null) {
            return null;
        }
        if ("data".equals(url.scheme())) {
            return URLUtils.getDataURLType(url);
        }
        if (this.resourceRegistry.isPresent()) {
            return ((ResourceRegistry)this.resourceRegistry.get()).getMimeType(url);
        }
        return null;
    }

    public static final class ValidationContextBuilder {
        private URL url = null;
        private String mimeType = null;
        private EPUBVersion version = null;
        private EPUBProfile profile = null;
        private Report report = null;
        private FeatureReport featureReport = null;
        private GenericResourceProvider resourceProvider = null;
        private OCFContainer container = null;
        private ResourceRegistry resourceRegistry = null;
        private ReferenceRegistry referenceRegistry = null;
        private OverlayTextChecker overlayTextChecker = null;
        private Set<PublicationType> pubTypes = null;
        private ImmutableSet.Builder<Property> properties = ImmutableSet.builder();

        public ValidationContextBuilder() {
        }

        public ValidationContextBuilder(ValidationContext context) {
            this.copy(context);
        }

        public ValidationContextBuilder copy(ValidationContext context) {
            this.url = context.url;
            this.mimeType = context.mimeType;
            this.version = context.version;
            this.profile = context.profile;
            this.report = context.report;
            this.featureReport = context.featureReport;
            this.resourceProvider = context.resourceProvider;
            this.container = (OCFContainer)context.container.orNull();
            this.resourceRegistry = (ResourceRegistry)context.resourceRegistry.orNull();
            this.referenceRegistry = (ReferenceRegistry)context.referenceRegistry.orNull();
            this.overlayTextChecker = (OverlayTextChecker)context.overlayTextChecker.orNull();
            this.pubTypes = context.pubTypes;
            this.properties = ImmutableSet.builder().addAll(context.properties);
            return this;
        }

        public ValidationContextBuilder url(URL url) {
            this.url = url;
            return this;
        }

        public ValidationContextBuilder mimetype(String mimetype) {
            this.mimeType = mimetype;
            return this;
        }

        public ValidationContextBuilder version(EPUBVersion version) {
            this.version = version;
            return this;
        }

        public ValidationContextBuilder profile(EPUBProfile profile) {
            this.profile = profile;
            return this;
        }

        public ValidationContextBuilder report(Report report) {
            this.report = report;
            return this;
        }

        public ValidationContextBuilder featureReport(FeatureReport featureReport) {
            this.featureReport = featureReport;
            return this;
        }

        public ValidationContextBuilder resourceProvider(GenericResourceProvider resourceProvider) {
            this.resourceProvider = resourceProvider;
            return this;
        }

        public ValidationContextBuilder container(OCFContainer container) {
            this.container = container;
            if (container != null) {
                this.resourceRegistry = new ResourceRegistry();
                this.referenceRegistry = new ReferenceRegistry(container, this.resourceRegistry);
                this.overlayTextChecker = new OverlayTextChecker();
            }
            return this;
        }

        public ValidationContextBuilder pubTypes(Set<PublicationType> pubTypes) {
            this.pubTypes = pubTypes;
            return this;
        }

        public ValidationContextBuilder properties(Set<Property> properties) {
            this.properties = ImmutableSet.builder();
            if (properties != null) {
                this.properties.addAll(properties);
            }
            return this;
        }

        public ValidationContextBuilder addProperty(Property property) {
            this.properties.add((Object)((Property)Preconditions.checkNotNull((Object)property)));
            return this;
        }

        public ValidationContext build() {
            return new ValidationContext(this);
        }
    }

    public static final class ValidationContextPredicates {
        public static Predicate<ValidationContext> hasProp(final Property property) {
            return new Predicate<ValidationContext>(){

                public boolean apply(ValidationContext input) {
                    return input.properties.contains(property);
                }
            };
        }

        public static Predicate<ValidationContext> hasPubType(final PublicationType type) {
            return new Predicate<ValidationContext>(){

                public boolean apply(ValidationContext input) {
                    return input.pubTypes.contains((Object)type);
                }
            };
        }

        public static Predicate<ValidationContext> mimetype(final String mimetype) {
            return new Predicate<ValidationContext>(){

                public boolean apply(ValidationContext input) {
                    return input.mimeType.equals(mimetype);
                }
            };
        }

        public static Predicate<ValidationContext> path(final String path) {
            return new Predicate<ValidationContext>(){

                public boolean apply(ValidationContext input) {
                    return input.path.equals(path);
                }
            };
        }

        public static Predicate<ValidationContext> profile(final EPUBProfile profile) {
            return new Predicate<ValidationContext>(){

                public boolean apply(ValidationContext input) {
                    return input.profile.equals((Object)profile);
                }
            };
        }

        public static Predicate<ValidationContext> version(final EPUBVersion version) {
            return new Predicate<ValidationContext>(){

                public boolean apply(ValidationContext input) {
                    return input.version.equals((Object)version);
                }
            };
        }

        private ValidationContextPredicates() {
        }
    }
}

