import json
import os


MUSIC_DIR = '/mnt/us/music'
PLAYING = os.path.isfile('/var/tmp/PLAYING')
PAUSED = os.path.isfile('/var/tmp/PAUSED')
SHUFFLE = os.path.isfile('/var/tmp/SHUFFLE')
RADIO = os.path.isfile('/var/tmp/RADIO')

menu = dict()
menu['items'] = []
entry = {
    "name": "Sox Media Player v2",
    "priority": 0,
    "items": []
    }
menu['items'].append(entry)

priority = 2
if not PLAYING:
    main_menu = [
        {
            "name": "Play Everything",
            "priority": 1,
            "action": "./play.sh",
            "params": MUSIC_DIR,
            "refresh": True,
            "exitmenu": False,
            "status": False,
            "internal": "status Play Everything"
        }
    ]
    subdirectories = [i[0] for i in os.walk(MUSIC_DIR)]
    for subdir in subdirectories[1:]:
        main_menu.append({
            "name": f"Play {subdir.split('/')[-1]}",
            "priority": priority,
            "action": "./play.sh",
            "params": f'"{subdir}"',
            "refresh": True,
            "exitmenu": False,
            "status": False,
            "internal": f"status Play {subdir}"
        })
        priority += 1
    if os.path.isfile(f'{MUSIC_DIR}/radio.txt'):
        radios = {
            "name": "Radio",
            "priority": priority,
            "items": []
        }
        with open(f'{MUSIC_DIR}/radio.txt', 'r') as f:
            radio_priority = 1
            for line in f.readlines():
                if line.strip() == '':
                    continue
                radios['items'].append({
                    "name": line.split(';')[0],
                    "priority": radio_priority,
                    "action": "./play_internet_radio.sh",
                    "params": f"mp3 {line.split(';', 1)[1].strip()}",
                    "refresh": True,
                    "exitmenu": False,
                    "status": False,
                    "internal": "status Playing Radio"
                })
                radio_priority += 1
        main_menu.append(radios)
    main_menu.append({
            "name": "Reload Menu",
            "priority": priority + 2,
            "action": "./reload_menu.sh",
            "refresh": True,
            "params": "",
            "exitmenu": False,
            "status": False,
            "internal": "status Stop"
        })
elif RADIO:
    main_menu = [{
            "name": "Stop",
            "priority": 4,
            "action": "./stop.sh",
            "refresh": True,
            "params": "",
            "exitmenu": False,
            "status": False,
            "internal": "status Stop"
        }
    ]
else:
    main_menu = [
        {
            "name": "Pause/Resume",
            "priority": 1,
            "action": "./toggle_play.sh",
            "params": "",
            "exitmenu": False,
            "status": False,
            "internal": "status Toggle Playback"
        }
    ]
    main_menu.append({
            "name": f"Shuffle ({SHUFFLE})",
            "priority": 2,
            "action": "./toggle_shuffle.sh",
            "params": "",
            "refresh": True,
            "exitmenu": False,
            "status": False,
            "internal": "status Next Track"
        })
    main_menu.append({
            "name": "Next Track",
            "priority": 3,
            "action": "./next_track.sh",
            "params": "",
            "exitmenu": False,
            "status": False,
            "internal": "status Next Track"
        })
    main_menu.append({
            "name": "Stop",
            "priority": 4,
            "action": "./stop.sh",
            "refresh": True,
            "params": "",
            "exitmenu": False,
            "status": False,
            "internal": "status Stop"
        })
    priority = 5
volume_settings = {
            "name": "Volume",
            "priority": priority + 1,
            "items": []
        }
for i in range(1, 11, 1):
    volume_settings['items'].append({
            "name": f"{i*10}%",
            "priority": i,
            "action": "./volume.sh",
            "params": f"{i/10}",
            "refresh": True,
            "exitmenu": False,
            "status": False,
            "internal": "status Volume"
        })
main_menu.append(volume_settings)
menu['items'][0]['items'] = main_menu
with open('/mnt/us/extensions/sox/menu.json', 'w') as f:
    f.write(json.dumps(menu, indent=4))
    
