#!/bin/sh
# Play all audio files in selected directory (robust, HF/KUAL style)

# Combine all params for folder name (handles spaces from menu)
MUSICDIR="$*"
[ -z "$MUSICDIR" ] && MUSICDIR="/mnt/us/music"

BOOKMARK_FILE="/var/tmp/bookmark_$(echo "$MUSICDIR" | sed 's|/|_|g')"
PROGRESS_FILE="/var/tmp/progress_$(echo "$MUSICDIR" | sed 's|/|_|g')"

PLAYLIST_FILE="/var/tmp/playlist.m3u"

# Build playlist of all supported audio files
find "$MUSICDIR" -type f -regex '.*\.\(3gp\|aac\|flac\|ogg\|m3u\|m4a\|mp3\|pls\|wav\|wma\)' | sort > "$PLAYLIST_FILE"

export LD_LIBRARY_PATH=/mnt/us/extensions/sox/library:$LD_LIBRARY_PATH

offset=0
if [ -s "$BOOKMARK_FILE" ]; then
   offset=`cat "$BOOKMARK_FILE"`
   mv -f "$BOOKMARK_FILE" "$PROGRESS_FILE"
fi

driver="unknown"
which gst-launch >/dev/null && driver="gst"
which aplay >/dev/null && aplay /mnt/us/extensions/sox/silence.wav 2>/dev/null && driver="alsa"

case "$driver" in

     alsa)
     echo "Playing via ALSA."
     date +"%s" >/var/tmp/started
     /mnt/us/extensions/sox/sox "$PLAYLIST_FILE" -t wav - trim $offset | aplay&
     ;;

     gst)
     echo "Playing via Gstreamer"
     filename=`head -n 1 "$PLAYLIST_FILE"`
     /mnt/us/extensions/sox/soxi "$filename" >/var/tmp/soxidata.txt
     Chan=$(awk -F: '/Channels/ {gsub(" ","");print $2}' /var/tmp/soxidata.txt)
     Wide=$(awk -F: '/Precision/ {gsub(" ","");gsub("-bit","");print $2}' /var/tmp/soxidata.txt)
     Rate=$(awk -F: '/Sample Rate/ {gsub(" ","");print $2}' /var/tmp/soxidata.txt)
     rm /var/tmp/soxidata.txt
     date +"%s" >/var/tmp/started
     /mnt/us/extensions/sox/sox "$PLAYLIST_FILE" -t raw - trim $offset |  /usr/bin/gst-launch \
     filesrc location=/dev/stdin \
     ! audio/x-raw-int, \
       endianness='(int)'1234, \
       signed='(boolean)'true, \
       width='(int)'$Wide, \
       depth='(int)'$Wide, \
       rate='(int)'$Rate, \
       channels='(int)'$Chan \
     ! queue \
     ! mixersink&
     ;;

     *)
     echo "Unknown sound driver, cannot play media."
     ;;
esac
