#!/bin/sh
# script to kill the sox stream playing and save a bookmark (per-folder version)

# Accept all params as folder (handles spaces from KUAL menu)
MUSICDIR="$*"
[ -z "$MUSICDIR" ] && MUSICDIR="/mnt/us/music"

BOOKMARK_FILE="/var/tmp/bookmark_$(echo "$MUSICDIR" | sed 's|/|_|g')"
PROGRESS_FILE="/var/tmp/progress_$(echo "$MUSICDIR" | sed 's|/|_|g')"

killall sox

progress=0

# Read progress for this folder if available
if [ -s "$PROGRESS_FILE" ]
   then
   progress=`cat "$PROGRESS_FILE"`
fi

# Only save bookmark if playback was actually started
if [ -s /var/tmp/started ]
   then
   started=`cat /var/tmp/started`
   ended=`date +"%s"`
   elapsed=`expr $progress + $ended - $started`
   echo $elapsed >"$BOOKMARK_FILE"
else
   echo $progress >"$BOOKMARK_FILE"
fi
