# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2016, 2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.14"   # Qt.core

import re

from qt.core import (Qt, QMimeData, QDialog, QDrag, QLabel,  QFont, QWidget,
                                       QIcon, QGridLayout, QGroupBox, QMargins, QScrollArea,
                                       QSize, QPushButton, QVBoxLayout, QHBoxLayout)

from calibre.constants import DEBUG
from calibre.gui2 import gprefs

from polyglot.builtins import as_unicode

#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):

    initial_extra_size = QSize(100, 100)

    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent)
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)

    def resize_dialog(self):
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)

    def save_dialog_geometry(self):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class DropSearchResultsDialog(SizePersistedDialog):

    def __init__(self,gui,icon,process_file_paths):

        parent = gui

        unique_pref_name = 'dropsearchresults:gui_parameters_dialog'

        SizePersistedDialog.__init__(self, parent, unique_pref_name)

        self.gui = gui

        self.process_file_paths = process_file_paths

        QWidget.__init__(self)

        self.setWindowFlags(Qt.WindowStaysOnTopHint)

        self.setAcceptDrops(True)

        self.setWindowTitle('Drop Search Results')
        self.setWindowIcon(icon)

        self.layout_top = QVBoxLayout()
        self.layout_top.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout_top)

        self.setToolTip("<p style='white-space:wrap'>Drop the full paths for Calibre books that already exist in the current Calibre library anywhere within this dialog box.")

        #-----------------------------------------------------
        self.scroll_area_frame = QScrollArea()
        self.scroll_area_frame.setAlignment(Qt.AlignCenter)
        self.scroll_area_frame.setWidgetResizable(True)
        self.scroll_area_frame.ensureVisible(200,200)

        self.layout_top.addWidget(self.scroll_area_frame)       # the scroll area is now the child of the parent of self.layout_top

        # NOTE: the self.scroll_area_frame.setWidget(self.scroll_widget) is at the end of the init() AFTER all children have been created and assigned to a layout...

        #-----------------------------------------------------
        self.scroll_widget = QWidget()
        self.layout_top.addWidget(self.scroll_widget)           # causes automatic reparenting of QWidget to the parent of self.layout_top, which is:  self .
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setAlignment(Qt.AlignCenter)

        self.scroll_widget.setLayout(self.layout_frame)        # causes automatic reparenting of any widget later added to self.layout_frame to the parent of self.layout_frame, which is:  QWidget .
        #-----------------------------------------------------
        self.paths_groupbox = QGroupBox('')
        self.layout_frame.addWidget(self.paths_groupbox)

        self.paths_layout = QGridLayout()
        self.paths_groupbox.setLayout(self.paths_layout)

        font = QFont()

        font.setBold(True)
        font.setPointSize(10)

        self.drop_label = QLabel()
        self.drop_label.setTextFormat(Qt.RichText)
        self.drop_label.setText(" ")
        self.drop_label.setFont(font)
        self.paths_layout.addWidget(self.drop_label,0,0)
        self.drop1_label = QLabel()
        self.drop1_label.setTextFormat(Qt.RichText)
        self.drop1_label.setText("<center><font color='#0404B4'>Drop Search Result File-Paths Here</font></center>")
        self.drop1_label.setFont(font)
        self.paths_layout.addWidget(self.drop1_label,2,0)
        self.drop2_label = QLabel()
        self.drop2_label.setTextFormat(Qt.RichText)
        self.drop2_label.setText(" ")
        self.drop2_label.setFont(font)
        self.paths_layout.addWidget(self.drop2_label,4,0)

        font.setBold(False)
        font.setPointSize(6)

        self.drop_bottom__label = QLabel()
        self.drop_bottom__label.setTextFormat(Qt.RichText)
        self.drop_bottom__label.setText(" ")
        self.drop_bottom__label.setFont(font)
        self.layout_frame.addWidget(self.drop_bottom__label)

        self.layout_pushbutton = QHBoxLayout()
        self.layout_pushbutton.setSpacing(0)
        self.layout_pushbutton.setAlignment(Qt.AlignCenter)
        self.layout_frame.addLayout(self.layout_pushbutton)

        self.push_button_save_geometry = QPushButton(" ", self)
        self.push_button_save_geometry.setText("Save")
        self.push_button_save_geometry.clicked.connect(self.save_current_geometry)
        self.push_button_save_geometry.setFont(font)
        self.push_button_save_geometry.setMaximumWidth(100)
        self.push_button_save_geometry.setToolTip("<p style='white-space:wrap'>Save the current size of this dialog box.")
        self.layout_pushbutton.addWidget(self.push_button_save_geometry)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_widget.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.setWidget(self.scroll_widget)    # now that all widgets have been created and assigned to a layout...
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())

        self.resize_dialog()

        self.setAttribute(Qt.WA_DeleteOnClose)

    #----------------------------------------------------
    def dragEnterEvent(self, e):

        if e.mimeData().hasText():    # http://doc.qt.io/qt-5.5/qmimedata.html
            e.accept()
        else:
            e.ignore()
    #----------------------------------------------------
    def dropEvent(self, e):

        self.drop_label.setText("Drop Received; Processing...")
        self.repaint()

        data = e.mimeData().text()
        self.convert_mime_data(data)
    #----------------------------------------------------
    def convert_mime_data(self,data):
        data = as_unicode(data)
        book_list = []
        if data.count("file:") > 0:     # standard MIME drag-and-drop format  for files:    file:///s:/.....
            file_list = data.split("file:")
            if len(file_list) > 0:
                my_re = "[(][0-9]+[)][/]"
                p = re.compile(my_re)
                for path in file_list:
                    path = path.strip()
                    match_book_id = p.search(path)
                    if match_book_id:
                        s = match_book_id.group(0)
                        s = s.replace("(","")
                        s = s.replace(")","")
                        s = s.replace("/","")
                        s = s.strip()
                        row = s,path
                        book_list.append(row)
                #END FOR
        else:
            if DEBUG: print(as_unicode(data))  # do nothing, but can inspect the data format if desired...

        self.hide()

        self.process_file_paths(book_list)
    #----------------------------------------------------
    def save_current_geometry(self):
        self.save_dialog_geometry()
    #----------------------------------------------------
#END OF drop_widget_dialog.py