# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2016, 2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.14"   # Qt.core

from calibre.customize import InterfaceActionBase
    #--------------------------------------------------------------------------------------------------------------------------
class ActionBaseDropSearchResults(InterfaceActionBase):

    name                    = 'Drop Search Results'
    description           = "Drag-and-Drop Search Results from most search software (e.g. 'Agent Ransack', 'X1', Windows Search) into Calibre so that the books that were found can be automatically marked and displayed."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST [No Maint]'
    version                 = (1, 0, 15)
    minimum_calibre_version = (6, 0, 0)

    actual_plugin       = 'calibre_plugins.drop_search_results.ui:ActionDropSearchResults'

    gui_name = 'Drop Search Results'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return False
    #--------------------------------------------------------------------------------------------------------------------------
#END of __init__py