#----------------------------
#import requests
from mechanize import Request
import json
import urllib.parse

#def fetch_openlibrary_metadata(identifier):
def oclc_classify_webscraping_stdnbr(paramtype, paramvalue):
    """
    Given an ISBN or ISSN identifier, fetches metadata from Open Library's API,
    including classification codes (LCC and DDC), subject headings (e.g., LCSH),
    and URLs for the MARC records.
    
    Returns a dictionary with the keys:
      - "lc_classifications": List of Library of Congress classifications
      - "dewey_decimal_class": List of Dewey Decimal Classification codes
      - "subjects": List of subject headings
      - "classifications": The raw classifications dictionary, if needed
      - "marc_urls": List of MARC record URLs (plain and XML versions)
      
    If no data is found or an error occurs, returns None.
    """
    # Clean the identifier: remove hyphens and spaces.
    #id_clean = identifier.replace("-", "").replace(" ", "")
    id_clean = paramvalue

    time.sleep(1.6)
    ddc_return = "NONE"
    lcc_return = "NONE"
    fast_return_list = []
    oclc_owi_return = "NONE"
    oclc_wi_return = "NONE"
    oclc_worldcat_return = "NONE"
    viaf_author_id_return = "NONE"

    # Determine if identifier is ISSN or ISBN.
    # ISSN is typically 8 characters (digits, possibly with a trailing 'X'),
    # while ISBN is usually 10 or 13 characters.
    if (len(id_clean) == 8 and 
        id_clean[:-1].isdigit() and 
        (id_clean[-1].isdigit() or id_clean[-1].upper() == "X")):
        key_prefix = "ISSN"
        if DEBUG: print("Identifier is ISSN")
    else:
        key_prefix = "ISBN"
        if DEBUG: print("Identifier is ISBN")
        
    bibkey = f"{key_prefix}:{id_clean}"
    
    # Call the Open Library API.
    api_url = "https://openlibrary.org/api/books"
    params = {
        "bibkeys": bibkey,
        "format": "json",
        "jscmd": "data"
    }
    
    # Construct the full URL with query parameters.
    full_url = f"{api_url}?{urllib.parse.urlencode(params)}"

    br = browser()
    try:
        response = br.open(full_url)
        response_data = response.read().decode('utf-8')
        data = json.loads(response_data)
    except Exception as e:
        if DEBUG: print(f"Error fetching data from Open Library: {e}")
        return None

    if bibkey not in data:
        if DEBUG: print(f"No data found for {bibkey}")
        return None

    book_data = data[bibkey]
    
    # Extract classification data.
    classifications = book_data.get("classifications", {})
    lc_classifications = classifications.get("lc_classifications", [])
    dewey_decimal_class = classifications.get("dewey_decimal_class", [])

    if DEBUG: print(f"classifications: {classifications}")
    if DEBUG: print(f"lc_classifications: {lc_classifications}")
    if DEBUG: print(f"dewey_decimal_class: {dewey_decimal_class}")
    
    # Extract subjects (subject headings). In some cases, subjects may be provided
    # as a list of dictionaries with a 'name' key or as simple strings.
    subjects_raw = book_data.get("subjects", [])
    subjects = []
    for subj in subjects_raw:
        if isinstance(subj, dict):
            subjects.append(subj.get("name", ""))
        elif isinstance(subj, str):
            subjects.append(subj)
    subjects = [s for s in subjects if s]  # Filter out any empty strings.
    
    # Determine MARC record URLs using the book's key.
    marc_urls = []
    if "key" in book_data:
        # Example key: "/books/OL123456M"
        book_key = book_data["key"]
        base_url = "https://openlibrary.org"
        #marc_url = f"{base_url}{book_key}.marc"
        #marc_xml_url = f"{base_url}{book_key}.marc.xml"
        #marc_urls.extend([marc_url, marc_xml_url])
        marc_urls = [f"{base_url}{book_key}.marc", f"{base_url}{book_key}.marc.xml"]
    
    # Construct the metadata dictionary to return.
    metadata = {
        "lc_classifications": lc_classifications,
        "dewey_decimal_class": dewey_decimal_class,
        "subjects": subjects,
        "classifications": classifications,
        "marc_urls": marc_urls
    }

    if DEBUG: print(f"metadata variable: {metadata}")

    ddc_return = dewey_decimal_class[0]
    lcc_return = max(lc_classifications, key=lambda s: s.count(' '))
    fast_return_list = subjects
    
    return ddc_return, lcc_return, fast_return_list, oclc_owi_return, oclc_wi_return, oclc_worldcat_return, viaf_author_id_return
    #return metadata

#----------------------------
