# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.62"  # Miscellany

from qt.core import (Qt, QDialog, QFont, QIcon, QGridLayout, QGroupBox, QLabel, QMargins, QVBoxLayout, QWidget)

from calibre.utils.config import JSONConfig

from polyglot.builtins import as_unicode

S_FALSE = as_unicode("False")
S_TRUE = as_unicode("True")

# This is where all preferences for this plugin are stored
prefs = JSONConfig('plugins/Library Codes')

# Set defaults
prefs.defaults['DDC'] = as_unicode("#ddc")
prefs.defaults['LCC'] = as_unicode("#lcc")
prefs.defaults['FAST'] = as_unicode("#fast")
prefs.defaults['OCLC_OWI'] = as_unicode("#oclc_owi")

prefs.defaults['DDC_IS_ACTIVE'] = as_unicode(S_FALSE)
prefs.defaults['LCC_IS_ACTIVE'] = as_unicode(S_FALSE)
prefs.defaults['FAST_IS_ACTIVE'] = as_unicode(S_FALSE)
prefs.defaults['OCLC_OWI_IS_ACTIVE'] = as_unicode(S_FALSE)

prefs.defaults['OCLC_OWI_IDENTIFIER'] = as_unicode(S_TRUE)  # if this is True, then all 3+ possible Identifiers are added, not just this one.

prefs.defaults['GENRE'] = as_unicode("#lc_genre")
prefs.defaults['GENRE_DDC_IS_ACTIVE'] = as_unicode(S_FALSE)
prefs.defaults['GENRE_LCC_IS_ACTIVE'] = as_unicode(S_FALSE)
prefs.defaults['GENRE_IS_INACTIVE'] = as_unicode(S_TRUE)
prefs.defaults['GENRE_EXACT_MATCH'] = as_unicode(S_TRUE)
prefs.defaults['GENRE_LCC_MATCH_LENGTH'] = 2

class ConfigWidget(QWidget):

    def __init__(self):

        QWidget.__init__(self)

        self.layout_1 = QVBoxLayout()
        self.setLayout(self.layout_1)

        self.layout_1.setSpacing(0)
        self.layout_1.setContentsMargins(QMargins(0,0,0,0));

        self.paths_groupbox = QGroupBox('Preferences')
        self.layout_1.addWidget(self.paths_groupbox)

        self.paths_layout = QGridLayout()
        self.paths_groupbox.setLayout(self.paths_layout)

        font = QFont()

        font.setBold(False)
        font.setPointSize(10)

        self.label1 = QLabel()
        self.label1.setTextFormat(Qt.RichText)
        self.label1.setText("<center><font color='#0404B4'>               Please Customize Directly Within Library Codes             </font></center>")
        self.label1.setFont(font)
        self.paths_layout.addWidget(self.label1)

        self.resize(self.sizeHint())

    def save_settings(self):
        return
    def validate(self):
        return False
#END of config.py

