#!/bin/sh
EXTENSION=/mnt/us/extensions/inkwell
SRC="$EXTENSION/bin/inkwell.py"
COMPILED="$EXTENSION/bin/inkwell.pyc"

DPI=`cat /var/log/Xorg.0.log | grep DPI | sed -n 's/.*(\([0-9]\+\), [0-9]\+).*/\1/p'`
#use different layouts for high resolution devices
if [ ${DPI} -gt 290 ]; then
  PARAM="-l ${EXTENSION}/layouts/keyboard-300dpi.xml"
elif [ ${DPI} -gt 200 ]; then
  PARAM="-l ${EXTENSION}/layouts/keyboard-200dpi.xml"
else
  PARAM="-l ${EXTENSION}/layouts/keyboard.xml"
fi
export TERM=xterm TERMINFO=${EXTENSION}/vte/terminfo

#if [ ! -f "$COMPILED" ] || [ "$SRC" -nt "$COMPILED" ]; then
if [ ! -f "$COMPILED" ]; then
    #echo "compile $SRC to $COMPILED"
    python3 -c "import py_compile; py_compile.compile('$SRC', cfile='$COMPILED')"
fi

WIFI_WAS_OFF=0
if [ 0 -eq `lipc-get-prop com.lab126.cmd wirelessEnable` ]; then
  lipc-set-prop com.lab126.cmd wirelessEnable 1
  WIFI_WAS_OFF=1
fi

${EXTENSION}/bin/kterm ${PARAM} "$@"

if [ 1 -eq $WIFI_WAS_OFF ] && [ 1 -eq `lipc-get-prop com.lab126.cmd wirelessEnable` ]; then
  lipc-set-prop com.lab126.cmd wirelessEnable 0
fi
