#!/Python35/python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, division, absolute_import, print_function

#********************************************************************************#
#                                                                                #
# MIT Licence(OSI)                                                               #
# Copyright (c) 2017 Bill Thompson                                               #
#                                                                                #
# Permission is hereby granted, free of charge, to any person obtaining a copy   # 
# of this software and associated documentation files (the "Software"), to deal  # 
# in the Software without restriction, including without limitation the rights   #
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell      #
# copies of the Software, and to permit persons to whom the Software is          #
# furnished to do so, subject to the following conditions:                       # 
#                                                                                #
# The above copyright notice and this permission notice shall be included in all #
# copies or substantial portions of the Software.                                #
#                                                                                # 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR     # 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,       #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE    #
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER         # 
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  # 
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE  # 
# SOFTWARE.                                                                      #
#                                                                                #  
#********************************************************************************#


import os, os.path, sys, codecs, shutil, inspect, time, threading
from os.path import expanduser
from xml.sax.saxutils import escape
#from html import unescape
from tempfile import mkdtemp                 
from updater import updateCheck
import options
from cutils import *


PLUGIN_PATH = ''
SITE_URL = "https://www.mobileread.com/forums/showpost.php?p=3738421&postcount=1"
PLUGIN_PATH = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))


def isValidEpubData(bk):
    files = []
    css_list = []   
    valid_data = True 
    
    # get a list of xhtml files
    for id, fname in bk.text_iter():
        files.append(fname)

    # get a list of css files      
    for id, css in bk.css_iter():
        css_list.append(css)
        
    # check epub for valid data    
    if (len(files) == 1 and len(css_list) == 0) or \
        files[0] == 'Section0001.xhtml':
        valid_data = False
    
    return(valid_data)
    
# borrowed from Diap with thanks...    
def is_connected():
    try:
        sock = socket.create_connection(('8.8.8.8', 53), 1)
        sock.close()
        return True
    except:
        pass
        
    return False    
    
def run(bk):
    print('Python version: ', sys.version, '\n')
    print('Running KDPValidator...\n')
    
    # check for new plugin versions
    if is_connected():
        latest_version, installed_version = updateCheck(SITE_URL, PLUGIN_PATH)
        if latest_version and latest_version != installed_version:
            options.NEW_PLUGIN_VERSION = True
            options.MSG_NEW_VERSION_AVAILABLE = " A new version of this plugin is now available from MR - v" + latest_version 
    
    # check for correct python version
    if bk.launcher_version() < 20160130:
        msg = "This plugin requires Sigil v0.9.3 or later"
        print('>>> Error: ' + msg + '\n\nAbort plugin...')  
        show_msgbox('Incompatible Sigil Version', msg, msgtype="error")
        options.SYS_EXIT = True
        return(0)
        
    # epub 2 only
    epubversion = "2.0"
    if bk.launcher_version() >= 20160102:
        epubversion = bk.epub_version()
    if epubversion.startswith("3"):
        msg = "Epub 3.0 ebooks are not supported. This plugin requires a valid epub 2.0 ebook as input. " + \
              "Please try again."        
        show_msgbox('Incompatible Epub Version', msg, msgtype="error")
        return(-1)

    # check epub for valid data    
    if isValidEpubData(bk) == False:
        msg = "Epub contains no data. Please try again."
        print('>>> Error: ' + msg + '\n\n>>> Abort plugin...')             
        show_msgbox('Incompatible Epub Version', msg, msgtype="error")
        return(-1)             
        
    # initialize prefs
    # allows plugin user to switch 
    # off warnings via prefs
    prefs = bk.getPrefs()
    if 'missing_guide_refs_warning' not in prefs:
        prefs['missing_guide_refs_warning'] = True
    if 'too_many_guide_refs_warning' not in prefs:
        prefs['too_many_guide_refs_warning'] = True    
    if 'cover_file_warning' not in prefs:
        prefs['cover_file_warning'] = True
    if 'dual_format_warning' not in prefs:
        prefs['dual_format_warning'] = True  
    if 'heading_styles_not_found_warning' not in prefs:
        prefs['heading_styles_not_found_warning'] = True
    if 'absolute_values_warning' not in prefs:
        prefs['absolute_values_warning'] = True    
    if 'missing_p_style_declarations_warning' not in prefs:
        prefs['missing_p_style_declarations_warning'] = True        
    if 'missing_body_style_warning' not in prefs:
        prefs['missing_body_style_warning'] = True     
    if 'missing_body_declarations_warning' not in prefs:
        prefs['missing_body_declarations_warning'] = True        
    if 'logical_toc_warning' not in prefs:
        prefs['logical_toc_warning'] = True
    if 'svg_warning' not in prefs:
        prefs['svg_warning'] = True    
    bk.savePrefs(prefs)            

    # create a working directory
    WDIR = mkdtemp()
    
    KDPEpubValidation(bk, WDIR)
    
    # display results in validation panel. 
    results = options.RESULTS
    for result in results:
        severity, base_file, line_num, message = result
        
        try:
            bk.add_result(severity, escape(base_file), line_num, escape(message).replace('"', '&quot;'))   
        except Exception:
            raise
            cleanExit(WDIR)
            return(-1)            
        
    # inform user if new plugin version is available
    if options.NEW_PLUGIN_VERSION == True:
        msg = options.MSG_NEW_VERSION_AVAILABLE
        show_msgbox('KDPValidator', msg, msgtype='info')  
    
    cleanExit(WDIR)
    return(0)

def main():
    print('I reached main when I should not have\n')
    return(-1)

if __name__ == "__main__":
    sys.exit(main())                   