/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2xhtml.office.IndexMark;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.util.Misc;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.IndexConverterHelper;
import writer2xhtml.xhtml.IndexData;
import writer2xhtml.xhtml.UserEntry;
import writer2xhtml.xhtml.XhtmlConfig;

class UserIndexConverter
extends IndexConverterHelper {
    private static final String USER_LINK_PREFIX = "usr";
    private List<UserEntry> userEntries = new ArrayList<UserEntry>();
    private int nUserIndex = -1;

    UserIndexConverter(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        super(ofr, config, converter, "text:user-index-source");
    }

    void handleUserMark(Node onode, Node hnode, int nChapterNumber) {
        hnode.appendChild(this.converter.createTarget(USER_LINK_PREFIX + ++this.nUserIndex));
        UserEntry entry = new UserEntry();
        entry.onode = (Element)onode;
        entry.nChapterNumber = nChapterNumber;
        entry.nFileIndex = this.converter.getOutFileIndex();
        this.userEntries.add(entry);
    }

    @Override
    void generate(IndexData data) {
        Element onode = data.onode;
        String sIndexName = data.onode.getAttribute("text:index-name");
        Element ul = data.hnode;
        String[] sEntryStyleName = this.getEntryStyleName(onode);
        int nLen = this.userEntries.size();
        for (int i = 0; i < nLen; ++i) {
            UserEntry entry = this.userEntries.get(i);
            String sEntryIndexName = Misc.getAttribute(entry.onode, "text:index-name");
            if (sEntryIndexName != null && !sEntryIndexName.equals(sIndexName)) continue;
            int nLevel = Misc.getPosInteger(entry.onode.getAttribute("text:outline-level"), 1);
            Element p = this.createEntry(ul, sEntryStyleName[nLevel]);
            Element a = this.converter.createLink(USER_LINK_PREFIX + i);
            p.appendChild(a);
            a.appendChild(this.converter.createTextNode(IndexMark.getIndexValue(entry.onode)));
        }
        if (this.config.indexLinks()) {
            Element title = Misc.getChildByTagName(onode, "text:index-title-template");
            String sTitle = title != null ? Misc.getPCDATA(title) : "User Index";
            this.converter.addContentEntry(sTitle, 1, this.converter.getTarget(Misc.getAttribute(onode.getParentNode(), "text:name")));
        }
    }

    private String[] getEntryStyleName(Element source) {
        String[] sStyleName = new String[11];
        for (Node child = source.getFirstChild(); child != null; child = child.getNextSibling()) {
            int nLevel;
            if (child.getNodeType() != 1 || !child.getNodeName().equals("text:user-index-entry-template") || 1 > (nLevel = Misc.getPosInteger(Misc.getAttribute(child, "text:outline-level"), 0)) || nLevel > 10) continue;
            sStyleName[nLevel] = Misc.getAttribute(child, "text:style-name");
        }
        return sStyleName;
    }

    private Element createEntry(Element ul, String sStyleName) {
        Element li = this.converter.createElement("li");
        ul.appendChild(li);
        return this.getTextCv().createParagraph(li, sStyleName);
    }
}

