/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.OfficeStyleFamily;
import writer2xhtml.office.StyleWithProperties;
import writer2xhtml.util.ExportNameCollection;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.ConverterHelper;
import writer2xhtml.xhtml.StyleInfo;
import writer2xhtml.xhtml.XhtmlConfig;
import writer2xhtml.xhtml.XhtmlStyleMap;

public abstract class StyleConverterHelper
extends ConverterHelper {
    protected ExportNameCollection styleNames = new ExportNameCollection(true);
    protected XhtmlStyleMap styleMap;
    protected boolean bConvertStyles = true;
    protected boolean bConvertHard = true;
    protected int nType;

    public StyleConverterHelper(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter);
        this.nType = nType;
    }

    protected static void applyDirection(StyleWithProperties style, StyleInfo info) {
        String sDir = style.getProperty("style:writing-mode");
        if ("lr-tb".equals(sDir)) {
            info.sDir = "ltr";
        } else if ("rl-tb".equals(sDir)) {
            info.sDir = "rtl";
        }
    }

    protected static void applyLang(StyleWithProperties style, StyleInfo info) {
        String sLang = style.getProperty("fo:language");
        String sCountry = style.getProperty("fo:country");
        if (sLang != null) {
            info.sLang = sCountry == null || sCountry.equals("none") ? sLang : sLang + "-" + sCountry;
        }
    }

    public abstract OfficeStyleFamily getStyles();

    public abstract String getStyleDeclarations(String var1);
}

