/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import writer2xhtml.base.BinaryGraphicsDocument;
import writer2xhtml.office.FontDeclaration;
import writer2xhtml.office.ListStyle;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.OfficeStyleFamily;
import writer2xhtml.office.StyleWithProperties;
import writer2xhtml.util.CSVList;
import writer2xhtml.util.Calc;
import writer2xhtml.util.Misc;
import writer2xhtml.util.StringComparator;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.StyleConverterHelper;
import writer2xhtml.xhtml.StyleInfo;
import writer2xhtml.xhtml.XhtmlConfig;
import writer2xhtml.xhtml.XhtmlStyleMapItem;

public class ListStyleConverter
extends StyleConverterHelper {
    private int nListFormatting;
    private boolean bHasListHeaders = false;
    private Map<String, Integer> listDepth = new HashMap<String, Integer>();
    private Set<String> listStyles = new HashSet<String>();
    private Map<String, Set<String>> listParStyles = new HashMap<String, Set<String>>();

    public ListStyleConverter(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        this.styleMap = config.getXListStyleMap();
        this.nListFormatting = config.listFormatting();
        this.bConvertHard = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 1;
    }

    public void applyStyle(int nLevel, String sStyleName, String sCounterReset, String sParStyleName, StyleInfo info) {
        this.updateLevel(nLevel, sStyleName);
        ListStyle style = this.ofr.getListStyle(sStyleName);
        if (style != null) {
            if (this.nListFormatting == 3 || this.nListFormatting == 2) {
                this.applyExplicitCounterReset(style, nLevel, sCounterReset, info);
            }
            if (this.styleMap.contains(style.getDisplayName())) {
                this.applyStyleMap(style, info);
            } else if (this.nListFormatting == 3) {
                if (sParStyleName != null) {
                    StyleWithProperties parStyle = this.ofr.getParStyle(sParStyleName);
                    if (parStyle != null && parStyle.isAutomatic() && (!this.bConvertHard || parStyle.getParProperty("fo:margin-left", false) == null && parStyle.getParProperty("fo:text-indent", false) == null && parStyle.getTabStops(false).isEmpty())) {
                        parStyle = (StyleWithProperties)parStyle.getParentStyle();
                    }
                    info.sClass = this.getExtendedClassName(style, nLevel, parStyle);
                    this.listParStyles.computeIfAbsent(style.getDisplayName(), key -> new HashSet()).add(parStyle.getDisplayName());
                } else {
                    info.sClass = this.getClassName(style, nLevel);
                    this.listStyles.add(sStyleName);
                }
            } else if (this.nListFormatting == 2 || this.nListFormatting == 1 || !style.isAutomatic()) {
                info.sClass = this.getClassName(style, nLevel);
                this.listStyles.add(sStyleName);
            }
        }
    }

    private void applyExplicitCounterReset(ListStyle style, int nLevel, String sCounterReset, StyleInfo info) {
        if ("none".equals(sCounterReset)) {
            info.props.addValue("counter-reset", "none");
        } else if (sCounterReset != null) {
            info.props.addValue("counter-reset", this.getClassName(style, nLevel) + " " + Integer.toString(Misc.getPosInteger(sCounterReset, 1) - 1));
        }
    }

    private void applyStyleMap(ListStyle style, StyleInfo info) {
        XhtmlStyleMapItem map = this.styleMap.get(style.getDisplayName());
        if (map.sElement.length() > 0) {
            info.sTagName = map.sElement;
        }
        if (!"(none)".equals(map.sCss)) {
            info.sClass = map.sCss;
        }
    }

    public void applyUnnumberedItemStyle(String sStyleName, StyleInfo info) {
        ListStyle style = this.ofr.getListStyle(sStyleName);
        if (style != null && this.nListFormatting != 0) {
            info.sClass = "no_label";
            this.bHasListHeaders = true;
        }
    }

    @Override
    public String getStyleDeclarations(String sIndent) {
        if (this.nListFormatting == 3) {
            return this.getFullStyleDeclarations(sIndent);
        }
        if (this.nListFormatting == 2) {
            return this.getLabelStyleDeclarations(sIndent);
        }
        if (this.nListFormatting == 1) {
            return this.getCSS1StyleDeclarations(sIndent);
        }
        return "";
    }

    private String getFullStyleDeclarations(String sIndent) {
        ListStyle listStyle;
        StringBuilder buf = new StringBuilder();
        for (String sStyleName : this.listStyles) {
            listStyle = (ListStyle)this.getStyles().getStyle(sStyleName);
            if (listStyle == null) continue;
            int nDepth = this.getListDepth(listStyle.getName());
            for (int nLevel = 1; nLevel <= nDepth; ++nLevel) {
                String sSelector = "." + this.getClassName(listStyle, nLevel);
                CSVList props = new CSVList(";");
                props.addValue("margin", "0");
                props.addValue("padding", "0");
                props.addValue("clear:left");
                this.cssCounterReset(listStyle, nLevel, props);
                this.addStyleDeclaration(sSelector, props, sIndent, buf);
                props = new CSVList(";");
                props.addValue("content", "''");
                this.addStyleDeclaration(sSelector + " > li::marker", props, sIndent, buf);
            }
        }
        for (String sDisplayName : this.listParStyles.keySet()) {
            listStyle = (ListStyle)this.getStyles().getStyleByDisplayName(sDisplayName);
            for (String sParDisplayName : this.listParStyles.get(sDisplayName)) {
                StyleWithProperties parStyle = (StyleWithProperties)this.getParSc().getStyles().getStyleByDisplayName(sParDisplayName);
                if (listStyle == null || parStyle == null) continue;
                int nDepth = this.getListDepth(listStyle.getName());
                for (int nLevel = 1; nLevel <= nDepth; ++nLevel) {
                    String sSelector = "." + this.getExtendedClassName(listStyle, nLevel, parStyle);
                    CSVList props = new CSVList(";");
                    props.addValue("margin", "0");
                    props.addValue("padding", "0");
                    props.addValue("clear:left");
                    this.cssCounterReset(listStyle, nLevel, props);
                    this.addStyleDeclaration(sSelector, props, sIndent, buf);
                    props = new CSVList(";");
                    props.addValue("content", "''");
                    this.addStyleDeclaration(sSelector + " > li::marker", props, sIndent, buf);
                    if (this.cssOverride(listStyle, parStyle, "fo:margin-left")) {
                        props = new CSVList(";");
                        this.cssListMarginLeft(listStyle, nLevel, props);
                        this.addStyleDeclaration(sSelector + " > li > p", props, sIndent, buf);
                    }
                    props = new CSVList(";");
                    props.addValue("text-indent", "0");
                    this.addStyleDeclaration(sSelector + " > li > p:not(:first-of-type)", props, sIndent, buf);
                    if (this.cssOverride(listStyle, parStyle, "fo:text-indent")) {
                        props = new CSVList(";");
                        this.cssListTextIndent(listStyle, nLevel, props);
                        this.addStyleDeclaration(sSelector + " > li > p:first-of-type", props, sIndent, buf);
                    }
                    props = new CSVList(";");
                    this.cssCounterIncrement(listStyle, nLevel, props);
                    this.cssCounterContent(listStyle, nLevel, props);
                    this.cssLabelTextStyle(listStyle, nLevel, props);
                    this.cssLabelSize(listStyle, nLevel, parStyle, props);
                    this.addStyleDeclaration(sSelector + " > li > p:first-of-type::before", props, sIndent, buf);
                }
            }
        }
        if (this.bHasListHeaders) {
            CSVList props = new CSVList(";");
            props.addValue("content", "''");
            props.addValue("counter-increment", "none");
            this.addStyleDeclaration("li.no_label p:first-of-type::before", props, sIndent, buf);
        }
        return buf.toString();
    }

    private String getLabelStyleDeclarations(String sIndent) {
        StringBuilder buf = new StringBuilder();
        for (String sStyleName : this.listStyles) {
            ListStyle style = (ListStyle)this.getStyles().getStyle(sStyleName);
            if (style == null) continue;
            int nDepth = this.getListDepth(style.getName());
            for (int nLevel = 1; nLevel <= nDepth; ++nLevel) {
                String sSelector = "." + this.getClassName(style, nLevel);
                CSVList props = new CSVList(";");
                this.cssCounterReset(style, nLevel, props);
                this.addStyleDeclaration(sSelector, props, sIndent, buf);
                props = new CSVList(";");
                this.cssCounterIncrement(style, nLevel, props);
                this.addStyleDeclaration(sSelector + " > li", props, sIndent, buf);
                props = new CSVList(";");
                this.cssCounterContent(style, nLevel, props);
                this.cssLabelTextStyle(style, nLevel, props);
                this.addStyleDeclaration(sSelector + " > li::marker", props, sIndent, buf);
            }
        }
        if (this.bHasListHeaders) {
            CSVList props = new CSVList(";");
            props.addValue("counter-increment", "none");
            this.addStyleDeclaration("li.no_label", props, sIndent, buf);
            props = new CSVList(";");
            props.addValue("content", "''");
            this.addStyleDeclaration("li.no_label::marker", props, sIndent, buf);
        }
        return buf.toString();
    }

    private String getCSS1StyleDeclarations(String sIndent) {
        StringBuilder buf = new StringBuilder();
        for (String sStyleName : this.listStyles) {
            ListStyle style = (ListStyle)this.getStyles().getStyle(sStyleName);
            if (style == null) continue;
            int nDepth = this.getListDepth(style.getName());
            for (int nLevel = 1; nLevel <= nDepth; ++nLevel) {
                String sSelector = "." + this.getClassName(style, nLevel);
                CSVList props = new CSVList(";");
                this.css1List(style, nLevel, props);
                this.addStyleDeclaration(sSelector, props, sIndent, buf);
            }
        }
        return buf.toString();
    }

    private void addStyleDeclaration(String sSelector, CSVList props, String sIndent, StringBuilder buf) {
        if (!props.isEmpty()) {
            buf.append(sIndent).append(sSelector).append(" {").append(props.toString()).append("}").append(this.config.prettyPrint() ? "\n" : " ");
        }
    }

    @Override
    public OfficeStyleFamily getStyles() {
        return this.ofr.getListStyles();
    }

    private void updateLevel(int nLevel, String sStyleName) {
        if (sStyleName != null) {
            if (this.listDepth.containsKey(sStyleName)) {
                if (this.listDepth.get(sStyleName) < nLevel) {
                    this.listDepth.put(sStyleName, this.listDepth.get(sStyleName) + 1);
                }
            } else {
                this.listDepth.put(sStyleName, nLevel);
            }
        }
    }

    private int getListDepth(String sStyleName) {
        return this.listDepth.containsKey(sStyleName) ? this.listDepth.get(sStyleName) : 0;
    }

    private void css1List(ListStyle style, int nLevel, CSVList props) {
        String sURL;
        String sLevelType = style.getLevelType(nLevel);
        if ("text:list-level-style-number".equals(sLevelType)) {
            String sNumFormat = this.getNumberFormat(style, nLevel);
            if (sNumFormat != null) {
                props.addValue("list-style-type", sNumFormat);
            }
        } else if ("text:list-level-style-bullet".equals(sLevelType)) {
            switch (nLevel % 3) {
                case 1: {
                    props.addValue("list-style-type", "disc");
                    break;
                }
                case 2: {
                    props.addValue("list-style-type", "circle");
                    break;
                }
                case 0: {
                    props.addValue("list-style-type", "square");
                }
            }
        } else if ("text:list-level-style-image".equals(sLevelType) && (sURL = this.getImageURL(style, nLevel)) != null) {
            props.addValue("list-style-image", "url('" + sURL + "')");
        }
        props.addValue("clear:left");
    }

    private boolean cssOverride(ListStyle listStyle, StyleWithProperties parStyle, String sXML) {
        StyleWithProperties currentStyle;
        boolean bRefersStyle = false;
        for (currentStyle = parStyle; currentStyle != null; currentStyle = (StyleWithProperties)currentStyle.getParentStyle()) {
            bRefersStyle |= listStyle.getName().equals(currentStyle.getListStyleName());
        }
        if (!bRefersStyle) {
            return true;
        }
        for (currentStyle = parStyle; currentStyle != null; currentStyle = (StyleWithProperties)currentStyle.getParentStyle()) {
            if (currentStyle.getParProperty(sXML, false) != null) {
                return false;
            }
            bRefersStyle = listStyle.getName().equals(currentStyle.getListStyleName());
            if (!bRefersStyle || currentStyle == null || listStyle.getName().equals(currentStyle.getListStyleName())) continue;
            return true;
        }
        return true;
    }

    private void cssListMarginLeft(ListStyle style, int nLevel, CSVList props) {
        String sMarginLeft = this.getLength(style.getLevelStyleProperty(nLevel, "fo:margin-left"));
        props.addValue("margin-left", this.scale(sMarginLeft));
    }

    private void cssListTextIndent(ListStyle style, int nLevel, CSVList props) {
        props.addValue("text-indent", this.scale(this.getLength(style.getLevelStyleProperty(nLevel, "fo:text-indent"))));
    }

    private void cssLabelTextStyle(ListStyle style, int nLevel, CSVList props) {
        StyleWithProperties charStyle;
        String sCharStyle = style.getLevelProperty(nLevel, "text:style-name");
        if (sCharStyle != null && (charStyle = (StyleWithProperties)this.ofr.getTextStyles().getStyle(sCharStyle)) != null) {
            this.converter.getStyleCv().getTextSc().applyProperties(charStyle, props, true);
        }
        if (!this.config.useDefaultFont()) {
            String s = null;
            String s2 = null;
            String s3 = null;
            CSVList val = new CSVList(",");
            s = style.getLevelStyleTextProperty(nLevel, "style:font-name");
            if (s != null) {
                FontDeclaration fd = (FontDeclaration)this.ofr.getFontDeclarations().getStyle(s);
                if (fd != null) {
                    s = fd.getFontFamily();
                    s2 = fd.getFontFamilyGeneric();
                    s3 = fd.getFontPitch();
                }
            } else {
                s = style.getLevelStyleTextProperty(nLevel, "fo:font-family");
                s2 = style.getLevelStyleTextProperty(nLevel, "style:font-family-generic");
                s3 = style.getLevelStyleTextProperty(nLevel, "style:font-pitch");
            }
            if (s != null) {
                val.addValue(s);
            }
            if ("fixed".equals(s3)) {
                val.addValue("monospace");
            } else if ("roman".equals(s2)) {
                val.addValue("serif");
            } else if ("swiss".equals(s2)) {
                val.addValue("sans-serif");
            } else if ("modern".equals(s2)) {
                val.addValue("monospace");
            } else if ("decorative".equals(s2)) {
                val.addValue("fantasy");
            } else if ("script".equals(s2)) {
                val.addValue("cursive");
            } else if ("system".equals(s2)) {
                val.addValue("serif");
            }
            if (!val.isEmpty()) {
                props.addValue("font-family", val.toString());
            }
        }
    }

    private void cssLabelSize(ListStyle style, int nLevel, StyleWithProperties parStyle, CSVList props) {
        if ("listtab".equals(style.getLevelStyleProperty(nLevel, "text:label-followed-by"))) {
            String sTabStop;
            ArrayList<String> tabStops = new ArrayList<String>();
            String sListTabStop = this.getLength(style.getLevelStyleProperty(nLevel, "text:list-tab-stop-position"));
            tabStops.add(sListTabStop);
            String sMarginLeft = this.cssOverride(style, parStyle, "fo:margin-left") ? this.getLength(style.getLevelStyleProperty(nLevel, "fo:margin-left")) : this.getLength(parStyle.getProperty("fo:margin-left"));
            tabStops.add(sMarginLeft);
            for (String sTabStop2 : parStyle.getTabStops(true)) {
                tabStops.add(Calc.add(sMarginLeft, sTabStop2));
            }
            StringComparator<String> comparator = new StringComparator<String>("en", "US"){

                @Override
                public int compare(String a, String b) {
                    if (Calc.isZero(Calc.sub(a, b))) {
                        return 0;
                    }
                    if (Calc.isLessThan(a, b)) {
                        return -1;
                    }
                    return 1;
                }
            };
            Collections.sort(tabStops, comparator);
            int nDisplayLevels = Misc.getPosInteger(this.getString(style.getLevelProperty(nLevel, "text:display-levels")), 1);
            String sWidthEstimate = 1.5 + 2.5 * (double)nDisplayLevels + "mm";
            String sTextIndent = this.cssOverride(style, parStyle, "fo:text-indent") ? this.getLength(style.getLevelStyleProperty(nLevel, "fo:text-indent")) : this.getLength(parStyle.getProperty("fo:text-indent"));
            String sAbsoluteTextIndent = Calc.add(sMarginLeft, sTextIndent);
            String sWidth = null;
            Iterator iterator = tabStops.iterator();
            while (iterator.hasNext() && Calc.isLessThan(sWidth = Calc.sub(sTabStop = (String)iterator.next(), sAbsoluteTextIndent), sWidthEstimate)) {
                sWidth = null;
            }
            if (sWidth == null) {
                sWidth = Calc.multiply("-100%", sAbsoluteTextIndent);
                while (Calc.isLessThan(sWidth, sWidthEstimate)) {
                    sWidth = Calc.add(sWidth, "0.5in");
                }
            }
            props.addValue("display", "inline-block");
            props.addValue("width", this.scale(sWidth));
            props.addValue("text-indent", "0");
        }
    }

    private void cssCounterReset(ListStyle style, int nLevel, CSVList props) {
        if ("text:list-level-style-number".equals(style.getLevelType(nLevel))) {
            int nStartValue = Misc.getPosInteger(style.getLevelProperty(nLevel, "text:start-value"), 1);
            props.addValue("counter-reset", this.getClassName(style, nLevel) + " " + (nStartValue - 1));
        }
    }

    private void cssCounterIncrement(ListStyle style, int nLevel, CSVList props) {
        if ("text:list-level-style-number".equals(style.getLevelType(nLevel))) {
            String sCounterName = this.getClassName(style, nLevel);
            props.addValue("counter-increment", sCounterName);
        }
    }

    private void cssCounterContent(ListStyle style, int nLevel, CSVList props) {
        String sURL;
        String sLevelType = style.getLevelType(nLevel);
        String sFormat = style.getLevelStyleProperty(nLevel, "text:label-followed-by");
        if ("text:list-level-style-number".equals(sLevelType)) {
            String sPrefix = this.getString(style.getLevelProperty(nLevel, "style:num-prefix"));
            if (sPrefix.length() > 0) {
                sPrefix = "'" + sPrefix + "' ";
            }
            String sSuffix = this.getString(style.getLevelProperty(nLevel, "style:num-suffix"));
            if ("space".equals(sFormat) || "listtab".equals(sFormat)) {
                sSuffix = sSuffix + " ";
            }
            if (sSuffix.length() > 0) {
                sSuffix = " '" + sSuffix + "'";
            }
            int nLevels = Misc.getPosInteger(style.getLevelProperty(nLevel, "text:display-levels"), 1);
            StringBuilder label = new StringBuilder();
            label.append(sPrefix);
            for (int i = nLevels; i > 0; --i) {
                String sNumFormat = this.getNumberFormat(style, nLevel - i + 1);
                if (sNumFormat == null) continue;
                label.append("counter(" + this.getClassName(style, nLevel) + "," + sNumFormat + ")");
                if (i <= 1) continue;
                label.append(" '.' ");
            }
            label.append(sSuffix);
            props.addValue("content", label.toString());
        } else if ("text:list-level-style-bullet".equals(sLevelType)) {
            String sChar = style.getLevelProperty(nLevel, "text:bullet-char");
            String sSpace = "space".equals(sFormat) || "listtab".equals(sFormat) ? " " : "";
            props.addValue("content", "'" + sChar + sSpace + "'");
        } else if ("text:list-level-style-image".equals(sLevelType) && (sURL = this.getImageURL(style, nLevel)) != null) {
            props.addValue("content", "url(" + sURL + ") ' '");
        }
    }

    private String getNumberFormat(ListStyle style, int nLevel) {
        String sNumFormat = style.getLevelProperty(nLevel, "style:num-format");
        if (sNumFormat.length() > 0) {
            String sCSSNumFormat = "decimal";
            if ("i".equals(sNumFormat)) {
                sCSSNumFormat = "lower-roman";
            } else if ("I".equals(sNumFormat)) {
                sCSSNumFormat = "upper-roman";
            } else if ("a".equals(sNumFormat)) {
                sCSSNumFormat = "lower-alpha";
            } else if ("A".equals(sNumFormat)) {
                sCSSNumFormat = "upper-alpha";
            }
            return sCSSNumFormat;
        }
        return null;
    }

    private String getImageURL(ListStyle style, int nLevel) {
        BinaryGraphicsDocument bgd;
        String sURL = null;
        Element image = style.getImage(nLevel);
        if (image != null && (bgd = this.converter.getImageCv().getImage(image)) != null) {
            sURL = bgd.getFileName();
            if (this.converter.isOPS()) {
                sURL = "../" + sURL;
            }
            if (this.config.embedImg() && !bgd.isLinked()) {
                StringBuilder sb = new StringBuilder();
                sb.append("data:").append(bgd.getMIMEType()).append(";base64,").append(bgd.getBase64());
                sURL = sb.toString();
            } else if (!bgd.isRecycled() && !bgd.isLinked()) {
                this.converter.addDocument(bgd);
            }
        }
        return sURL;
    }

    private String getClassName(ListStyle style, int nLevel) {
        if (style != null) {
            return this.styleNames.getExportName(style.getDisplayName()) + "_" + nLevel;
        }
        return "list-item";
    }

    private String getExtendedClassName(ListStyle listStyle, int nLevel, StyleWithProperties parStyle) {
        if (parStyle != null) {
            return this.getClassName(listStyle, nLevel) + "_" + this.getParSc().styleNames.getExportName(parStyle.getDisplayName());
        }
        return this.getClassName(listStyle, nLevel);
    }

    private String getString(String s) {
        return s != null ? s : "";
    }

    private String getLength(String s) {
        return s != null ? s : "0cm";
    }
}

