/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import writer2xhtml.base.BinaryGraphicsDocument;
import writer2xhtml.office.ControlReader;
import writer2xhtml.office.EmbeddedObject;
import writer2xhtml.office.EmbeddedXMLObject;
import writer2xhtml.office.FormReader;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.StyleWithProperties;
import writer2xhtml.util.CSVList;
import writer2xhtml.util.Calc;
import writer2xhtml.util.Misc;
import writer2xhtml.util.SimpleInputBuffer;
import writer2xhtml.util.SimpleXMLParser;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.ConverterHelper;
import writer2xhtml.xhtml.StyleInfo;
import writer2xhtml.xhtml.XhtmlConfig;

public class DrawConverter
extends ConverterHelper {
    public static final int INLINE = 0;
    public static final int FLOATING = 1;
    public static final int ABSOLUTE = 2;
    public static final int CENTERED = 3;
    public static final int FULL_SCREEN = 4;
    private FormReader form = null;
    private String sScale;
    private int nImageSize;
    private String sImageSplit;
    private boolean bCoverImage;
    private boolean bEmbedSVG;
    private boolean bEmbedImg;
    private HashMap<String, Element> svgImages = new HashMap();
    private Vector<Element> frames = new Vector();
    private boolean bCollectFrames = false;
    private Vector<Element> fullscreenFrames = new Vector();
    private boolean bCollectFullscreenFrames = true;

    public DrawConverter(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        super(ofr, config, converter);
        Iterator<FormReader> formsIterator = ofr.getForms().getFormsIterator();
        if (formsIterator.hasNext() && config.getXhtmlSplitLevel() == 0) {
            this.form = formsIterator.next();
        }
        this.bCollectFrames = ofr.isSpreadsheet();
        this.bCollectFullscreenFrames = true;
        this.sScale = config.getXhtmlScaling();
        this.nImageSize = config.imageSize();
        this.sImageSplit = config.imageSplit();
        this.bCoverImage = config.coverImage();
        this.bEmbedSVG = config.embedSVG();
        this.bEmbedImg = config.embedImg();
    }

    public Element createForm() {
        if (this.form == null) {
            return null;
        }
        Element htmlForm = this.converter.createElement("form");
        htmlForm.setAttribute("name", this.form.getAttribute("form:name"));
        htmlForm.setAttribute("action", this.form.getAttribute("xlink:href"));
        String sMethod = this.form.getAttribute("form:method");
        htmlForm.setAttribute("method", sMethod != null ? sMethod : "get");
        return htmlForm;
    }

    public Element getRealDrawElement(Element onode) {
        if ("draw:a".equals(onode.getTagName())) {
            for (Node child = onode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!OfficeReader.isDrawElement(child)) continue;
                return (Element)child;
            }
            return null;
        }
        return onode;
    }

    public Element getDrawAnchor(Element onode) {
        Element parent = (Element)onode.getParentNode();
        if ("draw:frame".equals(parent.getTagName())) {
            parent = (Element)parent.getParentNode();
        }
        if ("draw:a".equals(parent.getTagName())) {
            return parent;
        }
        return null;
    }

    private Element getFrame(Element onode) {
        if (this.ofr.isOpenDocument()) {
            return (Element)onode.getParentNode();
        }
        return onode;
    }

    public Element insertCoverImage(Element hnode) {
        Element cover;
        Element currentNode = hnode;
        if (this.bCoverImage && (cover = this.ofr.getFirstImage()) != null) {
            this.converter.setCoverFile(null);
            this.bCollectFullscreenFrames = false;
            this.handleDrawElement(cover, currentNode, null, 4);
            this.bCollectFullscreenFrames = true;
            Element head = Misc.getChildByTagName(hnode.getOwnerDocument().getDocumentElement(), "head");
            if (head != null) {
                Element style = this.converter.createElement("style");
                head.appendChild(style);
                style.setAttribute("type", "text/css");
                style.appendChild(this.converter.createTextNode("body { margin:0 }"));
            }
            currentNode = this.getTextCv().doMaybeSplit(hnode, null, null, 0);
        }
        return currentNode;
    }

    public Element flushFullscreenFrames(Element hnode) {
        Element currentNode = hnode;
        if (this.converter.isTopLevel() && !this.fullscreenFrames.isEmpty()) {
            this.bCollectFullscreenFrames = false;
            currentNode = this.getTextCv().doMaybeSplit(hnode, null, null, 0);
            for (Element image : this.fullscreenFrames) {
                this.handleDrawElement(image, currentNode, null, 4);
                currentNode = this.getTextCv().doMaybeSplit(hnode, null, null, 0);
            }
            this.fullscreenFrames.clear();
            this.bCollectFullscreenFrames = true;
        }
        return currentNode;
    }

    public void flushFrames(Element hnode) {
        this.bCollectFrames = false;
        int nCount = this.frames.size();
        for (int i = 0; i < nCount; ++i) {
            this.handleDrawElement(this.frames.get(i), hnode, null, 3);
        }
        this.frames.clear();
        this.bCollectFrames = true;
    }

    public void handleDrawElement(Element onode, Element hnodeBlock, Element hnodeInline, int nMode) {
        if (this.bCollectFrames) {
            this.frames.add(onode);
            return;
        }
        String sName = onode.getNodeName();
        if (sName.equals("draw:object")) {
            this.handleDrawObject(onode, hnodeBlock, hnodeInline, nMode);
        } else if (sName.equals("draw:object-ole")) {
            this.handleDrawObject(onode, hnodeBlock, hnodeInline, nMode);
        } else if (sName.equals("draw:image")) {
            this.handleDrawImage(onode, hnodeBlock, hnodeInline, nMode);
        } else if (sName.equals("draw:text-box")) {
            this.handleDrawTextBox(onode, hnodeBlock, hnodeInline, nMode);
        } else if (sName.equals("draw:a")) {
            Element elm = this.getRealDrawElement(onode);
            if (elm != null) {
                this.handleDrawElement(elm, hnodeBlock, hnodeInline, nMode);
            }
        } else if (sName.equals("draw:frame")) {
            if (!this.getMathCv().convertTexMathsEquation(onode, hnodeBlock, hnodeInline, nMode)) {
                this.handleDrawElement(Misc.getFirstChildElement(onode), hnodeBlock, hnodeInline, nMode);
            }
        } else if (sName.equals("draw:g")) {
            if (!this.getMathCv().convertTexMathsEquation(onode, hnodeBlock, hnodeInline, nMode)) {
                this.handleDrawGroup(onode, hnodeBlock, hnodeInline, nMode);
            }
        } else if (sName.equals("draw:control")) {
            this.handleDrawControl(onode, hnodeBlock, hnodeInline, nMode);
        }
    }

    private void handleDrawObject(Element onode, Element hnodeBlock, Element hnodeInline, int nMode) {
        String sHref;
        Element hnode;
        if (hnodeInline != null) {
            hnode = hnodeInline;
        } else {
            Element div = this.converter.createElement("div");
            hnodeBlock.appendChild(div);
            hnode = div;
        }
        boolean bNoTextPar = true;
        Element par = OfficeReader.getParagraph(onode);
        if (par != null) {
            bNoTextPar = OfficeReader.isNoTextPar(par);
        }
        if ((sHref = Misc.getAttribute(onode, "xlink:href")) != null) {
            if (this.ofr.isInPackage(sHref)) {
                EmbeddedObject object;
                if (sHref.startsWith("#")) {
                    sHref = sHref.substring(1);
                }
                if (sHref.startsWith("./")) {
                    sHref = sHref.substring(2);
                }
                if ("application/vnd.sun.xml.math".equals((object = this.converter.getEmbeddedObject(sHref)).getType()) || "application/vnd.oasis.opendocument.formula".equals(object.getType())) {
                    EmbeddedXMLObject xmlObject = (EmbeddedXMLObject)object;
                    Element replacementImage = null;
                    if (this.ofr.isOpenDocument()) {
                        replacementImage = Misc.getChildByTagName(this.getFrame(onode), "draw:image");
                    }
                    try {
                        hnode.appendChild(this.converter.createTextNode(" "));
                        this.getMathCv().convert(replacementImage, xmlObject.getContentDOM().getDocumentElement(), hnode, bNoTextPar);
                        hnode.appendChild(this.converter.createTextNode(" "));
                    }
                    catch (SAXException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    Element replacementImage;
                    boolean bIgnore = true;
                    if (this.ofr.isOpenDocument() && (replacementImage = Misc.getChildByTagName(this.getFrame(onode), "draw:image")) != null) {
                        this.handleDrawImage(replacementImage, hnodeBlock, hnodeInline, nMode);
                        bIgnore = false;
                    }
                    if (bIgnore) {
                        hnode.appendChild(this.converter.createTextNode("[Warning: object ignored]"));
                    }
                }
            } else {
                hnode.appendChild(this.converter.createTextNode("[Warning: Linked object ignored]"));
            }
        } else {
            Element formula = Misc.getChildByTagName(onode, "math");
            if (formula == null) {
                formula = Misc.getChildByTagName(onode, "math:math");
            }
            if (formula != null) {
                Element replacementImage = null;
                if (this.ofr.isOpenDocument()) {
                    replacementImage = Misc.getChildByTagName(this.getFrame(onode), "draw:image");
                }
                hnode.appendChild(this.converter.createTextNode(" "));
                this.getMathCv().convert(replacementImage, formula, hnode, bNoTextPar);
                hnode.appendChild(this.converter.createTextNode(" "));
            } else {
                Element replacementImage;
                boolean bIgnore = true;
                if (this.ofr.isOpenDocument() && (replacementImage = Misc.getChildByTagName(this.getFrame(onode), "draw:image")) != null) {
                    this.handleDrawImage(replacementImage, hnodeBlock, hnodeInline, nMode);
                    bIgnore = false;
                }
                if (bIgnore) {
                    hnode.appendChild(this.converter.createTextNode("[Warning: object ignored]"));
                }
            }
        }
    }

    private void handleDrawImage(Element onode, Element hnodeBlock, Element hnodeInline, int nMode) {
        Element frame = this.getFrame(onode);
        if (this.bCollectFullscreenFrames && this.converter.isOPS()) {
            if (this.bCoverImage && onode == this.ofr.getFirstImage()) {
                return;
            }
            if (!"none".equals(this.sImageSplit) && this.converter.isTopLevel()) {
                StyleWithProperties style = this.ofr.getFrameStyle(frame.getAttribute("draw:style-name"));
                String sWidth = this.getFrameWidth(frame, style);
                String sHeight = this.getFrameHeight(frame, style);
                if (sWidth != null && sHeight != null && Calc.sub(Calc.multiply("133%", sWidth), sHeight).startsWith("-") && Calc.sub(Calc.multiply(this.sImageSplit, this.converter.getContentWidth()), Calc.multiply(this.sScale, Calc.truncateLength(sWidth))).startsWith("-")) {
                    this.fullscreenFrames.add(onode);
                    return;
                }
            }
        }
        BinaryGraphicsDocument bgd = null;
        String sFileName = null;
        bgd = this.converter.getImageCv().getImage(onode);
        if (bgd != null) {
            if (!bgd.isLinked()) {
                sFileName = bgd.getFileName();
                if (this.bCoverImage && onode == this.ofr.getFirstImage()) {
                    this.converter.setCoverImageFile(bgd, null);
                }
            } else if (!this.converter.isOPS()) {
                sFileName = bgd.getFileName();
            }
        }
        if (sFileName == null) {
            return;
        }
        Element imageElement = null;
        if (this.converter.isHTML5() && this.bEmbedSVG && bgd != null && "image/svg+xml".equals(bgd.getMIMEType())) {
            if (bgd.isRecycled()) {
                if (this.svgImages.containsKey(bgd.getFileName())) {
                    Element elm = hnodeInline != null ? hnodeInline : hnodeBlock;
                    imageElement = (Element)elm.getOwnerDocument().importNode(this.svgImages.get(bgd.getFileName()), true);
                }
            } else {
                byte[] blob = bgd.getData();
                try {
                    Document dom = SimpleXMLParser.parse(new ByteArrayInputStream(blob));
                    if (dom != null) {
                        Element elm = hnodeInline != null ? hnodeInline : hnodeBlock;
                        imageElement = (Element)elm.getOwnerDocument().importNode(dom.getDocumentElement(), true);
                        this.svgImages.put(bgd.getFileName(), imageElement);
                    }
                }
                catch (IOException dom) {
                }
                catch (SAXException dom) {}
            }
        } else {
            if (!(bgd == null || bgd.isLinked() || bgd.isRecycled() || this.bEmbedImg && !"image/svg+xml".equals(bgd.getMIMEType()))) {
                this.converter.addDocument(bgd);
            }
            Element image = this.converter.createElement("img");
            String sName = Misc.getAttribute(this.getFrame(onode), "draw:name");
            this.converter.addTarget(image, sName + "|graphic");
            if (!this.bEmbedImg || "image/svg+xml".equals(bgd.getMIMEType()) || bgd.isLinked()) {
                image.setAttribute("src", sFileName);
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append("data:").append(bgd.getMIMEType()).append(";base64,").append(bgd.getBase64());
                image.setAttribute("src", buf.toString());
            }
            Element desc = Misc.getChildByTagName(frame, "svg:desc");
            if (desc == null) {
                desc = Misc.getChildByTagName(frame, "svg:title");
            }
            String sAltText = desc != null ? Misc.getPCDATA(desc) : (sName != null ? sName : sFileName);
            image.setAttribute("alt", sAltText);
            imageElement = image;
        }
        if (imageElement != null) {
            StyleInfo info = new StyleInfo();
            String sStyleName = Misc.getAttribute(frame, "draw:style-name");
            if (nMode != 4) {
                this.getFrameSc().applyStyle(sStyleName, info);
            }
            this.applyImageSize(frame, info.props, nMode, false);
            this.applyPlacement(frame, hnodeBlock, hnodeInline, nMode, imageElement, info);
            this.applyStyle(info, imageElement);
            this.addLink(onode, imageElement);
        }
    }

    private void handleDrawTextBox(Element onode, Element hnodeBlock, Element hnodeInline, int nMode) {
        String sTextStyleName;
        Element textbox = this.converter.createElement("div");
        if (hnodeBlock == null) {
            return;
        }
        hnodeBlock.appendChild(textbox);
        String sName = Misc.getAttribute(this.getFrame(onode), "draw:name");
        if (sName != null) {
            this.converter.addTarget(textbox, sName + "|frame");
        }
        Element frame = this.getFrame(onode);
        StyleInfo info = new StyleInfo();
        String sStyleName = Misc.getAttribute(frame, "draw:style-name");
        if (sStyleName != null) {
            this.getFrameSc().applyStyle(sStyleName, info);
        }
        if ((sTextStyleName = Misc.getAttribute(frame, "draw:text-style-name")) != null) {
            // empty if block
        }
        String sContentWidth = null;
        switch (nMode) {
            case 0: {
                break;
            }
            case 2: {
                sContentWidth = this.applyImageSize(frame, info.props, nMode, false);
                info.props.addValue("margin-left", "auto");
                info.props.addValue("margin-right", "auto");
                this.applyPosition(frame, info.props);
                break;
            }
            case 3: {
                info.props.addValue("margin-top", "2px");
                info.props.addValue("margin-bottom", "2px");
                info.props.addValue("margin-left", "auto");
                info.props.addValue("margin-right", "auto");
                sContentWidth = this.applyImageSize(frame, info.props, nMode, true);
                break;
            }
            case 1: {
                String sX;
                sContentWidth = this.applyImageSize(frame, info.props, nMode, true);
                StyleWithProperties style = this.ofr.getFrameStyle(sStyleName);
                if (style == null) break;
                String sPos = style.getProperty("style:horizontal-pos");
                String sWrap = style.getProperty("style:wrap");
                if (this.isLeft(sPos)) {
                    if (this.mayWrapRight(sWrap)) {
                        info.props.addValue("float", "left");
                        break;
                    }
                    info.props.addValue("margin-right", "auto");
                    break;
                }
                if (this.isRight(sPos)) {
                    if (this.mayWrapLeft(sWrap)) {
                        info.props.addValue("float", "right");
                        break;
                    }
                    info.props.addValue("margin-left", "auto");
                    break;
                }
                if (this.isCenter(sPos)) {
                    info.props.addValue("margin-left", "auto");
                    info.props.addValue("margin-right", "auto");
                    break;
                }
                if (!this.isFromLeft(sPos)) break;
                if (this.mayWrapRight(sWrap)) {
                    info.props.addValue("float", "left");
                }
                if ((sX = frame.getAttribute("svg:x")) == null || sX.length() <= 0) break;
                info.props.addValue("margin-left", this.scale(Calc.truncateLength(sX)));
            }
        }
        this.applyStyle(info, textbox);
        if (sContentWidth != null) {
            this.converter.pushContentWidth(sContentWidth);
        }
        this.getTextCv().traverseBlockText(onode, textbox);
        if (sContentWidth != null) {
            this.converter.popContentWidth();
        }
    }

    private void handleDrawGroup(Element onode, Element hnodeBlock, Element hnodeInline, int nMode) {
        for (Node child = onode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!OfficeReader.isDrawElement(child)) continue;
            this.handleDrawElement((Element)child, hnodeBlock, hnodeInline, nMode);
        }
    }

    private void handleDrawControl(Element onode, Element hnodeBlock, Element hnodeInline, int nMode) {
        ControlReader control;
        if (this.form == null) {
            return;
        }
        ControlReader controlReader = control = this.ofr.isOpenDocument() ? this.ofr.getForms().getControl(Misc.getAttribute(onode, "draw:control")) : this.ofr.getForms().getControl(Misc.getAttribute(onode, "form:id"));
        if (control == null || control.getOwnerForm() != this.form) {
            return;
        }
        Element hcontrol = null;
        String sType = control.getControlType();
        if ("form:text".equals(sType)) {
            hcontrol = this.createInputText(control, false);
        } else if ("form:password".equals(sType)) {
            hcontrol = this.createInputText(control, true);
        } else if ("form:file".equals(sType)) {
            hcontrol = this.createInputFile(control);
        } else if ("form:image".equals(sType)) {
            hcontrol = this.createInput(control, "image");
        } else if ("form:hidden".equals(sType)) {
            hcontrol = this.createInput(control, "hidden");
        } else if ("form:checkbox".equals(sType)) {
            hcontrol = this.createInputCheck(control, false);
        } else if ("form:radio".equals(sType)) {
            hcontrol = this.createInputCheck(control, true);
        } else if ("form:button".equals(sType)) {
            hcontrol = this.createInputButton(control);
        } else if ("form:fixed-text".equals(sType)) {
            hcontrol = this.createLabel(control);
        } else if ("form:textarea".equals(sType)) {
            hcontrol = this.createTextarea(control);
        } else if ("form:listbox".equals(sType)) {
            hcontrol = this.createSelect(control);
        }
        if (hcontrol != null) {
            Element frame = onode;
            StyleInfo info = new StyleInfo();
            this.getFrameSc().applyStyle(frame.getAttribute("draw:style-name"), info);
            this.applySize(frame, info.props, false);
            this.applyPlacement(frame, hnodeBlock, hnodeInline, nMode, hcontrol, info);
            this.applyStyle(info, hcontrol);
        }
    }

    private Element createInput(ControlReader control, String sType) {
        Element input = this.converter.createElement("input");
        input.setAttribute("type", sType);
        return input;
    }

    private Element createInputFile(ControlReader control) {
        Element input = this.converter.createElement("input");
        input.setAttribute("type", "file");
        this.setCommonAttributes(control, input);
        this.setDisabled(control, input);
        this.setReadonly(control, input);
        this.setValue(control, input);
        return input;
    }

    private Element createInputText(ControlReader control, boolean bPassword) {
        Element input = this.converter.createElement("input");
        input.setAttribute("type", bPassword ? "password" : "text");
        this.setCommonAttributes(control, input);
        this.setName(control, input, true);
        this.setValue(control, input);
        this.setMaxLength(control, input);
        this.setDisabled(control, input);
        this.setReadonly(control, input);
        return input;
    }

    private Element createInputCheck(ControlReader control, boolean bRadio) {
        Element input = this.converter.createElement("input");
        input.setAttribute("type", bRadio ? "radio" : "checkbox");
        this.setCommonAttributes(control, input);
        this.setName(control, input, true);
        this.setValue(control, input);
        this.setChecked(control, input);
        this.setDisabled(control, input);
        this.setReadonly(control, input);
        Element label = this.converter.createElement("label");
        this.setFor(control, label);
        label.appendChild(input);
        label.appendChild(this.converter.createTextNode(control.getTypeAttribute("form:label")));
        return label;
    }

    private Element createInputButton(ControlReader control) {
        Element input = this.converter.createElement("input");
        String sButtonType = control.getTypeAttribute("form:button-type");
        if ("submit".equals(sButtonType)) {
            input.setAttribute("type", "submit");
        } else if ("reset".equals(sButtonType)) {
            input.setAttribute("type", "reset");
        } else {
            input.setAttribute("type", "button");
        }
        this.setCommonAttributes(control, input);
        this.setName(control, input, true);
        input.setAttribute("value", control.getTypeAttribute("form:label"));
        this.setDisabled(control, input);
        return input;
    }

    private Element createLabel(ControlReader control) {
        Element label = this.converter.createElement("label");
        this.setCommonAttributes(control, label);
        this.setFor(control, label);
        label.setAttribute("value", control.getTypeAttribute("form:label"));
        label.appendChild(this.converter.createTextNode(control.getTypeAttribute("form:label")));
        return label;
    }

    private Element createTextarea(ControlReader control) {
        Element textarea = this.converter.createElement("textarea");
        this.setCommonAttributes(control, textarea);
        this.setName(control, textarea, true);
        this.setDisabled(control, textarea);
        this.setReadonly(control, textarea);
        textarea.setAttribute("rows", "10");
        textarea.setAttribute("cols", "5");
        String s = control.getTypeAttribute("form:value");
        if (s != null) {
            textarea.appendChild(this.converter.createTextNode(s));
        }
        return textarea;
    }

    private Element createSelect(ControlReader control) {
        Element select = this.converter.createElement("select");
        this.setCommonAttributes(control, select);
        this.setName(control, select, false);
        this.setSize(control, select);
        this.setMultiple(control, select);
        this.setDisabled(control, select);
        int nCount = control.getItemCount();
        for (int i = 0; i < nCount; ++i) {
            String sLabel = control.getItemAttribute(i, "form:label");
            boolean bSelected = "true".equals(control.getItemAttribute(i, "form:selected"));
            Element option = this.converter.createElement("option");
            select.appendChild(option);
            if (bSelected) {
                option.setAttribute("selected", "selected");
            }
            option.appendChild(this.converter.createTextNode(sLabel));
        }
        return select;
    }

    private void setCommonAttributes(ControlReader control, Element hnode) {
        this.setId(control, hnode);
        this.setTitle(control, hnode);
        this.setTabIndex(control, hnode);
    }

    private void setId(ControlReader control, Element hnode) {
        String s = control.getId();
        if (s != null) {
            hnode.setAttribute("id", s);
        }
    }

    private void setName(ControlReader control, Element hnode, boolean bRequired) {
        String s = control.getAttribute("form:name");
        if (s != null) {
            hnode.setAttribute("name", s);
        } else if (bRequired) {
            hnode.setAttribute("name", "unknown");
        }
    }

    private void setValue(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:value");
        if (s != null) {
            hnode.setAttribute("value", s);
        }
    }

    private void setTitle(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:title");
        if (s != null) {
            hnode.setAttribute("title", s);
        }
    }

    private void setTabIndex(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:tab-index");
        if (s != null) {
            hnode.setAttribute("tabindex", s);
        }
    }

    private void setMaxLength(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:max-length");
        if (s != null) {
            hnode.setAttribute("maxlength", s);
        }
    }

    private void setSize(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:size");
        if (s != null) {
            hnode.setAttribute("size", s);
        }
    }

    private void setChecked(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:selected");
        if ("true".equals(s)) {
            hnode.setAttribute("checked", "checked");
        }
    }

    private void setMultiple(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:multiple");
        if ("true".equals(s)) {
            hnode.setAttribute("multiple", "multiple");
        }
    }

    private void setDisabled(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:disabled");
        if ("true".equals(s)) {
            hnode.setAttribute("disabled", "disabled");
        }
    }

    private void setReadonly(ControlReader control, Element hnode) {
        String s = control.getTypeAttribute("form:readonly");
        if ("true".equals(s)) {
            hnode.setAttribute("readonly", "readonly");
        }
    }

    private void setFor(ControlReader control, Element hnode) {
        hnode.setAttribute("for", control.getId());
    }

    private void addLink(Element onode, Element hnode) {
        String sHref;
        Element oanchor = this.getDrawAnchor(onode);
        if (oanchor != null && (sHref = oanchor.getAttribute("xlink:href")) != null && sHref.length() > 0) {
            Element hanchor = this.converter.createLink(oanchor);
            hnode.getParentNode().replaceChild(hanchor, hnode);
            hanchor.appendChild(hnode);
        }
    }

    private String getFrameWidth(Element node, StyleWithProperties style) {
        String sWidth = node.getAttribute("svg:width");
        if (sWidth.length() > 0) {
            if (style != null) {
                String s = style.getProperty("fo:padding-left");
                if (s != null) {
                    sWidth = Calc.sub(sWidth, s);
                }
                if ((s = style.getProperty("fo:padding-right")) != null) {
                    sWidth = Calc.sub(sWidth, s);
                }
                if ((s = style.getProperty("fo:padding")) != null) {
                    sWidth = Calc.sub(sWidth, Calc.multiply("200%", s));
                }
                if ((s = style.getProperty("fo:border-left")) != null) {
                    sWidth = Calc.sub(sWidth, this.borderWidth(s));
                }
                if ((s = style.getProperty("fo:border-right")) != null) {
                    sWidth = Calc.sub(sWidth, this.borderWidth(s));
                }
                if ((s = style.getProperty("fo:border")) != null) {
                    sWidth = Calc.sub(sWidth, Calc.multiply("200%", this.borderWidth(s)));
                }
            }
            return sWidth;
        }
        return null;
    }

    private String getFrameHeight(Element node, StyleWithProperties style) {
        String sHeight = node.getAttribute("svg:height");
        if (sHeight.length() > 0) {
            if (style != null) {
                String s = style.getProperty("fo:padding-top");
                if (s != null) {
                    sHeight = Calc.sub(sHeight, s);
                }
                if ((s = style.getProperty("fo:padding-bottom")) != null) {
                    sHeight = Calc.sub(sHeight, s);
                }
                if ((s = style.getProperty("fo:padding")) != null) {
                    sHeight = Calc.sub(sHeight, Calc.multiply("200%", s));
                }
                if ((s = style.getProperty("fo:border-top")) != null) {
                    sHeight = Calc.sub(sHeight, this.borderWidth(s));
                }
                if ((s = style.getProperty("fo:border-bottom")) != null) {
                    sHeight = Calc.sub(sHeight, this.borderWidth(s));
                }
                if ((s = style.getProperty("fo:border")) != null) {
                    sHeight = Calc.sub(sHeight, Calc.multiply("200%", this.borderWidth(s)));
                }
            }
            return sHeight;
        }
        return null;
    }

    private String applySize(Element node, CSVList props, boolean bOnlyWidth) {
        String sHeight;
        StyleWithProperties style = this.ofr.getFrameStyle(node.getAttribute("draw:style-name"));
        String sWidth = this.getFrameWidth(node, style);
        if (sWidth != null) {
            props.addValue("width", this.scale(Calc.truncateLength(sWidth)));
        }
        if (!bOnlyWidth && (sHeight = this.getFrameHeight(node, style)) != null) {
            props.addValue("height", this.scale(Calc.truncateLength(sHeight)));
        }
        return sWidth;
    }

    private String applyImageSize(Element node, CSVList props, int nMode, boolean bOnlyWidth) {
        switch (this.nImageSize) {
            case 1: {
                return this.applySize(node, props, bOnlyWidth);
            }
            case 2: {
                if (nMode == 4) {
                    props.addValue("max-width", "100%");
                    props.addValue("height", "100%");
                } else {
                    String sWidth = this.getFrameWidth(node, this.ofr.getFrameStyle(node.getAttribute("draw:style-name")));
                    if (sWidth != null) {
                        props.addValue("width", Calc.divide(Calc.multiply(this.sScale, Calc.truncateLength(sWidth)), this.converter.getContentWidth()));
                    }
                    return sWidth;
                }
            }
            case 0: {
                return this.getFrameWidth(node, this.ofr.getFrameStyle(node.getAttribute("draw:style-name")));
            }
        }
        return null;
    }

    private void applyPosition(Element node, CSVList props) {
        StyleWithProperties style;
        String sY;
        String sX = node.getAttribute("svg:x");
        if (sX.length() == 0) {
            sX = "0";
        }
        if ((sY = node.getAttribute("svg:y")).length() == 0) {
            sY = "0";
        }
        if ((style = this.ofr.getFrameStyle(node.getAttribute("draw:style-name"))) != null) {
            String s = style.getProperty("fo:margin-top");
            if (s != null) {
                sX = Calc.sub(sX, s);
            }
            if ((s = style.getProperty("fo:margin-left")) != null) {
                sY = Calc.sub(sY, s);
            }
        }
        props.addValue("position", "absolute");
        if (sX != null && sX.length() > 0) {
            props.addValue("left", this.scale(Calc.truncateLength(sX)));
        }
        if (sY != null && sY.length() > 0) {
            props.addValue("top", this.scale(Calc.truncateLength(sY)));
        }
    }

    private void applyPlacement(Element onode, Element hnodeBlock, Element hnodeInline, int nMode, Element object, StyleInfo info) {
        switch (nMode) {
            case 0: {
                hnodeInline.appendChild(object);
                break;
            }
            case 2: {
                this.applyPosition(onode, info.props);
                if (hnodeInline != null) {
                    hnodeInline.appendChild(object);
                    break;
                }
                Element div = this.converter.createElement("div");
                hnodeBlock.appendChild(div);
                div.appendChild(object);
                break;
            }
            case 3: {
                Element centerdiv = this.converter.createElement("div");
                centerdiv.setAttribute("style", "margin:2px 0px 2px 0px");
                hnodeBlock.appendChild(centerdiv);
                centerdiv.appendChild(object);
                break;
            }
            case 4: {
                if (hnodeBlock == null) break;
                Element div = this.converter.createElement("div");
                div.setAttribute("style", "text-align:center");
                hnodeBlock.appendChild(div);
                div.appendChild(object);
                break;
            }
            case 1: {
                Element div;
                boolean bWrap = false;
                String sAlign = "center";
                String sX = null;
                String sStyleName = Misc.getAttribute(onode, "draw:style-name");
                StyleWithProperties style = this.ofr.getFrameStyle(sStyleName);
                if (style != null) {
                    String sPos = style.getProperty("style:horizontal-pos");
                    String sWrap = style.getProperty("style:wrap");
                    if (this.isLeft(sPos)) {
                        bWrap = this.mayWrapRight(sWrap);
                        sAlign = "left";
                    } else if (this.isRight(sPos)) {
                        bWrap = this.mayWrapLeft(sWrap);
                        sAlign = "right";
                    } else if (this.isFromLeft(sPos)) {
                        bWrap = this.mayWrapRight(sWrap);
                        sAlign = "left";
                        sX = onode.getAttribute("svg:x");
                    }
                }
                if (bWrap) {
                    info.props.addValue("float", sAlign);
                    if (sX != null && sX.length() > 0) {
                        info.props.addValue("margin-left", sX);
                    }
                    if (hnodeInline != null) {
                        hnodeInline.appendChild(object);
                        break;
                    }
                    div = this.converter.createElement("div");
                    hnodeBlock.appendChild(div);
                    div.appendChild(object);
                    break;
                }
                div = this.converter.createElement("div");
                hnodeBlock.appendChild(div);
                div.appendChild(object);
                CSVList props = new CSVList(";");
                props.addValue("text-align", sAlign);
                if (sX != null && sX.length() > 0) {
                    props.addValue("margin-left", sX);
                }
                div.setAttribute("style", props.toString());
            }
        }
    }

    private boolean isLeft(String sHPos) {
        return "left".equals(sHPos) || "inside".equals(sHPos);
    }

    private boolean isCenter(String sHPos) {
        return "center".equals(sHPos);
    }

    private boolean isRight(String sHPos) {
        return "right".equals(sHPos) || "outside".equals(sHPos);
    }

    private boolean isFromLeft(String sHPos) {
        return "from-left".equals(sHPos) || "from-inside".equals(sHPos);
    }

    private boolean mayWrapLeft(String sWrap) {
        return "left".equals(sWrap) || "parallel".equals(sWrap) || "biggest".equals(sWrap) || "dynamic".equals(sWrap) || "run-through".equals(sWrap);
    }

    private boolean mayWrapRight(String sWrap) {
        return "right".equals(sWrap) || "parallel".equals(sWrap) || "biggest".equals(sWrap) || "dynamic".equals(sWrap) || "run-through".equals(sWrap);
    }

    private String borderWidth(String sBorder) {
        if (sBorder == null || sBorder.equals("none")) {
            return "0";
        }
        SimpleInputBuffer in = new SimpleInputBuffer(sBorder);
        while (in.peekChar() != '\u0000') {
            while (in.peekChar() == ' ') {
                in.getChar();
            }
            if ('0' <= in.peekChar() && in.peekChar() <= '9') {
                return in.getNumber() + in.getIdentifier();
            }
            while (in.peekChar() != ' ' && in.peekChar() != '\u0000') {
                in.getChar();
            }
        }
        return "0";
    }
}

