/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.util.Misc;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.IndexConverterHelper;
import writer2xhtml.xhtml.IndexData;
import writer2xhtml.xhtml.XhtmlBibliographyGenerator;
import writer2xhtml.xhtml.XhtmlConfig;

class BibliographyConverter
extends IndexConverterHelper {
    private XhtmlBibliographyGenerator bibGenerator;

    BibliographyConverter(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        super(ofr, config, converter, "text:bibliography-source");
        this.bibGenerator = new XhtmlBibliographyGenerator(ofr, converter);
    }

    void handleBibliographyMark(Node onode, Node hnode) {
        String sKey = Misc.getAttribute(onode, "text:identifier");
        if (sKey != null) {
            Element anchor = this.converter.createLink("bib" + sKey);
            hnode.appendChild(anchor);
            anchor.appendChild(this.converter.createTextNode(this.bibGenerator.generateCitation(sKey)));
        }
    }

    @Override
    void generate(IndexData data) {
        this.bibGenerator.populateBibliography(data.onode, data.hnode);
    }
}

