/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.Collator;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Misc {
    private static final int BUFFERSIZE = 1024;

    public static final int[] doubleIntArray(int[] array) {
        int n = array.length;
        int[] newArray = new int[2 * n];
        for (int i = 0; i < n; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static final String dateOnly(String sDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            sdf.parse(sDate);
        }
        catch (ParseException e) {
            return sDate;
        }
        return sDate.substring(0, 10);
    }

    public static final String formatDate(String sDate, String sLanguage, String sCountry) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date date = null;
        try {
            date = sdf.parse(sDate);
        }
        catch (ParseException e) {
            return sDate;
        }
        Locale locale = sCountry != null ? new Locale(sLanguage, sCountry) : new Locale(sLanguage);
        return DateFormat.getDateTimeInstance(1, 3, locale).format(date);
    }

    public static final String int2roman(int number) {
        assert (number > 0);
        StringBuilder roman = new StringBuilder();
        while (number >= 1000) {
            roman.append('m');
            number -= 1000;
        }
        if (number >= 900) {
            roman.append("cm");
            number -= 900;
        }
        if (number >= 500) {
            roman.append('d');
            number -= 500;
        }
        if (number >= 400) {
            roman.append("cd");
            number -= 400;
        }
        while (number >= 100) {
            roman.append('c');
            number -= 100;
        }
        if (number >= 90) {
            roman.append("xc");
            number -= 90;
        }
        if (number >= 50) {
            roman.append('l');
            number -= 50;
        }
        if (number >= 40) {
            roman.append("xl");
            number -= 40;
        }
        while (number >= 10) {
            roman.append('x');
            number -= 10;
        }
        if (number >= 9) {
            roman.append("ix");
            number -= 9;
        }
        if (number >= 5) {
            roman.append('v');
            number -= 5;
        }
        if (number >= 4) {
            roman.append("iv");
            number -= 4;
        }
        while (number >= 1) {
            roman.append('i');
            --number;
        }
        return roman.toString();
    }

    public static final String int2Roman(int number) {
        return Misc.int2roman(number).toUpperCase();
    }

    public static final String int2arabic(int number) {
        return Integer.toString(number);
    }

    public static final String int2alph(int number, boolean bLetterSync) {
        assert (number > 0);
        if (bLetterSync) {
            char[] chars = new char[(number - 1) / 26 + 1];
            Arrays.fill(chars, (char)((number - 1) % 26 + 97));
            return String.valueOf(chars);
        }
        int n = number - 1;
        int m = n % 26;
        String sNumber = Character.toString((char)(m + 97));
        n = (n - m) / 26;
        while (n > 0) {
            m = n % 26;
            sNumber = (char)(m + 96) + sNumber;
            n = (n - m) / 26;
        }
        return sNumber;
    }

    public static final String int2Alph(int number, boolean bLetterSync) {
        return Misc.int2alph(number, bLetterSync).toUpperCase();
    }

    public static final int getIntegerFromHex(String sHex, int nDefault) {
        int n;
        try {
            n = Integer.parseInt(sHex, 16);
        }
        catch (NumberFormatException e) {
            return nDefault;
        }
        return n;
    }

    public static String makeTeXFriendly(String sFileName, String sDefault) {
        StringBuilder builder = new StringBuilder();
        block66: for (int i = 0; i < sFileName.length(); ++i) {
            char c = sFileName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                builder.append(c);
                continue;
            }
            switch (c) {
                case '.': {
                    builder.append('.');
                    continue block66;
                }
                case '-': {
                    builder.append('-');
                    continue block66;
                }
                case ' ': {
                    builder.append('-');
                    continue block66;
                }
                case '_': {
                    builder.append('-');
                    continue block66;
                }
                case '\u00c0': {
                    builder.append('A');
                    continue block66;
                }
                case '\u00c1': {
                    builder.append('A');
                    continue block66;
                }
                case '\u00c2': {
                    builder.append('A');
                    continue block66;
                }
                case '\u00c3': {
                    builder.append('A');
                    continue block66;
                }
                case '\u00c4': {
                    builder.append("AE");
                    continue block66;
                }
                case '\u00c5': {
                    builder.append("AA");
                    continue block66;
                }
                case '\u00c6': {
                    builder.append("AE");
                    continue block66;
                }
                case '\u00c7': {
                    builder.append('C');
                    continue block66;
                }
                case '\u00c8': {
                    builder.append('E');
                    continue block66;
                }
                case '\u00c9': {
                    builder.append('E');
                    continue block66;
                }
                case '\u00ca': {
                    builder.append('E');
                    continue block66;
                }
                case '\u00cb': {
                    builder.append('E');
                    continue block66;
                }
                case '\u00cc': {
                    builder.append('I');
                    continue block66;
                }
                case '\u00cd': {
                    builder.append('I');
                    continue block66;
                }
                case '\u00ce': {
                    builder.append('I');
                    continue block66;
                }
                case '\u00cf': {
                    builder.append('I');
                    continue block66;
                }
                case '\u00d0': {
                    builder.append('D');
                    continue block66;
                }
                case '\u00d1': {
                    builder.append('N');
                    continue block66;
                }
                case '\u00d2': {
                    builder.append('O');
                    continue block66;
                }
                case '\u00d3': {
                    builder.append('O');
                    continue block66;
                }
                case '\u00d4': {
                    builder.append('O');
                    continue block66;
                }
                case '\u00d5': {
                    builder.append('O');
                    continue block66;
                }
                case '\u00d6': {
                    builder.append("OE");
                    continue block66;
                }
                case '\u00d8': {
                    builder.append("OE");
                    continue block66;
                }
                case '\u00d9': {
                    builder.append('U');
                    continue block66;
                }
                case '\u00da': {
                    builder.append('U');
                    continue block66;
                }
                case '\u00db': {
                    builder.append('U');
                    continue block66;
                }
                case '\u00dc': {
                    builder.append("UE");
                    continue block66;
                }
                case '\u00dd': {
                    builder.append('Y');
                    continue block66;
                }
                case '\u00df': {
                    builder.append("sz");
                    continue block66;
                }
                case '\u00e0': {
                    builder.append('a');
                    continue block66;
                }
                case '\u00e1': {
                    builder.append('a');
                    continue block66;
                }
                case '\u00e2': {
                    builder.append('a');
                    continue block66;
                }
                case '\u00e3': {
                    builder.append('a');
                    continue block66;
                }
                case '\u00e4': {
                    builder.append("ae");
                    continue block66;
                }
                case '\u00e5': {
                    builder.append("aa");
                    continue block66;
                }
                case '\u00e6': {
                    builder.append("ae");
                    continue block66;
                }
                case '\u00e7': {
                    builder.append('c');
                    continue block66;
                }
                case '\u00e8': {
                    builder.append('e');
                    continue block66;
                }
                case '\u00e9': {
                    builder.append('e');
                    continue block66;
                }
                case '\u00ea': {
                    builder.append('e');
                    continue block66;
                }
                case '\u00eb': {
                    builder.append('e');
                    continue block66;
                }
                case '\u00ec': {
                    builder.append('i');
                    continue block66;
                }
                case '\u00ed': {
                    builder.append('i');
                    continue block66;
                }
                case '\u00ee': {
                    builder.append('i');
                    continue block66;
                }
                case '\u00ef': {
                    builder.append('i');
                    continue block66;
                }
                case '\u00f0': {
                    builder.append('d');
                    continue block66;
                }
                case '\u00f1': {
                    builder.append('n');
                    continue block66;
                }
                case '\u00f2': {
                    builder.append('o');
                    continue block66;
                }
                case '\u00f3': {
                    builder.append('o');
                    continue block66;
                }
                case '\u00f4': {
                    builder.append('o');
                    continue block66;
                }
                case '\u00f5': {
                    builder.append('o');
                    continue block66;
                }
                case '\u00f6': {
                    builder.append("oe");
                    continue block66;
                }
                case '\u00f8': {
                    builder.append("oe");
                    continue block66;
                }
                case '\u00f9': {
                    builder.append('u');
                    continue block66;
                }
                case '\u00fa': {
                    builder.append('u');
                    continue block66;
                }
                case '\u00fb': {
                    builder.append('u');
                    continue block66;
                }
                case '\u00fc': {
                    builder.append("ue");
                    continue block66;
                }
                case '\u00fd': {
                    builder.append('y');
                    continue block66;
                }
                case '\u00ff': {
                    builder.append('y');
                }
            }
        }
        return builder.length() > 0 ? builder.toString() : sDefault;
    }

    public static final String trimDocumentName(String name, String extension) {
        String temp = name.toLowerCase();
        if (temp.endsWith(extension)) {
            int nlen = name.length();
            int endIndex = nlen - extension.length();
            name = name.substring(0, endIndex);
        }
        return name;
    }

    public static final String getPath(String sURL) {
        return sURL.substring(0, sURL.lastIndexOf(47) + 1);
    }

    public static final String getFileName(String sURL) {
        return sURL.substring(sURL.lastIndexOf(47) + 1);
    }

    public static final String getFileExtension(String sURL) {
        String sFileName = Misc.getFileName(sURL);
        int nDot = sFileName.lastIndexOf(46);
        if (nDot >= 0) {
            return sFileName.substring(nDot);
        }
        return "";
    }

    public static final String removeExtension(String sURL) {
        String sExt = Misc.getFileExtension(sURL);
        return sURL.substring(0, sURL.length() - sExt.length());
    }

    public static final String getAttribute(Node node, String attribute) {
        Node attr;
        NamedNodeMap attrNodes = node.getAttributes();
        if (attrNodes != null && (attr = attrNodes.getNamedItem(attribute)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    public static final boolean isElement(Node node) {
        return node.getNodeType() == 1;
    }

    public static final boolean isElement(Node node, String sTagName) {
        return node.getNodeType() == 1 && node.getNodeName().equals(sTagName);
    }

    public static final boolean isText(Node node) {
        return node.getNodeType() == 3;
    }

    public static final String getAttribute(Element node, String attribute) {
        if (node.hasAttribute(attribute)) {
            return node.getAttribute(attribute);
        }
        return null;
    }

    public static final Element getChildByTagName(Node node, String sTagName) {
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            for (int i = 0; i < nLen; ++i) {
                Node child = nl.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals(sTagName)) continue;
                return (Element)child;
            }
        }
        return null;
    }

    public static final Element getFirstChildElement(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static String getPCDATA(Node node) {
        StringBuilder buf = new StringBuilder();
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            for (int i = 0; i < nLen; ++i) {
                if (nl.item(i).getNodeType() != 3) continue;
                buf.append(nl.item(i).getNodeValue());
            }
        }
        return buf.toString();
    }

    public static String[] sortStringSet(Set<String> theSet) {
        String[] theArray = theSet.toArray(new String[theSet.size()]);
        Collator collator = Collator.getInstance();
        Arrays.sort(theArray, collator);
        return theArray;
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String makeHref(String s) {
        try {
            URI uri = new URI(null, null, s, null);
            return uri.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public static String makeFileName(String sURL) {
        try {
            File file = new File(new URI("file:///" + sURL));
            return file.getName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public static File urlToFile(String sUrl) {
        try {
            return new File(new URI(sUrl));
        }
        catch (URISyntaxException e) {
            return new File(".");
        }
    }

    public static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("No input stream to read");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int nLen = 0;
        byte[] buffer = new byte[1024];
        while ((nLen = is.read(buffer)) > 0) {
            baos.write(buffer, 0, nLen);
        }
        return baos.toByteArray();
    }

    public static final int getPosInteger(String sInteger, int nDefault) {
        int n;
        try {
            n = Integer.parseInt(sInteger);
        }
        catch (NumberFormatException e) {
            return nDefault;
        }
        return n > 0 ? n : nDefault;
    }
}

