/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.util;

public class Calc {
    public static final float getFloat(String sFloat, float fDefault) {
        float f;
        try {
            f = Float.parseFloat(sFloat);
        }
        catch (NumberFormatException e) {
            return fDefault;
        }
        return f;
    }

    public static String truncateLength(String sValue) {
        if (sValue.endsWith("inch")) {
            return sValue.substring(0, sValue.length() - 2);
        }
        return sValue;
    }

    public static boolean isZero(String sValue) {
        return (double)Math.abs(Calc.getFloat(sValue.substring(0, sValue.length() - 2), 0.0f)) < 0.001;
    }

    private static final float getUpi(String sUnit) {
        if ("in".equals(sUnit)) {
            return 1.0f;
        }
        if ("mm".equals(sUnit)) {
            return 25.4f;
        }
        if ("cm".equals(sUnit)) {
            return 2.54f;
        }
        if ("pc".equals(sUnit)) {
            return 6.0f;
        }
        return 72.0f;
    }

    public static final String length2px(String sLength) {
        if (sLength.equals("0")) {
            return "0";
        }
        float fLength = Calc.getFloat(sLength.substring(0, sLength.length() - 2), 1.0f);
        String sUnit = sLength.substring(sLength.length() - 2);
        float fPixels = 96.0f / Calc.getUpi(sUnit) * fLength;
        if ((double)Math.abs(fPixels) < 0.01) {
            return "0";
        }
        if (fPixels > 0.0f) {
            return Float.toString(fPixels < 1.0f ? 1.0f : fPixels) + "px";
        }
        return Float.toString(fPixels > -1.0f ? -1.0f : fPixels) + "px";
    }

    public static final String length2rem(String sLength) {
        if (sLength.equals("0")) {
            return "0";
        }
        float fLength = Calc.getFloat(sLength.substring(0, sLength.length() - 2), 1.0f);
        String sUnit = sLength.substring(sLength.length() - 2);
        float fRems = 6.0f / Calc.getUpi(sUnit) * fLength;
        if ((double)Math.abs(fRems) < 0.01) {
            return "0";
        }
        return Float.toString(fRems) + "rem";
    }

    public static final String divide(String sDividend, String sDivisor) {
        return Calc.divide(sDividend, sDivisor, false);
    }

    public static final String divide(String sDividend, String sDivisor, boolean bMax100) {
        if (sDividend.equals("0")) {
            return "0%";
        }
        if (sDivisor.equals("0")) {
            return "100%";
        }
        float fDividend = Calc.getFloat(sDividend.substring(0, sDividend.length() - 2), 1.0f);
        String sDividendUnit = sDividend.substring(sDividend.length() - 2);
        float fDivisor = Calc.getFloat(sDivisor.substring(0, sDivisor.length() - 2), 1.0f);
        String sDivisorUnit = sDivisor.substring(sDivisor.length() - 2);
        int nPercent = Math.round(100.0f * fDividend * Calc.getUpi(sDivisorUnit) / fDivisor / Calc.getUpi(sDividendUnit));
        if (bMax100 && nPercent > 100) {
            return "100%";
        }
        if (nPercent > 0) {
            return Integer.toString(nPercent) + "%";
        }
        return "1%";
    }

    public static final String multiply(String sPercent, String sLength) {
        if (sLength.equals("0")) {
            return "0";
        }
        float fPercent = Calc.getFloat(sPercent.substring(0, sPercent.length() - 1), 1.0f);
        float fLength = Calc.getFloat(sLength.substring(0, sLength.length() - 2), 1.0f);
        String sUnit = sLength.substring(sLength.length() - 2);
        return Float.toString(fPercent * fLength / 100.0f) + sUnit;
    }

    public static final String add(String sLength1, String sLength2) {
        if (sLength1.equals("0")) {
            return sLength2;
        }
        if (sLength2.equals("0")) {
            return sLength1;
        }
        float fLength1 = Calc.getFloat(sLength1.substring(0, sLength1.length() - 2), 1.0f);
        String sUnit1 = sLength1.substring(sLength1.length() - 2);
        float fLength2 = Calc.getFloat(sLength2.substring(0, sLength2.length() - 2), 1.0f);
        String sUnit2 = sLength2.substring(sLength2.length() - 2);
        return Float.toString(fLength1 + Calc.getUpi(sUnit1) / Calc.getUpi(sUnit2) * fLength2) + sUnit1;
    }

    public static final String sub(String sLength1, String sLength2) {
        return Calc.add(sLength1, Calc.multiply("-100%", sLength2));
    }

    public static boolean isLessThan(String sThis, String sThat) {
        return Calc.sub(sThis, sThat).startsWith("-");
    }

    public static String abs(String sLength) {
        return sLength.startsWith("-") ? sLength.substring(1) : sLength;
    }
}

