/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class CSVList {
    private String sItemSep;
    private String sKeyValueSep;
    Map<String, String> items = new LinkedHashMap<String, String>();

    public CSVList(String sItemSep, String sKeyValueSep) {
        this.sItemSep = sItemSep;
        this.sKeyValueSep = sKeyValueSep;
    }

    public CSVList(String sItemSep) {
        this(sItemSep, ":");
    }

    public CSVList(char cItemSep) {
        this(Character.toString(cItemSep), ":");
    }

    public void addValue(String sVal) {
        if (sVal != null) {
            this.items.put(sVal, null);
        }
    }

    public void addValue(String sKey, String sVal) {
        if (sKey != null) {
            this.items.put(sKey, sVal);
        }
    }

    public void addValues(CSVList list) {
        for (String sKey : list.items.keySet()) {
            this.items.put(sKey, list.items.get(sKey));
        }
    }

    public String getValue(String sKey) {
        if (this.items.containsKey(sKey)) {
            return this.items.get(sKey);
        }
        return null;
    }

    public void removeValue(String sKey) {
        if (sKey != null && this.items.containsKey(sKey)) {
            this.items.remove(sKey);
        }
    }

    public void clear() {
        this.items.clear();
    }

    public boolean isEmpty() {
        return this.items.size() == 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        boolean bFirst = true;
        for (String sKey : this.items.keySet()) {
            if (bFirst) {
                bFirst = false;
            } else {
                buf.append(this.sItemSep);
            }
            buf.append(sKey);
            if (this.items.get(sKey) == null) continue;
            buf.append(this.sKeyValueSep).append(this.items.get(sKey));
        }
        return buf.toString();
    }
}

