/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.office;

import writer2xhtml.util.Misc;
import writer2xhtml.util.SimpleInputBuffer;

public class TableRangeParser {
    private SimpleInputBuffer inbuf;

    public TableRangeParser(String s) {
        this.inbuf = new SimpleInputBuffer(s);
        this.inbuf.skipSpaces();
    }

    public boolean hasMoreRanges() {
        return !this.inbuf.atEnd();
    }

    public int[] getRange() {
        if (!this.inbuf.atEnd()) {
            int[] nFirst = this.parseAddress();
            this.parseCharacter(':');
            int[] nLast = this.parseAddress();
            int[] nResult = new int[]{nFirst[0], nFirst[1], nLast[0], nLast[1]};
            return nResult;
        }
        return null;
    }

    private void parseCharacter(char c) {
        if (this.inbuf.peekChar() == c) {
            this.inbuf.getChar();
        }
        this.inbuf.skipSpaces();
    }

    private int[] parseAddress() {
        this.parseSheetName();
        this.parseCharacter('.');
        int[] nResult = new int[]{this.parseColumn(), this.parseRow()};
        this.inbuf.skipSpaces();
        return nResult;
    }

    private void parseSheetName() {
        if (this.inbuf.peekChar() != '.') {
            if (this.inbuf.peekChar() == '\'') {
                this.inbuf.getChar();
                while (!this.inbuf.atEnd() && this.inbuf.peekChar() != '\'') {
                    this.inbuf.getChar();
                    if (this.inbuf.peekChar() != '\'' || this.inbuf.peekFollowingChar() != '\'') continue;
                    this.inbuf.getChar();
                    this.inbuf.getChar();
                }
                this.inbuf.getChar();
            } else {
                while (!this.inbuf.atEnd() && this.inbuf.peekChar() != '.') {
                    this.inbuf.getChar();
                }
            }
        }
        this.inbuf.skipSpaces();
    }

    private int parseColumn() {
        if (this.inbuf.peekChar() >= 'A' && this.inbuf.peekChar() <= 'Z') {
            int nFirst = this.inbuf.getChar() - 65;
            if (this.inbuf.peekChar() >= 'A' && this.inbuf.peekChar() <= 'Z') {
                int nSecond = this.inbuf.getChar() - 65;
                return 26 * (nFirst + 1) + nSecond;
            }
            return nFirst;
        }
        return 0;
    }

    private int parseRow() {
        return Misc.getPosInteger(this.inbuf.getInteger(), 1) - 1;
    }
}

