/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.office;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import writer2xhtml.office.EmbeddedBinaryObject;
import writer2xhtml.office.EmbeddedObject;
import writer2xhtml.office.EmbeddedXMLObject;
import writer2xhtml.office.MIMETypes;
import writer2xhtml.util.SimpleXMLParser;
import writer2xhtml.util.SimpleZipReader;

public class OfficeDocument {
    protected static final String CONTENTXML = "content.xml";
    protected static final String STYLESXML = "styles.xml";
    private static final String METAXML = "meta.xml";
    private static final String MANIFESTXML = "META-INF/manifest.xml";
    private static final String MANIFEST_FILE_ENTRY = "manifest:file-entry";
    private static final String MANIFEST_MEDIA_TYPE = "manifest:media-type";
    private static final String MANIFEST_FULL_PATH = "manifest:full-path";
    private boolean bIsPackageFormat = false;
    private Document contentDoc = null;
    private Document metaDoc = null;
    private Document styleDoc = null;
    private Document manifestDoc = null;
    private Map<String, EmbeddedObject> embeddedObjects = null;

    public boolean isPackageFormat() {
        return this.bIsPackageFormat;
    }

    public Document getContentDOM() {
        return this.contentDoc;
    }

    public Document getMetaDOM() {
        return this.metaDoc;
    }

    public Document getStyleDOM() {
        return this.styleDoc;
    }

    private void getEmbeddedObjects(SimpleZipReader zip) {
        this.embeddedObjects = new HashMap<String, EmbeddedObject>();
        if (this.manifestDoc != null) {
            NodeList nl = this.manifestDoc.getElementsByTagName(MANIFEST_FILE_ENTRY);
            int nLen = nl.getLength();
            for (int i = 0; i < nLen; ++i) {
                Element elm = (Element)nl.item(i);
                String sType = elm.getAttribute(MANIFEST_MEDIA_TYPE);
                String sPath = elm.getAttribute(MANIFEST_FULL_PATH);
                if (sType.startsWith("application/vnd.oasis.opendocument") || sType.startsWith("application/vnd.sun.xml")) {
                    if (sPath.equals("/")) continue;
                    if (sPath.endsWith("/")) {
                        sPath = sPath.substring(0, sPath.length() - 1);
                    }
                    this.embeddedObjects.put(sPath, new EmbeddedXMLObject(sPath, sType, this, zip));
                    continue;
                }
                if (sType.equals("text/xml")) continue;
                this.embeddedObjects.put(sPath, new EmbeddedBinaryObject(sPath, sType, this, zip));
            }
        }
    }

    public EmbeddedObject getEmbeddedObject(String sName) {
        if (sName != null && this.embeddedObjects != null && this.embeddedObjects.containsKey(sName)) {
            return this.embeddedObjects.get(sName);
        }
        return null;
    }

    protected void removeEmbeddedObject(String sName) {
        if (sName != null && this.embeddedObjects != null && this.embeddedObjects.containsKey(sName)) {
            this.embeddedObjects.remove(sName);
        }
    }

    public void read(Document dom) {
        this.contentDoc = dom;
        this.styleDoc = null;
        this.metaDoc = null;
        this.manifestDoc = null;
        this.bIsPackageFormat = false;
        this.embeddedObjects = null;
    }

    public void read(InputStream is) throws IOException {
        BufferedInputStream inbuf = new BufferedInputStream(is);
        byte[] bytes = new byte[4];
        inbuf.mark(4);
        inbuf.read(bytes);
        inbuf.reset();
        boolean bZip = "application/zip".equals(MIMETypes.getMagicMIMEType(bytes));
        if (bZip) {
            this.readZip(inbuf);
        } else {
            this.readFlat(inbuf);
        }
    }

    private void readZip(InputStream is) throws IOException {
        byte[] manifestBytes;
        byte[] metaBytes;
        SimpleZipReader zip = new SimpleZipReader();
        zip.read(is);
        byte[] contentBytes = zip.getEntry(CONTENTXML);
        if (contentBytes == null) {
            throw new IOException("Entry content.xml not found in file");
        }
        try {
            this.contentDoc = OfficeDocument.parse(contentBytes);
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
        byte[] styleBytes = zip.getEntry(STYLESXML);
        if (styleBytes != null) {
            try {
                this.styleDoc = OfficeDocument.parse(styleBytes);
            }
            catch (SAXException ex) {
                throw new IOException(ex);
            }
        }
        if ((metaBytes = zip.getEntry(METAXML)) != null) {
            try {
                this.metaDoc = OfficeDocument.parse(metaBytes);
            }
            catch (SAXException ex) {
                throw new IOException(ex);
            }
        }
        if ((manifestBytes = zip.getEntry(MANIFESTXML)) != null) {
            try {
                this.manifestDoc = OfficeDocument.parse(manifestBytes);
            }
            catch (SAXException ex) {
                throw new IOException(ex);
            }
        }
        this.bIsPackageFormat = true;
        this.getEmbeddedObjects(zip);
    }

    private void readFlat(InputStream is) throws IOException {
        try {
            this.contentDoc = SimpleXMLParser.parse(is);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        this.styleDoc = null;
        this.metaDoc = null;
        this.manifestDoc = null;
        this.bIsPackageFormat = false;
        this.embeddedObjects = null;
    }

    static Document parse(byte[] bytes) throws SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SimpleXMLParser handler = new SimpleXMLParser();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)new ByteArrayInputStream(bytes), (DefaultHandler)handler);
            return handler.getDOM();
        }
        catch (ParserConfigurationException e) {
            System.err.println("Oops - failed to get XML parser!?");
            e.printStackTrace();
            return null;
        }
    }
}

