/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.api;

import writer2xhtml.api.Converter;
import writer2xhtml.epub.EPUB3Converter;
import writer2xhtml.epub.EPUBConverter;
import writer2xhtml.xhtml.Html5Converter;
import writer2xhtml.xhtml.Xhtml10Converter;
import writer2xhtml.xhtml.Xhtml11Converter;
import writer2xhtml.xhtml.XhtmlMathMLConverter;

public class ConverterFactory {
    private static final String VERSION = "1.7.1";
    private static final String DATE = "2023-08-08";

    public static String getVersion() {
        return VERSION;
    }

    public static String getDate() {
        return DATE;
    }

    public static Converter createConverter(String sMIME) {
        if ("text/html".equals(sMIME)) {
            return new Xhtml10Converter();
        }
        if ("application/xhtml11".equals(sMIME)) {
            return new Xhtml11Converter();
        }
        if ("application/xhtml+xml".equals(sMIME)) {
            return new XhtmlMathMLConverter();
        }
        if ("text/html5".equals(sMIME)) {
            return new Html5Converter();
        }
        if ("epub3".equals(sMIME)) {
            return new EPUB3Converter();
        }
        if ("application/epub+zip".equals(sMIME)) {
            return new EPUBConverter();
        }
        return null;
    }
}

