/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import java.util.HashMap;
import java.util.Map;
import writer2xhtml.office.FontDeclaration;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.OfficeStyleFamily;
import writer2xhtml.office.StyleWithProperties;
import writer2xhtml.util.CSVList;
import writer2xhtml.util.Calc;
import writer2xhtml.util.ExportNameCollection;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.StyleInfo;
import writer2xhtml.xhtml.StyleWithPropertiesConverterHelper;
import writer2xhtml.xhtml.XhtmlConfig;
import writer2xhtml.xhtml.XhtmlStyleMapItem;

public class TextStyleConverter
extends StyleWithPropertiesConverterHelper {
    private static final String DEFAULT_LINK_STYLE = "Internet link";
    private static final String DEFAULT_VISITED_LINK_STYLE = "Visited Internet Link";
    private ExportNameCollection anchorStyleNames = new ExportNameCollection(true);
    private ExportNameCollection anchorVisitedStyleNames = new ExportNameCollection(true);
    private Map<String, String> anchorCombinedStyleNames = new HashMap<String, String>();
    private Map<String, String> orgAnchorStyleNames = new HashMap<String, String>();
    private Map<String, String> orgAnchorVisitedStyleNames = new HashMap<String, String>();
    private boolean bRelativeFontSize = false;
    private String sFontScaling = "100%";
    private String sBaseFontSize = "12pt";
    private boolean bConvertFont = false;

    public TextStyleConverter(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        String sFontSize;
        this.styleMap = config.getXTextStyleMap();
        this.bConvertStyles = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 2;
        this.bConvertHard = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 1;
        this.bRelativeFontSize = converter.isOPS() && config.relativeFontSize();
        this.sFontScaling = config.fontScaling();
        StyleWithProperties defaultStyle = ofr.getDefaultParStyle();
        if (defaultStyle != null && (sFontSize = defaultStyle.getTextProperty("fo:font-size", false)) != null) {
            this.sBaseFontSize = sFontSize;
        }
        this.bConvertFont = !config.useDefaultFont();
    }

    public void applyAnchorStyle(String sStyleName, String sVisitedStyleName, StyleInfo info) {
        if (sStyleName == null || sVisitedStyleName == null) {
            return;
        }
        if (sStyleName.length() == 0 || sVisitedStyleName.length() == 0) {
            return;
        }
        String sDisplayName = this.ofr.getTextStyles().getDisplayName(sStyleName);
        if (this.styleMap.contains(sDisplayName)) {
            XhtmlStyleMapItem map = this.styleMap.get(sDisplayName);
            if (!"(none)".equals(map.sCss)) {
                info.sClass = map.sCss;
            }
            return;
        }
        String sName = sStyleName + sVisitedStyleName;
        if (!this.anchorCombinedStyleNames.containsKey(sName)) {
            String sExportName = this.anchorStyleNames.containsName(sStyleName) ? this.anchorStyleNames.getExportName(sStyleName) + this.anchorVisitedStyleNames.getExportName(sVisitedStyleName) : this.anchorStyleNames.getExportName(sStyleName);
            this.anchorCombinedStyleNames.put(sName, sExportName);
            this.orgAnchorStyleNames.put(sExportName, sStyleName);
            this.orgAnchorVisitedStyleNames.put(sExportName, sVisitedStyleName);
        }
        info.sClass = this.anchorCombinedStyleNames.get(sName);
    }

    @Override
    public String getStyleDeclarations(String sIndent) {
        StringBuilder buf = new StringBuilder();
        buf.append(super.getStyleDeclarations(sIndent));
        if (this.bConvertStyles) {
            CSVList props;
            StyleWithProperties defaultLinkStyle = (StyleWithProperties)this.getStyles().getStyleByDisplayName(DEFAULT_LINK_STYLE);
            if (defaultLinkStyle != null) {
                props = new CSVList(";");
                this.cssText(defaultLinkStyle, props, true);
                this.cssHyperlink(defaultLinkStyle, props);
                buf.append(sIndent).append("a:link {").append(props.toString()).append("}\n");
            }
            if ((defaultLinkStyle = (StyleWithProperties)this.getStyles().getStyleByDisplayName(DEFAULT_VISITED_LINK_STYLE)) != null) {
                props = new CSVList(";");
                this.cssText(defaultLinkStyle, props, true);
                this.cssHyperlink(defaultLinkStyle, props);
                buf.append(sIndent).append("a:visited {").append(props.toString()).append("}\n");
            }
            for (String sExportName : this.anchorCombinedStyleNames.values()) {
                CSVList props2;
                String sStyleName = this.orgAnchorStyleNames.get(sExportName);
                String sVisitedStyleName = this.orgAnchorVisitedStyleNames.get(sExportName);
                StyleWithProperties style = this.ofr.getTextStyle(sStyleName);
                if (style != null) {
                    props2 = new CSVList(";");
                    this.cssText(style, props2, true);
                    this.cssHyperlink(style, props2);
                    buf.append(sIndent).append("a.").append(sExportName).append(":link {").append(props2.toString()).append("}\n");
                }
                if ((style = this.ofr.getTextStyle(sVisitedStyleName)) == null) continue;
                props2 = new CSVList(";");
                this.cssText(style, props2, true);
                this.cssHyperlink(style, props2);
                buf.append(sIndent).append("a.").append(sExportName).append(":visited {").append(props2.toString()).append("}\n");
            }
        }
        return buf.toString();
    }

    @Override
    public OfficeStyleFamily getStyles() {
        return this.ofr.getTextStyles();
    }

    @Override
    public String getDefaultTagName(StyleWithProperties style) {
        return "span";
    }

    @Override
    public void applyProperties(StyleWithProperties style, CSVList props, boolean bInherit) {
        this.cssText(style, props, bInherit);
    }

    public void cssTextBlock(StyleWithProperties style, CSVList props, boolean bInherit) {
        this.cssTextCommon(style, props, bInherit);
    }

    public void cssText(StyleWithProperties style, CSVList props, boolean bInherit) {
        this.cssTextCommon(style, props, bInherit);
        this.cssTextBackground(style, props, bInherit);
    }

    private void cssTextCommon(StyleWithProperties style, CSVList props, boolean bInherit) {
        this.cssFontFamily(style, props, bInherit);
        this.cssFontStyle(style, props, bInherit);
        this.cssFontWeight(style, props, bInherit);
        this.cssFontSizeAndPosition(style, props, bInherit);
        this.cssColor(style, props, bInherit);
        this.cssTextDecoration(style, props, bInherit);
        this.cssTextTransform(style, props, bInherit);
        this.cssFontVariant(style, props, bInherit);
        this.cssTextRotation(style, props, bInherit, true);
        this.cssTextShadow(style, props, bInherit);
        this.cssLetterSpacing(style, props, bInherit);
        this.cssLetterKerning(style, props, bInherit);
        this.cssHyphenate(style, props, bInherit);
    }

    private void cssFontFamily(StyleWithProperties style, CSVList props, boolean bInherit) {
        if (this.bConvertFont && (bInherit || style.getTextProperty("style:font-name", false) != null)) {
            FontDeclaration fd;
            CSVList val = new CSVList(",");
            String sName = style.getTextProperty("style:font-name", true);
            if (sName != null && (fd = (FontDeclaration)this.ofr.getFontDeclarations().getStyle(sName)) != null) {
                String s1 = fd.getFontFamily();
                String s2 = fd.getFontFamilyGeneric();
                String s3 = fd.getFontPitch();
                if (s1 != null) {
                    val.addValue(s1);
                }
                if ("fixed".equals(s3)) {
                    val.addValue("monospace");
                } else if ("roman".equals(s2)) {
                    val.addValue("serif");
                } else if ("swiss".equals(s2)) {
                    val.addValue("sans-serif");
                } else if ("modern".equals(s2)) {
                    val.addValue("monospace");
                } else if ("decorative".equals(s2)) {
                    val.addValue("fantasy");
                } else if ("script".equals(s2)) {
                    val.addValue("cursive");
                } else if ("system".equals(s2)) {
                    val.addValue("serif");
                }
                if (!val.isEmpty()) {
                    props.addValue("font-family", val.toString());
                }
            }
        }
    }

    private void cssFontStyle(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getTextProperty("fo:font-style", bInherit);
        if (s != null) {
            props.addValue("font-style", s);
        }
    }

    private void cssFontWeight(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getTextProperty("fo:font-weight", bInherit);
        if (s != null) {
            props.addValue("font-weight", s);
        }
    }

    private void cssFontSizeAndPosition(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = null;
        String s2 = null;
        String s3 = null;
        String s4 = null;
        if (bInherit || style.getTextProperty("fo:font-size", false) != null || style.getTextProperty("style:font-size-rel", false) != null || style.getTextProperty("style:text-position", false) != null) {
            s = style.getAbsoluteFontSize();
            s2 = style.getTextProperty("style:text-position", true);
            if (s2 != null) {
                int i = (s2 = s2.trim()).indexOf(" ");
                if (i > 0) {
                    s3 = s2.substring(0, i);
                    s4 = s2.substring(i + 1);
                } else {
                    s3 = s2;
                    s4 = "100%";
                }
                if (s != null) {
                    if (this.bRelativeFontSize) {
                        String sFontSize = Calc.divide(Calc.multiply(this.sFontScaling, Calc.multiply(s4, s)), this.sBaseFontSize);
                        if (!"100%".equals(sFontSize)) {
                            props.addValue("font-size", sFontSize);
                        }
                    } else {
                        props.addValue("font-size", Calc.multiply(s4, this.scale(s)));
                    }
                } else {
                    props.addValue("font-size", s4);
                }
                if (!"0%".equals(s3)) {
                    props.addValue("vertical-align", s3);
                }
            } else if (s != null) {
                if (this.bRelativeFontSize) {
                    String sFontSize = Calc.divide(Calc.multiply(this.sFontScaling, s), this.sBaseFontSize);
                    if (!"100%".equals(sFontSize)) {
                        props.addValue("font-size", sFontSize);
                    }
                } else {
                    props.addValue("font-size", this.scale(s));
                }
            }
        }
    }

    private void cssColor(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getTextProperty("fo:color", bInherit);
        if (s != null) {
            props.addValue("color", s);
        }
    }

    private void cssTextDecoration(StyleWithProperties style, CSVList props, boolean bInherit) {
        String sThrough = style.getTextProperty("style:text-line-through-style", bInherit);
        String sUnder = style.getTextProperty("style:text-underline-style", bInherit);
        String sOver = style.getTextProperty("style:text-overline-style", bInherit);
        if (this.active(sThrough) || this.active(sUnder) || this.active(sOver)) {
            CSVList val = new CSVList(" ");
            String sColor = null;
            if (this.active(sThrough)) {
                sColor = style.getTextProperty("style:text-line-through-color", bInherit);
            }
            if (sColor == null && this.active(sUnder)) {
                sColor = style.getTextProperty("style:text-underline-color", bInherit);
            }
            if (sColor == null && this.active(sOver)) {
                sColor = style.getTextProperty("style:text-overline-color", bInherit);
            }
            if (sColor != null && !"font-color".equals(sColor)) {
                val.addValue(sColor);
            }
            String sStyle = null;
            String sType = null;
            if (this.active(sThrough)) {
                sStyle = sThrough;
                sType = style.getTextProperty("style:text-line-through-type", bInherit);
            } else if (this.active(sUnder)) {
                sStyle = sUnder;
                sType = style.getTextProperty("style:text-underline-type", bInherit);
            } else if (this.active(sOver)) {
                sStyle = sOver;
                sType = style.getTextProperty("style:text-overline-type", bInherit);
            }
            if (sStyle != null) {
                switch (sStyle) {
                    case "wave": {
                        val.addValue("wavy");
                        break;
                    }
                    case "dash": 
                    case "long-dash": 
                    case "dot-dash": {
                        val.addValue("dashed");
                        break;
                    }
                    case "dot-dot-dash": 
                    case "dotted": {
                        val.addValue("dotted");
                        break;
                    }
                    default: {
                        if ("double".equals(sType)) {
                            val.addValue("double");
                            break;
                        }
                        val.addValue("solid");
                    }
                }
            }
            if (this.active(sThrough)) {
                val.addValue("line-through");
            }
            if (this.active(sUnder)) {
                val.addValue("underline");
            }
            if (this.active(sOver)) {
                val.addValue("overline");
            }
            if (!val.isEmpty()) {
                props.addValue("text-decoration", val.toString());
            }
            String sMode = null;
            if (this.active(sThrough)) {
                sMode = style.getTextProperty("style:text-line-through-mode", bInherit);
            }
            if (sMode == null && this.active(sUnder)) {
                sMode = style.getTextProperty("style:text-underline-mode", bInherit);
            }
            if (sMode == null && this.active(sOver)) {
                sMode = style.getTextProperty("style:text-overline-mode", bInherit);
            }
            if (sMode != null) {
                if (sMode.equals("skip-white-space")) {
                    props.addValue("text-decoration-skip", "spaces");
                } else if (sMode.equals("continuous")) {
                    props.addValue("text-decoration-skip", "none");
                }
            }
        } else if (sThrough != null || sUnder != null || sOver != null) {
            props.addValue("text-decoration", "none");
        }
    }

    private boolean active(String sDecorationStyle) {
        return sDecorationStyle != null && !"none".equals(sDecorationStyle);
    }

    private void cssTextTransform(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getTextProperty("fo:text-transform", bInherit);
        if (s != null) {
            props.addValue("text-transform", s);
        }
    }

    private void cssFontVariant(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getTextProperty("fo:font-variant", bInherit);
        if (s != null) {
            props.addValue("font-variant", s);
        }
    }

    private void cssTextShadow(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getTextProperty("fo:text-shadow", bInherit);
        if (s != null) {
            props.addValue("text-shadow", this.multiscale(s));
        }
    }

    private String multiscale(String sValue) {
        CSVList newValue = new CSVList(" ");
        String[] sValues = sValue.split(" ");
        int nLen = sValues.length;
        for (int i = 0; i < nLen; ++i) {
            if (sValues[i].length() <= 0) continue;
            if (Character.isDigit(sValues[i].charAt(0))) {
                newValue.addValue(this.scale(sValues[i]));
                continue;
            }
            newValue.addValue(sValues[i]);
        }
        return newValue.toString();
    }

    private void cssTextRotation(StyleWithProperties style, CSVList props, boolean bInherit, boolean bInline) {
        String s = style.getTextProperty("style:text-rotation-angle", bInherit);
        if (s != null) {
            String sMode = null;
            if (s.equals("90deg") || s.equals("90")) {
                sMode = "sideways-lr";
            } else if (s.equals("270deg") || s.equals("270")) {
                sMode = "vertical-rl";
            }
            if (sMode != null) {
                if (bInline) {
                    props.addValue("vertical-align", "middle");
                }
                props.addValue("writing-mode", sMode);
            }
        }
    }

    private void cssLetterSpacing(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getTextProperty("fo:letter-spacing", bInherit);
        if (s != null) {
            props.addValue("letter-spacing", this.scale(s));
        }
    }

    private void cssLetterKerning(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getTextProperty("style:letter-kerning", bInherit);
        if (s != null) {
            if (s.equals("false")) {
                props.addValue("font-kerning", "none");
            } else if (s.equals("true")) {
                props.addValue("font-kerning", "normal");
            }
        }
    }

    private void cssHyperlink(StyleWithProperties style, CSVList props) {
        if (style.getTextProperty("style:text-underline-style", true) == null) {
            props.addValue("text-decoration", "none");
        }
    }

    public void cssTextBackground(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getTextProperty("fo:background-color", bInherit);
        if (s != null && !s.equals("transparent")) {
            props.addValue("background-color", s);
        }
    }

    private void cssHyphenate(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getTextProperty("fo:hyphenate", bInherit);
        if (s != null) {
            if (s.equals("false")) {
                props.addValue("hyphens", "manual");
            } else if (s.equals("true")) {
                props.addValue("hyphens", "auto");
            }
        }
    }
}

