/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.OfficeStyleFamily;
import writer2xhtml.office.StyleWithProperties;
import writer2xhtml.util.CSVList;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.StyleWithPropertiesConverterHelper;
import writer2xhtml.xhtml.XhtmlConfig;
import writer2xhtml.xhtml.XhtmlStyleMap;

public class TableStyleConverter
extends StyleWithPropertiesConverterHelper {
    public TableStyleConverter(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        this.styleMap = new XhtmlStyleMap();
        this.bConvertStyles = config.xhtmlTableFormatting() == 3 || config.xhtmlTableFormatting() == 2;
        this.bConvertHard = config.xhtmlTableFormatting() == 3 || config.xhtmlTableFormatting() == 1;
    }

    @Override
    public OfficeStyleFamily getStyles() {
        return this.ofr.getTableStyles();
    }

    @Override
    public String getDefaultTagName(StyleWithProperties style) {
        return "table";
    }

    @Override
    public void applyProperties(StyleWithProperties style, CSVList props, boolean bInherit) {
        this.getParSc().cssPageBreak(style, props, bInherit);
        this.getFrameSc().cssBackground(style, props, bInherit);
        this.cssTable(style, props, bInherit);
    }

    private void cssTable(StyleWithProperties style, CSVList props, boolean bInherit) {
        String sBorderModel;
        String sMarginRight;
        String sMarginTop = style.getAbsoluteProperty("fo:margin-top");
        if (sMarginTop != null) {
            props.addValue("margin-top", this.scale(sMarginTop));
        } else {
            props.addValue("margin-top", "0");
        }
        String sMarginBottom = style.getAbsoluteProperty("fo:margin-bottom");
        if (sMarginBottom != null) {
            props.addValue("margin-bottom", this.scale(sMarginBottom));
        } else {
            props.addValue("margin-bottom", "0");
        }
        String sAlign = style.getProperty("table:align");
        String sMarginLeft = style.getAbsoluteProperty("fo:margin-left");
        if (sMarginLeft != null) {
            sMarginLeft = this.scale(sMarginLeft);
        }
        if ((sMarginRight = style.getAbsoluteProperty("fo:margin-right")) != null) {
            sMarginRight = this.scale(sMarginRight);
        }
        if ("center".equals(sAlign)) {
            sMarginLeft = "auto";
            sMarginRight = "auto";
        } else if ("right".equals(sAlign)) {
            sMarginLeft = "auto";
        } else if ("left".equals(sAlign)) {
            sMarginRight = "auto";
        }
        if (sMarginLeft != null) {
            props.addValue("margin-left", sMarginLeft);
        }
        if (sMarginRight != null) {
            props.addValue("margin-right", sMarginRight);
        }
        if ("separating".equals(sBorderModel = style.getProperty("table:border-model"))) {
            props.addValue("border-collapse", "separate");
            props.addValue("border-spacing", "0");
        } else {
            props.addValue("border-collapse", "collapse");
        }
    }
}

