/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.StyleWithProperties;
import writer2xhtml.office.TableRange;
import writer2xhtml.office.TableReader;
import writer2xhtml.office.TableView;
import writer2xhtml.util.Calc;
import writer2xhtml.util.Misc;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.ConverterHelper;
import writer2xhtml.xhtml.StyleInfo;
import writer2xhtml.xhtml.XhtmlConfig;

public class TableConverter
extends ConverterHelper {
    protected Vector<String> sheetNames = new Vector();

    public TableConverter(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        super(ofr, config, converter);
    }

    public void convertTableContent(Element onode) {
        Element hnode = null;
        if (!onode.hasChildNodes()) {
            return;
        }
        if (!this.config.xhtmlCalcSplit()) {
            hnode = this.nextOutFile(this.converter.getL10n().get(7), 1);
        }
        NodeList nList = onode.getChildNodes();
        int nLen = nList.getLength();
        for (int i = 0; i < nLen; ++i) {
            String sNodeName;
            Node child = nList.item(i);
            if (child.getNodeType() != 1 || !(sNodeName = child.getNodeName()).equals("table:table")) continue;
            StyleWithProperties style = this.ofr.getTableStyle(Misc.getAttribute(child, "table:style-name"));
            if (!this.config.xhtmlDisplayHiddenSheets() && style != null && "false".equals(style.getProperty("table:display")) || this.config.applyPrintRanges() && this.ofr.getTableReader((Element)child).getPrintRangeCount() <= 0) continue;
            String sName = Misc.getAttribute(child, "table:name");
            this.sheetNames.add(sName);
            if (this.config.xhtmlCalcSplit()) {
                hnode = this.nextOutFile(sName, 1);
            }
            if (this.config.xhtmlUseSheetNamesAsHeadings()) {
                Element heading = this.converter.createElement("h2");
                hnode.appendChild(heading);
                heading.setAttribute("id", "tableheading" + (this.sheetNames.size() - 1));
                heading.appendChild(this.converter.createTextNode(sName));
            }
            this.handleTable(child, hnode);
            Element div = this.converter.createElement("div");
            Element shapes = Misc.getChildByTagName(child, "table:shapes");
            if (shapes != null) {
                for (Node shape = shapes.getFirstChild(); shape != null; shape = shape.getNextSibling()) {
                    if (!OfficeReader.isDrawElement(shape)) continue;
                    this.getDrawCv().handleDrawElement((Element)shape, div, null, 3);
                }
            }
            this.getDrawCv().flushFrames(div);
            if (!div.hasChildNodes()) continue;
            hnode.appendChild(div);
        }
        if (this.converter.getOutFileIndex() < 0) {
            this.nextOutFile(this.converter.getL10n().get(7), 1);
        }
    }

    private Element nextOutFile(String sFileTitle, int nLevel) {
        String sTitle;
        Element hnode = this.converter.nextOutFile("", sFileTitle, nLevel);
        if (this.config.xhtmlUseTitleAsHeading() && (sTitle = this.converter.getMetaData().getTitle()) != null) {
            Element title = this.converter.createElement("h1");
            hnode.appendChild(title);
            title.appendChild(this.converter.createTextNode(sTitle));
        }
        return hnode;
    }

    public void handleTable(Node onode, Node hnode) {
        TableReader tblr = this.ofr.getTableReader((Element)onode);
        if (this.config.applyPrintRanges()) {
            if (tblr.getPrintRangeCount() > 0) {
                Element div = this.converter.createElement("div");
                if (!tblr.isSubTable()) {
                    this.converter.addTarget(div, tblr.getTableName() + "|table");
                }
                hnode.appendChild(div);
                int nCount = tblr.getPrintRangeCount();
                for (int nRange = 0; nRange < nCount; ++nRange) {
                    Element table = this.converter.createElement("table");
                    div.appendChild(table);
                    TableRange range = tblr.getPrintRange(nRange);
                    range.setIncludeHidden(this.config.displayHiddenRowsCols());
                    range.setIncludeFiltered(this.config.displayFilteredRowsCols());
                    this.traverseTable(tblr, range.createTableView(), table);
                }
            }
        } else {
            Element table = this.converter.createElement("table");
            if (!tblr.isSubTable()) {
                this.converter.addTarget(table, tblr.getTableName() + "|table");
            }
            hnode.appendChild(table);
            TableRange range = new TableRange(tblr);
            if (this.ofr.isSpreadsheet()) {
                range.setLastRow(tblr.getMaxRowCount() - 1);
                range.setLastCol(tblr.getMaxColCount() - 1);
            }
            range.setIncludeHidden(this.config.displayHiddenRowsCols());
            range.setIncludeFiltered(this.config.displayFilteredRowsCols());
            this.traverseTable(tblr, range.createTableView(), table);
        }
    }

    private void traverseTable(TableReader tblr, TableView view, Element hnode) {
        int nBodyStart;
        int nCol;
        int nRowCount = view.getRowCount();
        int nColCount = view.getColCount();
        StyleInfo info = new StyleInfo();
        this.applyTableStyle(tblr.getTableStyleName(), info, tblr.isSubTable());
        if (this.ofr.isSpreadsheet()) {
            String sTotalWidth = "0";
            for (nCol = 0; nCol < nColCount; ++nCol) {
                String sColWidth = view.getColumnWidth(nCol);
                if (sColWidth == null) continue;
                sTotalWidth = Calc.add(sColWidth, sTotalWidth);
            }
            info.props.addValue("width", this.colScale(sTotalWidth));
            info.props.addValue("table-layout", "fixed");
        }
        this.applyStyle(info, hnode);
        if (!this.converter.isHTML5()) {
            hnode.setAttribute("cellspacing", "0");
        }
        if (this.config.tableSize() != 0) {
            Element col;
            Element colgroup = hnode;
            if (this.converter.isHTML5()) {
                colgroup = this.converter.createElement("colgroup");
                hnode.appendChild(colgroup);
            }
            if (view.getRelTableWidth() != null || this.config.tableSize() == 2) {
                for (nCol = 0; nCol < nColCount; ++nCol) {
                    col = this.converter.createElement("col");
                    colgroup.appendChild(col);
                    col.setAttribute("style", "width:" + view.getRelColumnWidth(nCol));
                }
            } else {
                for (nCol = 0; nCol < nColCount; ++nCol) {
                    col = this.converter.createElement("col");
                    colgroup.appendChild(col);
                    col.setAttribute("style", "width:" + this.colScale(view.getColumnWidth(nCol)));
                }
            }
        }
        for (nBodyStart = 0; nBodyStart < nRowCount && view.getRow(nBodyStart).isHeader(); ++nBodyStart) {
        }
        if (nBodyStart == 0 || nBodyStart == nRowCount) {
            Element tbody = hnode;
            if (this.converter.isHTML5()) {
                tbody = this.converter.createElement("tbody");
                hnode.appendChild(tbody);
            }
            this.traverseRows(view, 0, nRowCount, tbody);
        } else {
            Element thead = this.converter.createElement("thead");
            hnode.appendChild(thead);
            this.traverseRows(view, 0, nBodyStart, thead);
            Element tbody = this.converter.createElement("tbody");
            hnode.appendChild(tbody);
            this.traverseRows(view, nBodyStart, nRowCount, tbody);
        }
    }

    private void traverseRows(TableView view, int nFirstRow, int nLastRow, Element hnode) {
        for (int nRow = nFirstRow; nRow < nLastRow; ++nRow) {
            Element tr = this.converter.createElement("tr");
            hnode.appendChild(tr);
            this.applyRowStyle(view.getRow(nRow).getStyleName(), tr);
            for (int nCol = 0; nCol < view.getColCount(); ++nCol) {
                Element cell = view.getCell(nRow, nCol);
                if (cell == null) continue;
                if ("table:table-cell".equals(cell.getNodeName())) {
                    int nColSpan;
                    Element td = this.converter.createElement("td");
                    tr.appendChild(td);
                    int nRowSpan = view.getRowSpan(nRow, nCol);
                    if (nRowSpan > 1) {
                        td.setAttribute("rowspan", Integer.toString(nRowSpan));
                    }
                    if ((nColSpan = view.getColSpan(nRow, nCol)) > 1) {
                        td.setAttribute("colspan", Integer.toString(nColSpan));
                    }
                    if (!this.isEmptyCell(cell)) {
                        String sWidth = view.getCellWidth(nRow, nCol);
                        if (sWidth != null) {
                            this.converter.pushContentWidth(sWidth);
                        }
                        this.getTextCv().traverseBlockText(cell, td);
                        if (sWidth != null) {
                            this.converter.popContentWidth();
                        }
                    } else {
                        Element par = this.converter.createElement("p");
                        td.appendChild(par);
                        par.setAttribute("style", "margin:0;font-size:1px");
                        par.appendChild(this.converter.createTextNode("\u00a0"));
                    }
                    Element subTable = Misc.getChildByTagName(cell, "table:sub-table");
                    String sValueType = this.ofr.isOpenDocument() ? Misc.getAttribute((Node)cell, "office:value-type") : Misc.getAttribute((Node)cell, "table:value-type");
                    this.applyCellStyle(view.getCellStyleName(nRow, nCol), sValueType, td, subTable != null);
                    continue;
                }
                if (!"table:covered-table-cell".equals(cell.getNodeName())) continue;
            }
        }
    }

    private boolean isEmptyCell(Node cell) {
        if (!cell.hasChildNodes()) {
            return true;
        }
        if (OfficeReader.isSingleParagraph(cell)) {
            Element par = Misc.getChildByTagName(cell, "text:p");
            return par == null || !par.hasChildNodes();
        }
        return false;
    }

    private void applyTableStyle(String sStyleName, StyleInfo info, boolean bIsSubTable) {
        StyleWithProperties style;
        this.getTableSc().applyStyle(sStyleName, info);
        if (this.config.tableSize() != 0 && (style = this.ofr.getTableStyle(sStyleName)) != null) {
            String sWidth = style.getProperty("style:rel-width");
            if (sWidth != null) {
                info.props.addValue("width", sWidth);
            } else {
                sWidth = style.getProperty("style:width");
                if (sWidth != null && this.config.tableSize() == 2) {
                    sWidth = Calc.divide(sWidth, this.converter.getContentWidth(), true);
                    info.props.addValue("width", sWidth);
                }
            }
        }
        if (this.ofr.isSpreadsheet()) {
            info.props.addValue("white-space", "nowrap");
        }
        if (bIsSubTable) {
            info.props.addValue("width", "100%");
            info.props.addValue("margin", "0");
        }
    }

    private void applyRowStyle(String sStyleName, Element row) {
        String s;
        StyleWithProperties style;
        StyleInfo info = new StyleInfo();
        this.getRowSc().applyStyle(sStyleName, info);
        if (this.config.tableSize() != 0 && (style = this.ofr.getRowStyle(sStyleName)) != null && (s = style.getAbsoluteProperty("style:row-height")) != null) {
            info.props.addValue("height", this.getRowSc().scale(s));
        }
        this.applyStyle(info, row);
    }

    private void applyCellStyle(String sStyleName, String sValueType, Element cell, boolean bIsSubTable) {
        StyleInfo info = new StyleInfo();
        this.getCellSc().applyStyle(sStyleName, info);
        StyleWithProperties style = this.ofr.getCellStyle(sStyleName);
        if (style != null && this.ofr.isSpreadsheet() && !"fix".equals(style.getProperty("style:text-align-source"))) {
            info.props.addValue("text-align", sValueType == null || "string".equals(sValueType) ? "left" : "right");
        }
        if (!cell.hasChildNodes()) {
            cell.appendChild(this.converter.createTextNode("\u00a0"));
        }
        if (bIsSubTable) {
            info.props.addValue("vertical-align", "top");
            info.props.addValue("padding", "0");
        }
        this.applyStyle(info, cell);
    }
}

