/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2xhtml.office.IndexMark;
import writer2xhtml.office.ListCounter;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.TocReader;
import writer2xhtml.util.Misc;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.IndexConverterHelper;
import writer2xhtml.xhtml.IndexData;
import writer2xhtml.xhtml.TocEntry;
import writer2xhtml.xhtml.XhtmlConfig;

class TOCConverter
extends IndexConverterHelper {
    private static final String TOC_LINK_PREFIX = "toc";
    private List<TocEntry> tocEntries = new ArrayList<TocEntry>();
    private int nTocFileIndex = -1;
    private int nTocIndex = -1;
    private ListCounter naturalOutline = new ListCounter();
    private int nExternalTocDepth = 1;
    private int nExternalTocDepthMarks = 1;

    TOCConverter(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        super(ofr, config, converter, "text:table-of-content-source");
        this.nExternalTocDepth = config.externalTocDepth();
        if (this.nExternalTocDepth == -1) {
            this.nExternalTocDepth = Math.max(config.getXhtmlSplitLevel(), 1);
        }
        this.nExternalTocDepthMarks = config.externalTocDepthMarks();
    }

    int getFileIndex() {
        return this.nTocFileIndex;
    }

    void handleHeading(Element onode, Element heading, String sLabel, int nChapterNumber) {
        int nLevel = this.getTextCv().getOutlineLevel(onode);
        String sTarget = TOC_LINK_PREFIX + ++this.nTocIndex;
        this.converter.addTarget(heading, sTarget);
        if (nLevel <= this.nExternalTocDepth) {
            this.converter.addContentEntry(sLabel + this.converter.getPlainInlineText(onode), nLevel, nLevel > this.config.getXhtmlSplitLevel() ? sTarget : null);
        }
        TocEntry entry = new TocEntry();
        entry.onode = onode;
        entry.nChapterNumber = nChapterNumber;
        entry.sLabel = sLabel;
        entry.nFileIndex = this.converter.getOutFileIndex();
        entry.nOutlineLevel = nLevel;
        entry.nOutlineNumber = this.naturalOutline.step(nLevel).getValues();
        this.tocEntries.add(entry);
    }

    void handleHeadingExternal(Element onode, Element hnode, String sLabel) {
        int nLevel = this.getTextCv().getOutlineLevel(onode);
        if (nLevel <= this.nExternalTocDepth) {
            String sTarget = null;
            if (nLevel > this.config.getXhtmlSplitLevel()) {
                Element div = this.converter.createElement("div");
                hnode.appendChild(div);
                sTarget = TOC_LINK_PREFIX + ++this.nTocIndex;
                this.converter.addTarget(div, sTarget);
            }
            this.converter.addContentEntry(sLabel + this.converter.getPlainInlineText(onode), nLevel, sTarget);
        }
    }

    void handleParagraph(Element onode, Element par, String sCurrentListLabel) {
        String sStyleName = Misc.getAttribute(onode, "text:style-name");
        if (this.ofr.isIndexSourceStyle(this.getParSc().getRealParStyleName(sStyleName))) {
            this.converter.addTarget(par, TOC_LINK_PREFIX + ++this.nTocIndex);
            TocEntry entry = new TocEntry();
            entry.onode = onode;
            entry.sLabel = sCurrentListLabel;
            entry.nFileIndex = this.converter.getOutFileIndex();
            this.tocEntries.add(entry);
        }
    }

    void handleTocMark(Node onode, Node hnode) {
        String sTarget = TOC_LINK_PREFIX + ++this.nTocIndex;
        hnode.appendChild(this.converter.createTarget(sTarget));
        TocEntry entry = new TocEntry();
        entry.onode = (Element)onode;
        entry.nFileIndex = this.converter.getOutFileIndex();
        this.tocEntries.add(entry);
        int nLevel = Misc.getPosInteger(Misc.getAttribute(entry.onode, "text:outline-level"), 1);
        if (nLevel <= this.nExternalTocDepthMarks) {
            this.converter.addContentEntry(IndexMark.getIndexValue(entry.onode), Misc.getPosInteger(entry.onode.getAttribute("text:outline-level"), 1), sTarget);
        }
    }

    @Override
    void handleIndex(Element onode, Element hnode, int nChapterNumber) {
        if (this.nTocFileIndex == -1 && !this.ofr.getTocReader(onode).isByChapter()) {
            this.nTocFileIndex = this.converter.getOutFileIndex();
        }
        this.converter.setTocFile(null);
        super.handleIndex(onode, hnode, nChapterNumber);
    }

    @Override
    void generate(IndexData data) {
        TocEntry entry;
        int i;
        this.converter.getTextCv().setSoftPageBreaksLimit(0);
        Element onode = data.onode;
        int nChapterNumber = data.nChapterNumber;
        Element ul = data.hnode;
        TocReader tocReader = this.ofr.getTocReader((Element)onode.getParentNode());
        String[] sEntryStyleName = new String[11];
        for (int i2 = 1; i2 <= 10; ++i2) {
            Element entryTemplate = tocReader.getTocEntryTemplate(i2);
            if (entryTemplate == null) continue;
            sEntryStyleName[i2] = Misc.getAttribute(entryTemplate, "text:style-name");
        }
        int nStart = 0;
        int nLen = this.tocEntries.size();
        if (tocReader.isByChapter() && nChapterNumber > 0) {
            for (i = 0; i < nLen; ++i) {
                entry = this.tocEntries.get(i);
                if (entry.nChapterNumber != nChapterNumber) continue;
                nStart = i;
                break;
            }
        }
        for (i = nStart; i < nLen; ++i) {
            Element a;
            Element p;
            Element a2;
            entry = this.tocEntries.get(i);
            String sNodeName = entry.onode.getTagName();
            if ("text:h".equals(sNodeName)) {
                int nLevel = this.getTextCv().getOutlineLevel(entry.onode);
                if (nLevel == 1 && tocReader.isByChapter() && entry.nChapterNumber > nChapterNumber) break;
                if (tocReader.useOutlineLevel() && nLevel <= tocReader.getOutlineLevel()) {
                    Element p2 = this.createEntry(ul, sEntryStyleName[nLevel]);
                    if (entry.sLabel != null) {
                        Element span = this.converter.createElement("span");
                        p2.appendChild(span);
                        span.setAttribute("class", "SectionNumber");
                        span.appendChild(this.converter.createTextNode(entry.sLabel));
                    }
                    a2 = this.converter.createLink(TOC_LINK_PREFIX + i);
                    p2.appendChild(a2);
                    this.getTextCv().traverseInlineText(entry.onode, a2);
                    continue;
                }
                String sStyleName = this.getParSc().getRealParStyleName(entry.onode.getAttribute("text:style-name"));
                nLevel = tocReader.getIndexSourceStyleLevel(sStyleName);
                if (!tocReader.useIndexSourceStyles() || 1 > nLevel || nLevel > tocReader.getOutlineLevel()) continue;
                p = this.createEntry(ul, sEntryStyleName[nLevel]);
                if (entry.sLabel != null) {
                    p.appendChild(this.converter.createTextNode(entry.sLabel));
                }
                a = this.converter.createLink(TOC_LINK_PREFIX + i);
                p.appendChild(a);
                this.getTextCv().traverseInlineText(entry.onode, a);
                continue;
            }
            if ("text:p".equals(sNodeName)) {
                String sStyleName = this.getParSc().getRealParStyleName(entry.onode.getAttribute("text:style-name"));
                int nLevel = tocReader.getIndexSourceStyleLevel(sStyleName);
                if (!tocReader.useIndexSourceStyles() || 1 > nLevel || nLevel > tocReader.getOutlineLevel()) continue;
                p = this.createEntry(ul, sEntryStyleName[nLevel]);
                if (entry.sLabel != null) {
                    p.appendChild(this.converter.createTextNode(entry.sLabel));
                }
                a = this.converter.createLink(TOC_LINK_PREFIX + i);
                p.appendChild(a);
                this.getTextCv().traverseInlineText(entry.onode, a);
                continue;
            }
            if ("text:toc-mark".equals(sNodeName)) {
                int nLevel = Misc.getPosInteger(entry.onode.getAttribute("text:outline-level"), 1);
                if (!tocReader.useIndexMarks() || nLevel > tocReader.getOutlineLevel()) continue;
                Element p3 = this.createEntry(ul, sEntryStyleName[nLevel]);
                a2 = this.converter.createLink(TOC_LINK_PREFIX + i);
                p3.appendChild(a2);
                a2.appendChild(this.converter.createTextNode(IndexMark.getIndexValue(entry.onode)));
                continue;
            }
            if (!"text:toc-mark-start".equals(sNodeName)) continue;
            int nLevel = Misc.getPosInteger(entry.onode.getAttribute("text:outline-level"), 1);
            if (!tocReader.useIndexMarks() || nLevel > tocReader.getOutlineLevel()) continue;
            Element p4 = this.createEntry(ul, sEntryStyleName[nLevel]);
            a2 = this.converter.createLink(TOC_LINK_PREFIX + i);
            p4.appendChild(a2);
            a2.appendChild(this.converter.createTextNode(IndexMark.getIndexValue(entry.onode)));
        }
        this.converter.getTextCv().setSoftPageBreaksLimit(-1);
    }

    private Element createEntry(Element ul, String sStyleName) {
        Element li = this.converter.createElement("li");
        ul.appendChild(li);
        return this.getTextCv().createParagraph(li, sStyleName);
    }
}

