/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import java.util.Enumeration;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.StyleWithProperties;
import writer2xhtml.util.CSVList;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.StyleConverterHelper;
import writer2xhtml.xhtml.StyleInfo;
import writer2xhtml.xhtml.XhtmlConfig;
import writer2xhtml.xhtml.XhtmlStyleMapItem;

public abstract class StyleWithPropertiesConverterHelper
extends StyleConverterHelper {
    public StyleWithPropertiesConverterHelper(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
    }

    public void applyStyle(String sStyleName, StyleInfo info) {
        StyleWithProperties style = (StyleWithProperties)this.getStyles().getStyle(sStyleName);
        info.sTagName = this.getDefaultTagName(style);
        if (style != null) {
            if (this.config.multilingual()) {
                StyleWithPropertiesConverterHelper.applyLang(style, info);
                StyleWithPropertiesConverterHelper.applyDirection(style, info);
            }
            if (style.isAutomatic()) {
                this.applyStyle(style.getParentName(), info);
                if (this.bConvertHard) {
                    this.applyProperties(style, info.props, false);
                }
            } else {
                String sDisplayName = style.getDisplayName();
                if (this.styleMap.contains(sDisplayName)) {
                    XhtmlStyleMapItem map = this.styleMap.get(sDisplayName);
                    if (map.sElement.length() > 0) {
                        info.sTagName = map.sElement;
                    }
                    if (!"(none)".equals(map.sCss)) {
                        info.sClass = map.sCss;
                    }
                } else {
                    info.sClass = this.getClassNamePrefix() + this.styleNames.getExportName(sDisplayName);
                }
            }
        }
    }

    @Override
    public String getStyleDeclarations(String sIndent) {
        if (this.bConvertStyles) {
            StringBuilder buf = new StringBuilder();
            Enumeration<String> names = this.styleNames.keys();
            while (names.hasMoreElements()) {
                String sDisplayName = names.nextElement();
                StyleWithProperties style = (StyleWithProperties)this.getStyles().getStyleByDisplayName(sDisplayName);
                if (style.isAutomatic()) continue;
                CSVList props = new CSVList(";");
                this.applyProperties(style, props, true);
                buf.append(sIndent);
                buf.append(this.getDefaultTagName(null));
                buf.append(".");
                buf.append(this.getClassNamePrefix());
                buf.append(this.styleNames.getExportName(sDisplayName));
                buf.append(" {");
                buf.append(props.toString());
                buf.append("}");
                buf.append(this.config.prettyPrint() ? "\n" : " ");
            }
            return buf.toString();
        }
        return "";
    }

    public String getClassNamePrefix() {
        return "";
    }

    public abstract String getDefaultTagName(StyleWithProperties var1);

    public abstract void applyProperties(StyleWithProperties var1, CSVList var2, boolean var3);
}

