/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.StyleWithProperties;
import writer2xhtml.util.Misc;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.ConverterHelper;
import writer2xhtml.xhtml.IndexData;
import writer2xhtml.xhtml.StyleInfo;
import writer2xhtml.xhtml.XhtmlConfig;

abstract class IndexConverterHelper
extends ConverterHelper {
    private String sSourceName;
    private List<IndexData> indexes = new ArrayList<IndexData>();

    IndexConverterHelper(OfficeReader ofr, XhtmlConfig config, Converter converter, String sSourceName) {
        super(ofr, config, converter);
        this.sSourceName = sSourceName;
    }

    abstract void generate(IndexData var1);

    void generate() {
        int nSaveOutFileIndex = this.converter.getOutFileIndex();
        int nIndexCount = this.indexes.size();
        for (int i = 0; i < nIndexCount; ++i) {
            this.converter.changeOutFile(this.indexes.get((int)i).nOutFileIndex);
            this.generate(this.indexes.get(i));
        }
        this.converter.changeOutFile(nSaveOutFileIndex);
    }

    void handleIndex(Element onode, Element hnode, int nChapterNumber) {
        Element source;
        Element body = Misc.getChildByTagName(onode, "text:index-body");
        if (body != null) {
            this.insertHardPageBreakBefore(body, hnode);
        }
        if ((source = Misc.getChildByTagName(onode, this.sSourceName)) != null) {
            boolean bPageBreakAfter = this.insertPageBreakBefore(source, hnode);
            Element container = this.createContainer(onode, hnode);
            this.convertTitle(source, container);
            if (bPageBreakAfter) {
                this.converter.getTextCv().insertPageBreak(container, "div");
            }
            this.convertContent(source, container, nChapterNumber);
        }
        if (body != null) {
            this.insertSoftPageBreaks(body, hnode);
        }
    }

    private Element createContainer(Element source, Element hnode) {
        String sStyleName;
        Element container = this.converter.createAlternativeElement("section", "div");
        hnode.appendChild(container);
        String sName = source.getAttribute("text:name");
        if (sName != null) {
            this.converter.addTarget(container, sName);
        }
        if ((sStyleName = source.getAttribute("text:style-name")) != null) {
            StyleInfo sectionInfo = new StyleInfo();
            this.getSectionSc().applyStyle(sStyleName, sectionInfo);
            this.applyStyle(sectionInfo, container);
        }
        return container;
    }

    private void insertHardPageBreakBefore(Element body, Element hnode) {
        StyleWithProperties style;
        String sStyleName;
        Element p;
        Element title = Misc.getChildByTagName(body, "text:index-title");
        if (title != null && (p = Misc.getChildByTagName(title, "text:p")) != null && (sStyleName = Misc.getAttribute((Node)p, "text:style-name")) != null && (style = this.ofr.getParStyle(sStyleName)) != null) {
            this.converter.getTextCv().maybePageBreak(hnode, style);
        }
    }

    private boolean insertPageBreakBefore(Element source, Element hnode) {
        StyleWithProperties style;
        String sStyleName;
        Element title = Misc.getChildByTagName(source, "text:index-title-template");
        if (title != null && (sStyleName = Misc.getAttribute((Node)title, "text:style-name")) != null && (style = this.ofr.getParStyle(sStyleName)) != null) {
            return this.converter.getTextCv().maybePageBreak(hnode, style);
        }
        return false;
    }

    private void insertSoftPageBreaks(Element body, Element hnode) {
        for (Node child = body.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!Misc.isElement(child, "text:p")) continue;
            this.traverseParagraph(child, hnode);
        }
    }

    private void traverseParagraph(Node p, Element hnode) {
        for (Node child = p.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (Misc.isElement(child, "text:soft-page-break")) {
                this.converter.getTextCv().insertPageBreak(hnode, "span");
                continue;
            }
            if (!Misc.isElement(child)) continue;
            this.traverseParagraph(child, hnode);
        }
    }

    private void convertTitle(Element source, Element container) {
        Element title = Misc.getChildByTagName(source, "text:index-title-template");
        if (title != null) {
            String sStyleName = Misc.getAttribute((Node)title, "text:style-name");
            Element h1 = this.converter.createElement("h1");
            container.appendChild(h1);
            StyleInfo info = new StyleInfo();
            info.sTagName = "h1";
            this.getHeadingSc().applyStyle(1, sStyleName, info);
            this.applyStyle(info, h1);
            this.getTextCv().traversePCDATA(title, h1);
        }
    }

    private void convertContent(Element source, Element container, int nChapterNumber) {
        Element ul = this.converter.createElement("ul");
        ul.setAttribute("style", "list-style-type:none;margin:0;padding:0");
        container.appendChild(ul);
        IndexData data = new IndexData();
        data.nOutFileIndex = this.converter.getOutFileIndex();
        data.onode = source;
        data.nChapterNumber = nChapterNumber;
        data.hnode = ul;
        this.indexes.add(data);
    }
}

