/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.PropertySet;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.NoteConverter;
import writer2xhtml.xhtml.StyleInfo;
import writer2xhtml.xhtml.XhtmlConfig;

class FootnoteConverter
extends NoteConverter {
    private boolean bFootnotesAtPage = true;

    FootnoteConverter(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        super(ofr, config, converter, ofr.getFootnotesConfiguration());
        PropertySet configuration = ofr.getFootnotesConfiguration();
        if (configuration != null) {
            this.bFootnotesAtPage = !"document".equals(configuration.getProperty("text:footnotes-position"));
        }
    }

    void insertFootnotes(Node hnode, boolean bFinal) {
        if (this.hasNotes()) {
            if (this.bFootnotesAtPage) {
                Element section = this.createNoteSection(hnode, "footnotes");
                Element rule = this.converter.createElement("hr");
                StyleInfo info = new StyleInfo();
                this.getPageSc().applyFootnoteRuleStyle(info);
                this.getPageSc().applyStyle(info, rule);
                section.appendChild(rule);
                this.flushNotes(section, "footnote");
            } else if (bFinal) {
                String sFileTitle;
                String string = sFileTitle = this.config.getFootnotesHeading().length() > 0 ? this.config.getFootnotesHeading() : this.converter.getL10n().get(10);
                if (this.config.getXhtmlSplitLevel() > 0) {
                    hnode = this.converter.nextOutFile("", sFileTitle, 1);
                }
                Element section = this.createNoteSection(hnode, "footnotes");
                this.insertNoteHeading(section, this.config.getFootnotesHeading(), "footnotes");
                this.flushNotes(section, "footnote");
            }
        }
    }
}

