/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import writer2xhtml.api.Config;
import writer2xhtml.api.ContentEntry;
import writer2xhtml.api.ConverterFactory;
import writer2xhtml.api.OutputFile;
import writer2xhtml.base.ContentEntryImpl;
import writer2xhtml.base.ConverterBase;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.StyleWithProperties;
import writer2xhtml.util.ExportNameCollection;
import writer2xhtml.util.Misc;
import writer2xhtml.xhtml.CssDocument;
import writer2xhtml.xhtml.DrawConverter;
import writer2xhtml.xhtml.LinkDescriptor;
import writer2xhtml.xhtml.MathConverter;
import writer2xhtml.xhtml.ResourceDocument;
import writer2xhtml.xhtml.StyleConverter;
import writer2xhtml.xhtml.StyleInfo;
import writer2xhtml.xhtml.TableConverter;
import writer2xhtml.xhtml.TextConverter;
import writer2xhtml.xhtml.XhtmlConfig;
import writer2xhtml.xhtml.XhtmlDocument;
import writer2xhtml.xhtml.l10n.L10n;

public class Converter
extends ConverterBase {
    private static final String EPUB_STYLES_FOLDER = "styles/";
    private static final String EPUB_STYLESHEET = "styles/styles1.css";
    private static final String EPUB_CUSTOM_STYLESHEET = "styles/styles.css";
    private XhtmlConfig config;
    private L10n l10n;
    private StyleConverter styleCv;
    private TextConverter textCv;
    private TableConverter tableCv;
    private DrawConverter drawCv;
    private MathConverter mathCv;
    private XhtmlDocument template = null;
    private CssDocument styleSheet = null;
    private Set<ResourceDocument> resources = new HashSet<ResourceDocument>();
    protected int nType = 0;
    private boolean bOPS = false;
    List<XhtmlDocument> outFiles;
    private int nOutFileIndex;
    private XhtmlDocument htmlDoc;
    private Document htmlDOM;
    private boolean bNeedHeaderFooter = false;
    private Set<String> usedFileTitles = new HashSet<String>();
    private ExportNameCollection fileNames = new ExportNameCollection("", true, "-");
    Map<String, Integer> targets = new HashMap<String, Integer>();
    List<LinkDescriptor> links = new ArrayList<LinkDescriptor>();
    private ExportNameCollection targetNames = new ExportNameCollection(true);
    private String pageContentWidth = null;
    private Stack<String> contentWidth = new Stack();

    @Override
    public Config getConfig() {
        return this.config;
    }

    protected XhtmlConfig getXhtmlConfig() {
        return this.config;
    }

    public Converter(int nType) {
        this.config = new XhtmlConfig();
        this.nType = nType;
    }

    @Override
    public void readTemplate(InputStream is) throws IOException {
        this.template = new XhtmlDocument("Template", this.nType, null, null, -1);
        this.template.read(is);
    }

    @Override
    public void readTemplate(File file) throws IOException {
        this.readTemplate(new FileInputStream(file));
    }

    @Override
    public void readStyleSheet(InputStream is) throws IOException {
        if (this.styleSheet == null) {
            this.styleSheet = new CssDocument(EPUB_CUSTOM_STYLESHEET);
        }
        this.styleSheet.read(is);
    }

    @Override
    public void readStyleSheet(File file) throws IOException {
        this.readStyleSheet(new FileInputStream(file));
    }

    @Override
    public void readResource(InputStream is, String sFileName, String sMediaType) throws IOException {
        if (sMediaType == null) {
            sMediaType = "";
            String sfilename = sFileName.toLowerCase();
            if (sfilename.endsWith(".png")) {
                sMediaType = "image/png";
            } else if (sfilename.endsWith(".jpg")) {
                sMediaType = "image/jpeg";
            } else if (sfilename.endsWith(".jpeg")) {
                sMediaType = "image/jpeg";
            } else if (sfilename.endsWith(".gif")) {
                sMediaType = "image/gif";
            } else if (sfilename.endsWith(".otf")) {
                sMediaType = "application/vnd.ms-opentype";
            } else if (sfilename.endsWith(".ttf")) {
                sMediaType = "application/x-font-ttf";
            }
        }
        ResourceDocument doc = new ResourceDocument(EPUB_STYLES_FOLDER + sFileName, sMediaType);
        doc.read(is);
        this.resources.add(doc);
    }

    @Override
    public void readResource(File file, String sFileName, String sMediaType) throws IOException {
        this.readResource(new FileInputStream(file), sFileName, sMediaType);
    }

    protected String getContentWidth() {
        if (!this.contentWidth.isEmpty()) {
            return this.contentWidth.peek();
        }
        return this.pageContentWidth;
    }

    protected void setPageContentWidth(String sWidth) {
        this.pageContentWidth = sWidth;
    }

    protected String pushContentWidth(String sWidth) {
        return this.contentWidth.push(sWidth);
    }

    protected void popContentWidth() {
        this.contentWidth.pop();
    }

    protected boolean isTopLevel() {
        return this.contentWidth.size() == 1;
    }

    protected StyleConverter getStyleCv() {
        return this.styleCv;
    }

    protected TextConverter getTextCv() {
        return this.textCv;
    }

    protected TableConverter getTableCv() {
        return this.tableCv;
    }

    protected DrawConverter getDrawCv() {
        return this.drawCv;
    }

    protected MathConverter getMathCv() {
        return this.mathCv;
    }

    protected int getType() {
        return this.nType;
    }

    public boolean isHTML5() {
        return this.nType >= 3;
    }

    protected int getOutFileIndex() {
        return this.nOutFileIndex;
    }

    protected void addContentEntry(String sTitle, int nLevel, String sTarget) {
        this.converterResult.addContentEntry(new ContentEntryImpl(sTitle, nLevel, this.htmlDoc, sTarget));
    }

    protected void setTocFile(String sTarget) {
        this.converterResult.setTocFile(new ContentEntryImpl(this.l10n.get(5), 1, this.htmlDoc, sTarget));
    }

    protected void setLofFile(String sTarget) {
        this.converterResult.setLofFile(new ContentEntryImpl("Figures", 1, this.htmlDoc, sTarget));
    }

    protected void setLotFile(String sTarget) {
        this.converterResult.setLotFile(new ContentEntryImpl("Tables", 1, this.htmlDoc, sTarget));
    }

    protected void setIndexFile(String sTarget) {
        this.converterResult.setIndexFile(new ContentEntryImpl(this.l10n.get(6), 1, this.htmlDoc, sTarget));
    }

    protected void setCoverFile(String sTarget) {
        this.converterResult.setCoverFile(new ContentEntryImpl("Cover", 0, this.htmlDoc, sTarget));
    }

    protected void setCoverImageFile(OutputFile file, String sTarget) {
        this.converterResult.setCoverImageFile(new ContentEntryImpl("Cover image", 0, file, sTarget));
    }

    protected void addOriginalPageNumber(String sTitle, int nLevel, String sTarget) {
        this.converterResult.addOriginalPageNumber(new ContentEntryImpl(sTitle, nLevel, this.htmlDoc, sTarget));
    }

    protected void removeOriginalPageNumber() {
        this.converterResult.removeOriginalPageNumber();
    }

    protected Element createElement(String s) {
        return this.htmlDOM.createElement(s);
    }

    protected Comment createComment(String s) {
        return this.htmlDOM.createComment(s);
    }

    Element createAlternativeElement(String sHTML5, String sHTML) {
        if (!(!this.isHTML5() || this.isOPS() && this.config.avoidHtml5())) {
            return this.createElement(sHTML5);
        }
        return this.createElement(sHTML);
    }

    protected Text createTextNode(String s) {
        return this.htmlDOM.createTextNode(s);
    }

    protected Node importNode(Node node, boolean bDeep) {
        return this.htmlDOM.importNode(node, bDeep);
    }

    protected void setContainsMath() {
        this.outFiles.get(this.nOutFileIndex).setContainsMath();
    }

    protected L10n getL10n() {
        return this.l10n;
    }

    public void setOPS(boolean b) {
        this.bOPS = true;
    }

    public boolean isOPS() {
        return this.bOPS;
    }

    @Override
    public void convertInner() throws IOException {
        this.sTargetFileName = Misc.trimDocumentName(this.sTargetFileName, XhtmlDocument.getExtension(this.nType));
        this.outFiles = new ArrayList<XhtmlDocument>();
        this.nOutFileIndex = -1;
        this.bNeedHeaderFooter = !this.bOPS && (this.ofr.isSpreadsheet() || this.config.getXhtmlSplitLevel() > 0 || this.config.pageBreakSplit() > 0 || this.config.getXhtmlUplink().length() > 0);
        this.setLocale();
        this.initializeImageConverter();
        this.initializeConverterHelpers();
        this.setPageContentWidth(this.getStyleCv().getPageSc().getTextWidth(this.ofr.getFirstMasterPage()));
        Element body = this.ofr.getContent();
        if (this.ofr.isSpreadsheet()) {
            this.tableCv.convertTableContent(body);
        } else {
            this.textCv.convertTextContent(body);
        }
        this.addTitleAndTextPageEntries();
        this.resolveLinks();
        this.loadMathJax();
        this.generateHeadersAndFooters();
        this.generatePanels();
        this.exportStyles();
    }

    private void setLocale() {
        StyleWithProperties style;
        this.l10n = new L10n();
        StyleWithProperties styleWithProperties = style = this.ofr.isSpreadsheet() ? this.ofr.getDefaultCellStyle() : this.ofr.getDefaultParStyle();
        if (style != null) {
            if ("fa".equals(style.getProperty("style:language-complex"))) {
                this.l10n.setLocale("fa", "IR");
            } else {
                this.l10n.setLocale(style.getProperty("fo:language"), style.getProperty("fo:country"));
            }
        }
    }

    private void initializeImageConverter() {
        this.imageConverter.setUseBase64(this.config.embedImg());
        if (this.isOPS()) {
            this.imageConverter.setBaseFileName("image");
            this.imageConverter.setUseSubdir("images");
        } else {
            this.imageConverter.setBaseFileName(this.sTargetFileName + "-img");
            if (this.config.saveImagesInSubdir()) {
                this.imageConverter.setUseSubdir(this.sTargetFileName + "-img");
            }
        }
        this.imageConverter.setDefaultFormat("image/png");
        this.imageConverter.addAcceptedFormat("image/jpeg");
        this.imageConverter.addAcceptedFormat("image/gif");
        if (this.isHTML5()) {
            this.imageConverter.setDefaultVectorFormat("image/svg+xml");
        }
    }

    private void initializeConverterHelpers() {
        this.styleCv = new StyleConverter(this.ofr, this.config, this, this.nType);
        this.textCv = new TextConverter(this.ofr, this.config, this);
        this.tableCv = new TableConverter(this.ofr, this.config, this);
        this.drawCv = new DrawConverter(this.ofr, this.config, this);
        this.mathCv = new MathConverter(this.ofr, this.config, this, this.nType != 0 && this.nType != 1);
    }

    private void addTitleAndTextPageEntries() {
        if (this.converterResult.getContent().isEmpty()) {
            this.converterResult.setTextFile(new ContentEntryImpl("Text", 1, this.outFiles.get(0), null));
            this.converterResult.addContentEntry(new ContentEntryImpl("Text", 1, this.outFiles.get(0), null));
        } else {
            int nFirstPage;
            ContentEntry firstHeading = this.converterResult.getContent().get(0);
            int n = nFirstPage = this.converterResult.getCoverFile() != null ? 1 : 0;
            if (this.outFiles.get(nFirstPage) != firstHeading.getFile() || firstHeading.getTarget() != null) {
                this.converterResult.setTitlePageFile(new ContentEntryImpl("Title page", 1, this.outFiles.get(nFirstPage), null));
            }
            this.converterResult.setTextFile(new ContentEntryImpl("Text", 1, firstHeading.getFile(), firstHeading.getTarget()));
        }
    }

    private void resolveLinks() {
        for (LinkDescriptor ld : this.links) {
            Integer targetIndex = this.targets.get(ld.sId);
            if (targetIndex == null) continue;
            int nTargetIndex = targetIndex;
            if (nTargetIndex == ld.nIndex) {
                ld.element.setAttribute("href", "#" + this.targetNames.getExportName(ld.sId));
            } else {
                ld.element.setAttribute("href", this.outFiles.get(nTargetIndex).getFileName() + "#" + this.targetNames.getExportName(ld.sId));
            }
            if (!ld.bPageRef) continue;
            ld.element.appendChild(ld.element.getOwnerDocument().createTextNode(Integer.toString(nTargetIndex + 1)));
        }
    }

    private void loadMathJax() {
        if ((this.isHTML5() || this.nType == 2) && this.config.useMathJax()) {
            for (int i = 0; i <= this.nOutFileIndex; ++i) {
                XhtmlDocument doc;
                Element head;
                if (!this.outFiles.get(i).containsMath() || (head = (doc = this.outFiles.get(i)).getHeadNode()) == null) continue;
                Element script = doc.getContentDOM().createElement("script");
                head.appendChild(script);
                if (!this.isHTML5()) {
                    script.setAttribute("type", "text/javascript");
                }
                script.setAttribute("src", "https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.4/latest.js?config=TeX-MML-AM_CHTML");
                script.setAttribute("async", "async");
            }
        }
    }

    private void generateHeadersAndFooters() {
        for (int nFileIndex = 0; nFileIndex <= this.nOutFileIndex; ++nFileIndex) {
            XhtmlDocument doc = this.outFiles.get(nFileIndex);
            if (this.ofr.isSpreadsheet()) {
                this.generateHeaderOrFooterCalc(nFileIndex, doc.getContentDOM(), doc.getHeaderNode());
                this.generateHeaderOrFooterCalc(nFileIndex, doc.getContentDOM(), doc.getFooterNode());
            } else {
                this.generateHeaderOrFooterWriter(nFileIndex, doc.getContentDOM(), doc.getHeaderNode());
                this.generateHeaderOrFooterWriter(nFileIndex, doc.getContentDOM(), doc.getFooterNode());
            }
            if (doc.getFooterNode() == null) continue;
            doc.getFooterNode().setAttribute("style", "clear:both");
        }
    }

    private void generateHeaderOrFooterCalc(int nFileIndex, Document dom, Element hnode) {
        if (hnode != null) {
            this.addUplink(dom, hnode);
            int nSheets = this.tableCv.sheetNames.size();
            for (int nSheetIndex = 0; nSheetIndex < nSheets; ++nSheetIndex) {
                if (this.config.xhtmlCalcSplit()) {
                    this.addNavigationLink(dom, hnode, this.tableCv.sheetNames.get(nSheetIndex), nFileIndex, nSheetIndex);
                    continue;
                }
                this.addInternalNavigationLink(dom, hnode, this.tableCv.sheetNames.get(nSheetIndex), "tableheading" + nSheetIndex);
            }
        }
    }

    private void generateHeaderOrFooterWriter(int nFileIndex, Document dom, Element hnode) {
        if (hnode != null) {
            this.addUplink(dom, hnode);
            if (this.config.getXhtmlSplitLevel() > 0) {
                this.addNavigationLink(dom, hnode, this.l10n.get(1), nFileIndex, 0);
                this.addNavigationLink(dom, hnode, this.l10n.get(2), nFileIndex, nFileIndex - 1);
                this.addNavigationLink(dom, hnode, this.l10n.get(3), nFileIndex, nFileIndex + 1);
                this.addNavigationLink(dom, hnode, this.l10n.get(4), nFileIndex, this.nOutFileIndex);
                if (this.textCv.getTocIndex() >= 0) {
                    this.addNavigationLink(dom, hnode, this.l10n.get(5), nFileIndex, this.textCv.getTocIndex());
                }
                if (this.textCv.getAlphabeticalIndex() >= 0) {
                    this.addNavigationLink(dom, hnode, this.l10n.get(6), nFileIndex, this.textCv.getAlphabeticalIndex());
                }
            }
        }
    }

    private void addUplink(Document dom, Element hnode) {
        if (!this.config.getXhtmlUplink().isEmpty()) {
            Element a = dom.createElement("a");
            a.setAttribute("href", this.config.getXhtmlUplink());
            a.appendChild(dom.createTextNode(this.l10n.get(0)));
            hnode.appendChild(a);
            hnode.appendChild(dom.createTextNode(" "));
        }
    }

    private void generatePanels() {
        for (int nSourceIndex = 0; nSourceIndex <= this.nOutFileIndex; ++nSourceIndex) {
            XhtmlDocument doc = this.outFiles.get(nSourceIndex);
            Element panel = doc.getPanelNode();
            if (panel == null) continue;
            Document dom = doc.getContentDOM();
            int nCurrentLevel = 1;
            for (int nTargetIndex = 0; nTargetIndex <= this.nOutFileIndex; ++nTargetIndex) {
                int nThisLevel = this.outFiles.get(nTargetIndex).getOutlineLevel();
                if (nThisLevel < nCurrentLevel) {
                    nCurrentLevel = nThisLevel;
                } else if (nThisLevel > nCurrentLevel) {
                    if (nTargetIndex == nSourceIndex + 1) {
                        nCurrentLevel = nThisLevel;
                    } else {
                        int n = nTargetIndex;
                        while (n <= this.nOutFileIndex && this.outFiles.get(n).getOutlineLevel() > nCurrentLevel) {
                            if (n++ != nSourceIndex) continue;
                            nCurrentLevel = nThisLevel;
                        }
                    }
                }
                if (nThisLevel != nCurrentLevel) continue;
                Element p = dom.createElement("p");
                p.setAttribute("class", "level" + nThisLevel);
                panel.appendChild(p);
                this.addNavigationLink(dom, p, this.outFiles.get(nTargetIndex).getFileLabel() + this.outFiles.get(nTargetIndex).getFileTitle(), nSourceIndex, nTargetIndex);
            }
        }
    }

    private void addNavigationLink(Document dom, Node node, String sTitle, int nSourceIndex, int nTargetIndex) {
        if (nTargetIndex >= 0 && nTargetIndex <= this.nOutFileIndex && nSourceIndex != nTargetIndex) {
            Element a = dom.createElement("a");
            a.setAttribute("href", Misc.makeHref(this.outFiles.get(nTargetIndex).getFileName()));
            a.appendChild(dom.createTextNode(sTitle));
            node.appendChild(a);
            node.appendChild(dom.createTextNode(" "));
        } else {
            Element span = dom.createElement("span");
            span.setAttribute("class", "nolink");
            node.appendChild(span);
            span.appendChild(dom.createTextNode(sTitle));
            node.appendChild(dom.createTextNode(" "));
        }
    }

    private void addInternalNavigationLink(Document dom, Node node, String s, String sLink) {
        Element a = dom.createElement("a");
        a.setAttribute("href", "#" + sLink);
        a.appendChild(dom.createTextNode(s));
        node.appendChild(a);
        node.appendChild(dom.createTextNode(" "));
    }

    private void exportStyles() {
        if (this.bOPS && this.styleSheet != null) {
            this.converterResult.addDocument(this.styleSheet);
            for (ResourceDocument doc : this.resources) {
                this.converterResult.addDocument(doc);
            }
        }
        if (!this.isOPS() && !this.config.separateStylesheet()) {
            for (int i = 0; i <= this.nOutFileIndex; ++i) {
                Node styles;
                Element head = this.outFiles.get(i).getHeadNode();
                if (head == null || (styles = this.styleCv.exportStyles(this.outFiles.get(i).getContentDOM())) == null) continue;
                head.appendChild(styles);
            }
        }
        if (this.config.xhtmlFormatting() > 1) {
            CssDocument cssDoc;
            if (this.isOPS()) {
                cssDoc = new CssDocument(EPUB_STYLESHEET);
                cssDoc.read(this.styleCv.exportStyles(false));
                this.converterResult.addDocument(cssDoc);
            } else if (this.config.separateStylesheet()) {
                cssDoc = new CssDocument(this.sTargetFileName + "-styles.css");
                cssDoc.read(this.styleCv.exportStyles(false));
                this.converterResult.addDocument(cssDoc);
            }
        }
    }

    protected String getPlainInlineText(Node node) {
        StringBuilder buf = new StringBuilder();
        block4: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            short nodeType = child.getNodeType();
            switch (nodeType) {
                case 3: {
                    buf.append(child.getNodeValue());
                    continue block4;
                }
                case 1: {
                    String sName = child.getNodeName();
                    if (sName.equals("text:s")) {
                        buf.append(" ");
                        continue block4;
                    }
                    if (sName.equals("text:line-break") || sName.equals("text:tab-stop") || sName.equals("text:tab")) {
                        buf.append(" ");
                        continue block4;
                    }
                    if (OfficeReader.isNoteElement(child) || !OfficeReader.isTextElement(child)) continue block4;
                    buf.append(this.getPlainInlineText(child));
                    continue block4;
                }
            }
        }
        return buf.toString();
    }

    public void handleOfficeAnnotation(Node onode, Node hnode) {
        if (this.config.xhtmlNotes()) {
            StringBuilder buf = new StringBuilder();
            Element creator = null;
            Element date = null;
            for (Node child = onode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (Misc.isElement(child, "text:p")) {
                    if (buf.length() > 0) {
                        buf.append('\n');
                    }
                    buf.append(this.getPlainInlineText(child));
                    continue;
                }
                if (Misc.isElement(child, "dc:creator")) {
                    creator = (Element)child;
                    continue;
                }
                if (!Misc.isElement(child, "dc:date")) continue;
                date = (Element)child;
            }
            if (creator != null) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append(this.getPlainInlineText(creator));
            }
            if (date != null) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append(Misc.formatDate(OfficeReader.getTextContent(date), this.l10n.getLocale().getLanguage(), this.l10n.getLocale().getCountry()));
            }
            Comment commentNode = this.htmlDOM.createComment(buf.toString());
            hnode.appendChild(commentNode);
        }
    }

    public boolean outFileHasContent() {
        if (this.htmlDoc.getContentNode().hasChildNodes()) {
            Node child = this.htmlDoc.getContentNode().getFirstChild();
            if (Misc.isElement(child, "div") && "pagebreak".equals(Misc.getAttribute(child, "epub:type"))) {
                return child.getNextSibling() != null;
            }
            return true;
        }
        return false;
    }

    public void changeOutFile(int nIndex) {
        this.nOutFileIndex = nIndex;
        this.htmlDoc = this.outFiles.get(nIndex);
        this.htmlDOM = this.htmlDoc.getContentDOM();
    }

    public Element getPanelNode() {
        return this.htmlDoc.getPanelNode();
    }

    public Element nextOutFile(String sFileLabel, String sFileTitle, int nLevel) {
        Element head;
        Element title;
        ++this.nOutFileIndex;
        String sFinalFileName = this.sTargetFileName;
        if (this.nOutFileIndex > 0) {
            if (this.config.getFilenames() == 0 || sFileTitle == null) {
                sFinalFileName = this.sTargetFileName + this.nOutFileIndex;
            } else {
                String sModifiedTitle = sFileTitle.replace(' ', '-').toLowerCase();
                if (this.usedFileTitles.contains(sModifiedTitle)) {
                    int n = 0;
                    while (this.usedFileTitles.contains(sModifiedTitle + ++n)) {
                    }
                    sModifiedTitle = sModifiedTitle + n;
                }
                this.usedFileTitles.add(sModifiedTitle);
                sFinalFileName = this.config.getFilenames() == 1 ? this.sTargetFileName + "-" + this.fileNames.getExportName(sModifiedTitle) : this.fileNames.getExportName(sModifiedTitle);
            }
        }
        this.htmlDoc = new XhtmlDocument(sFinalFileName, this.nType, sFileLabel, sFileTitle, nLevel);
        this.htmlDoc.setConfig(this.config);
        if (this.template != null) {
            this.htmlDoc.readFromTemplate(this.template);
        } else if (this.bNeedHeaderFooter) {
            this.htmlDoc.createHeaderFooter();
        }
        this.outFiles.add(this.nOutFileIndex, this.htmlDoc);
        this.converterResult.addDocument(this.htmlDoc);
        this.htmlDOM = this.htmlDoc.getContentDOM();
        Element rootElement = this.htmlDOM.getDocumentElement();
        this.styleCv.applyDefaultLanguage(rootElement);
        this.addEpubNs(rootElement);
        rootElement.insertBefore(this.htmlDOM.createComment("This file was converted to HTML by " + (this.ofr.isSpreadsheet() ? "Calc" : "Writer") + "2xhtml ver. " + ConverterFactory.getVersion() + ". See http://writer2xhtml.sourceforge.net for more info."), rootElement.getFirstChild());
        if (!this.ofr.isPresentation()) {
            StyleInfo pageInfo = new StyleInfo();
            this.styleCv.getPageSc().applyDefaultWritingDirection(pageInfo);
            this.styleCv.getPageSc().applyStyle(pageInfo, this.htmlDoc.getContentNode());
        }
        if ((title = this.htmlDoc.getTitleNode()) != null) {
            String sTitle = this.metaData.getTitle();
            if (sTitle == null || sTitle.length() == 0) {
                sTitle = Misc.removeExtension(this.htmlDoc.getFileName());
            }
            title.appendChild(this.htmlDOM.createTextNode(sTitle));
        }
        if ((head = this.htmlDoc.getHeadNode()) != null) {
            Element htmlStyle;
            Element meta;
            if (this.nType == 0) {
                meta = this.htmlDOM.createElement("meta");
                meta.setAttribute("http-equiv", "Content-Type");
                meta.setAttribute("content", "text/html; charset=" + this.htmlDoc.getEncoding().toLowerCase());
                head.appendChild(meta);
            } else if (this.isHTML5()) {
                meta = this.htmlDOM.createElement("meta");
                meta.setAttribute("charset", this.htmlDoc.getEncoding().toUpperCase());
                head.appendChild(meta);
            }
            if (!this.bOPS) {
                this.createMeta(head, "description", this.metaData.getDescription());
                this.createMeta(head, "keywords", this.metaData.getKeywords());
                if (this.config.xhtmlUseDublinCore()) {
                    if (!this.isHTML5()) {
                        head.setAttribute("profile", "http://dublincore.org/documents/2008/08/04/dc-html/");
                    }
                    Element dclink = this.htmlDOM.createElement("link");
                    dclink.setAttribute("rel", "schema.DC");
                    dclink.setAttribute("href", "http://purl.org/dc/elements/1.1/");
                    head.appendChild(dclink);
                    this.createMeta(head, "DC.title", this.metaData.getTitle());
                    String sDCSubject = "";
                    if (this.metaData.getSubject() != null && this.metaData.getSubject().length() > 0) {
                        sDCSubject = this.metaData.getSubject();
                    }
                    if (this.metaData.getKeywords() != null && this.metaData.getKeywords().length() > 0) {
                        if (sDCSubject.length() > 0) {
                            sDCSubject = sDCSubject + ", ";
                        }
                        sDCSubject = sDCSubject + this.metaData.getKeywords();
                    }
                    this.createMeta(head, "DC.subject", sDCSubject);
                    this.createMeta(head, "DC.description", this.metaData.getDescription());
                    this.createMeta(head, "DC.creator", this.metaData.getCreator());
                    this.createMeta(head, "DC.date", this.metaData.getDate());
                    this.createMeta(head, "DC.language", this.metaData.getLanguage());
                }
            }
            if (!this.bOPS && this.config.xhtmlCustomStylesheet().length() > 0) {
                htmlStyle = this.htmlDOM.createElement("link");
                htmlStyle.setAttribute("rel", "stylesheet");
                if (!this.isHTML5()) {
                    htmlStyle.setAttribute("type", "text/css");
                }
                htmlStyle.setAttribute("media", "all");
                htmlStyle.setAttribute("href", this.config.xhtmlCustomStylesheet());
                head.appendChild(htmlStyle);
            }
            if (!this.bOPS && this.config.separateStylesheet() && this.config.xhtmlFormatting() > 1) {
                htmlStyle = this.htmlDOM.createElement("link");
                htmlStyle.setAttribute("rel", "stylesheet");
                if (!this.isHTML5()) {
                    htmlStyle.setAttribute("type", "text/css");
                }
                htmlStyle.setAttribute("media", "all");
                htmlStyle.setAttribute("href", this.sTargetFileName + "-styles.css");
                head.appendChild(htmlStyle);
            }
            if (this.bOPS && this.styleSheet != null) {
                Element sty = this.htmlDOM.createElement("link");
                sty.setAttribute("rel", "stylesheet");
                if (!this.isHTML5()) {
                    sty.setAttribute("type", "text/css");
                }
                sty.setAttribute("href", EPUB_CUSTOM_STYLESHEET);
                head.appendChild(sty);
            }
            if (this.isOPS() && this.config.xhtmlFormatting() > 1) {
                htmlStyle = this.htmlDOM.createElement("link");
                htmlStyle.setAttribute("rel", "stylesheet");
                if (!this.isHTML5()) {
                    htmlStyle.setAttribute("type", "text/css");
                }
                htmlStyle.setAttribute("href", EPUB_STYLESHEET);
                head.appendChild(htmlStyle);
            }
        }
        return this.htmlDoc.getContentNode();
    }

    public void addEpubNs(Element elm) {
        if (this.bOPS && this.isHTML5()) {
            elm.setAttribute("xmlns:epub", "http://www.idpf.org/2007/ops");
        }
    }

    public void addEpubType(Element elm, String sType) {
        if (this.bOPS && this.isHTML5() && sType != null) {
            elm.setAttribute("epub:type", sType);
        }
    }

    public Element createTarget(String sId) {
        Element a = this.htmlDOM.createElement("a");
        a.setAttribute("id", this.targetNames.getExportName(sId));
        this.targets.put(sId, this.nOutFileIndex);
        return a;
    }

    public void addTarget(Element node, String sId) {
        node.setAttribute("id", this.targetNames.getExportName(sId));
        this.targets.put(sId, this.nOutFileIndex);
    }

    String getTarget(String sId) {
        return this.targetNames.getExportName(sId);
    }

    public Element createLink(String sId) {
        return this.createLink(sId, false);
    }

    public Element createLink(String sId, boolean bPageRef) {
        Element a = this.htmlDOM.createElement("a");
        LinkDescriptor ld = new LinkDescriptor();
        ld.element = a;
        ld.sId = sId;
        ld.nIndex = this.nOutFileIndex;
        ld.bPageRef = bPageRef;
        this.links.add(ld);
        return a;
    }

    public Element createLink(Element onode) {
        Element anchor;
        String sHref = onode.getAttribute("xlink:href");
        if (sHref.startsWith("#")) {
            anchor = this.createLink(sHref.substring(1), false);
        } else {
            String sTarget;
            int n3F;
            anchor = this.htmlDOM.createElement("a");
            if ((sHref = this.ofr.fixRelativeLink(sHref)).indexOf("?") == -1 && (n3F = sHref.indexOf("%3F")) > 0) {
                sHref = sHref.substring(0, n3F) + "?" + sHref.substring(n3F + 3);
            }
            anchor.setAttribute("href", sHref);
            String sName = Misc.getAttribute(onode, "office:name");
            if (sName != null) {
                if (sName.indexOf(";") == -1 && sName.indexOf("=") == -1) {
                    anchor.setAttribute("name", sName);
                    anchor.setAttribute("title", sName);
                } else {
                    String[] sElements;
                    for (String sElement : sElements = sName.split(";")) {
                        String[] sNameVal = sElement.split("=");
                        if (sNameVal.length < 2) continue;
                        anchor.setAttribute(sNameVal[0].trim(), sNameVal[1].trim());
                    }
                }
            }
            if ((sTarget = Misc.getAttribute(onode, "office:target-frame-name")) != null) {
                anchor.setAttribute("target", sTarget);
            }
        }
        String sStyleName = onode.getAttribute("text:style-name");
        String sVisitedStyleName = onode.getAttribute("text:visited-style-name");
        StyleInfo anchorInfo = new StyleInfo();
        this.styleCv.getTextSc().applyAnchorStyle(sStyleName, sVisitedStyleName, anchorInfo);
        this.styleCv.getTextSc().applyStyle(anchorInfo, anchor);
        return anchor;
    }

    private void createMeta(Element head, String sName, String sValue) {
        if (sValue == null) {
            return;
        }
        Element meta = this.htmlDOM.createElement("meta");
        meta.setAttribute("name", sName);
        meta.setAttribute("content", sValue);
        head.appendChild(meta);
    }
}

