/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.office;

import java.util.LinkedList;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.StyleWithProperties;
import writer2xhtml.office.TableLine;
import writer2xhtml.office.TableRange;
import writer2xhtml.office.TableRangeParser;
import writer2xhtml.util.Calc;
import writer2xhtml.util.Misc;

public class TableReader {
    private Element tableNode;
    private LinkedList<TableLine> cols = new LinkedList();
    private LinkedList<TableLine> rows = new LinkedList();
    private LinkedList<LinkedList<Element>> cells = new LinkedList();
    private int nMaxCols = 1;
    private int nMaxRows = 1;
    private String[] sColWidth;
    private String[] sRelColWidth;
    private String sTableWidth;
    private String sRelTableWidth;
    private Vector<TableRange> printRanges;
    private int nRowCount;
    private int nEmptyRowCount;

    public TableReader(OfficeReader ofr, Element tableNode) {
        int nCol;
        this.tableNode = tableNode;
        if (!tableNode.hasChildNodes()) {
            return;
        }
        this.countTableRows(tableNode);
        NodeList nl = tableNode.getChildNodes();
        int nLen = nl.getLength();
        for (int i = 0; i < nLen; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            String sName = child.getNodeName();
            if (sName.equals("table:table-column")) {
                this.readTableColumn(child, false, false);
                continue;
            }
            if (sName.equals("table:table-columns")) {
                this.readTableColumns(child, false, false);
                continue;
            }
            if (sName.equals("table:table-column-group")) {
                this.readTableColumnGroup(child, false, false);
                continue;
            }
            if (sName.equals("table:table-header-columns")) {
                this.readTableHeaderColumns(child, false, false);
                continue;
            }
            if (sName.equals("table:table-row")) {
                this.readTableRow(child, false, false);
                continue;
            }
            if (sName.equals("table:table-rows")) {
                this.readTableRows(child, false, false);
                continue;
            }
            if (sName.equals("table:table-row-group")) {
                this.readTableRowGroup(child, false, false);
                continue;
            }
            if (!sName.equals("table:table-header-rows")) continue;
            this.readTableHeaderRows(child, false, false);
        }
        StyleWithProperties tableStyle = ofr.getTableStyle(this.getTableStyleName());
        if (tableStyle != null) {
            this.sTableWidth = tableStyle.getProperty("style:width");
            this.sRelTableWidth = tableStyle.getProperty("style:rel-width");
        }
        int nCols = this.cols.size();
        this.sColWidth = new String[nCols];
        this.sRelColWidth = new String[nCols];
        int[] nRelColWidth = new int[nCols];
        boolean bHasRelWidth = true;
        int nColSum = 0;
        for (nCol = 0; nCol < nCols; ++nCol) {
            StyleWithProperties style = ofr.getColumnStyle(this.cols.get(nCol).getStyleName());
            if (style != null) {
                this.sColWidth[nCol] = style.getProperty("style:column-width");
                String s = style.getProperty("style:rel-column-width");
                if (s != null && s.endsWith("*")) {
                    nRelColWidth[nCol] = Misc.getPosInteger(s.substring(0, s.length() - 1), 1);
                }
            }
            if (this.sColWidth[nCol] == null) {
                this.sColWidth[nCol] = "2cm";
            }
            if (nRelColWidth[nCol] == 0) {
                bHasRelWidth = false;
            }
            nColSum += nRelColWidth[nCol];
        }
        for (nCol = 0; nCol < nCols; ++nCol) {
            this.sRelColWidth[nCol] = bHasRelWidth ? 100.0f * (float)nRelColWidth[nCol] / (float)nColSum + "%" : (this.sTableWidth != null ? Calc.divide(this.sColWidth[nCol], this.sTableWidth, true) : Double.toString(100.0 / (double)nCols) + "%");
        }
        int nRows = this.cells.size();
        for (int nRow = 0; nRow < nRows; ++nRow) {
            LinkedList<Element> row = this.cells.get(nRow);
            nCols = row.size();
            int nMaxCol = 0;
            int nMaxRow = 0;
            for (int nCol2 = 0; nCol2 < nCols; ++nCol2) {
                Element cell = row.get(nCol2);
                if (!cell.hasChildNodes()) continue;
                nMaxRow = nRow + Misc.getPosInteger(cell.getAttribute("table:number-rows-spanned"), 1);
                if (nMaxRow > this.nMaxRows) {
                    this.nMaxRows = nMaxRow;
                }
                if ((nMaxCol = nCol2 + Misc.getPosInteger(cell.getAttribute("table:number-columns-spanned"), 1)) <= this.nMaxCols) continue;
                this.nMaxCols = nMaxCol;
            }
        }
        this.printRanges = new Vector();
        if (!"false".equals(tableNode.getAttribute("table:print"))) {
            TableRangeParser parser = new TableRangeParser(tableNode.getAttribute("table:print-ranges"));
            while (parser.hasMoreRanges()) {
                int[] nRange = parser.getRange();
                TableRange range = new TableRange(this);
                range.setFirstCol(nRange[0]);
                range.setFirstRow(nRange[1]);
                range.setLastCol(nRange[2]);
                range.setLastRow(nRange[3]);
                this.printRanges.add(range);
            }
        }
    }

    private void readTableColumn(Node node, boolean bHeader, boolean bDisplay) {
        int nRepeat = Misc.getPosInteger(Misc.getAttribute(node, "table:number-columns-repeated"), 1);
        while (nRepeat-- > 0) {
            this.cols.add(new TableLine(node, bHeader, bDisplay));
        }
    }

    private void readTableColumns(Node node, boolean bHeader, boolean bDisplay) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        for (int i = 0; i < nLen; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            String sName = child.getNodeName();
            if (sName.equals("table:table-column")) {
                this.readTableColumn(child, bHeader, bDisplay);
                continue;
            }
            if (!sName.equals("table:table-column-group")) continue;
            this.readTableColumnGroup(child, bHeader, bDisplay);
        }
    }

    private void readTableColumnGroup(Node node, boolean bHeader, boolean bDisplay) {
        boolean bl = bDisplay = !"false".equals(Misc.getAttribute(node, "table:display"));
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        for (int i = 0; i < nLen; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            String sName = child.getNodeName();
            if (sName.equals("table:table-header-columns")) {
                this.readTableHeaderColumns(child, bHeader, bDisplay);
                continue;
            }
            if (sName.equals("table:table-column")) {
                this.readTableColumn(child, bHeader, bDisplay);
                continue;
            }
            if (!sName.equals("table:table-column-group")) continue;
            this.readTableColumnGroup(child, bHeader, bDisplay);
        }
    }

    private void readTableHeaderColumns(Node node, boolean bHeader, boolean bDisplay) {
        this.readTableColumns(node, true, bDisplay);
    }

    private void readTableRow(Node node, boolean bHeader, boolean bDisplay) {
        int nRepeat = Misc.getPosInteger(Misc.getAttribute(node, "table:number-rows-repeated"), 1);
        while (nRepeat-- > 0 && this.rows.size() < this.nRowCount) {
            this.rows.add(new TableLine(node, bHeader, bDisplay));
            LinkedList<Element> row = new LinkedList<Element>();
            if (node.hasChildNodes()) {
                NodeList nl = node.getChildNodes();
                int nLen = nl.getLength();
                for (int i = 0; i < nLen; ++i) {
                    int nColRepeat;
                    Node child = nl.item(i);
                    if (child.getNodeType() != 1) continue;
                    Element cell = (Element)child;
                    String sName = cell.getTagName();
                    if (sName.equals("table:table-cell")) {
                        nColRepeat = Misc.getPosInteger(cell.getAttribute("table:number-columns-repeated"), 1);
                        while (nColRepeat-- > 0) {
                            row.add(cell);
                        }
                        continue;
                    }
                    if (!sName.equals("table:covered-table-cell")) continue;
                    nColRepeat = Misc.getPosInteger(cell.getAttribute("table:number-columns-repeated"), 1);
                    while (nColRepeat-- > 0) {
                        row.add(cell);
                    }
                }
            }
            this.cells.add(row);
        }
    }

    private void readTableRows(Node node, boolean bHeader, boolean bDisplay) {
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        for (int i = 0; i < nLen; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            String sName = child.getNodeName();
            if (sName.equals("table:table-row")) {
                this.readTableRow(child, bHeader, bDisplay);
                continue;
            }
            if (!sName.equals("table:table-row-group")) continue;
            this.readTableRowGroup(child, bHeader, bDisplay);
        }
    }

    private void readTableRowGroup(Node node, boolean bHeader, boolean bDisplay) {
        boolean bl = bDisplay = !"false".equals(Misc.getAttribute(node, "table:display"));
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        for (int i = 0; i < nLen; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            String sName = child.getNodeName();
            if (sName.equals("table:table-header-rows")) {
                this.readTableHeaderRows(child, bHeader, bDisplay);
                continue;
            }
            if (sName.equals("table:table-row")) {
                this.readTableRow(child, bHeader, bDisplay);
                continue;
            }
            if (!sName.equals("table:table-row-group")) continue;
            this.readTableRowGroup(child, bHeader, bDisplay);
        }
    }

    public boolean isSubTable() {
        return "table:sub-table".equals(this.tableNode.getTagName()) || "true".equals(Misc.getAttribute(this.tableNode, "table:is-sub-table"));
    }

    private void readTableHeaderRows(Node node, boolean bHeader, boolean bDisplay) {
        this.readTableRows(node, true, bDisplay);
    }

    private void countTableRows(Element table) {
        this.nRowCount = 0;
        this.nEmptyRowCount = 0;
        for (Node child = table.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String sName = child.getNodeName();
            if (sName.equals("table:table-row")) {
                this.countTableRow(child);
                continue;
            }
            if (sName.equals("table:table-rows")) {
                this.countTableRows(child);
                continue;
            }
            if (sName.equals("table:table-row-group")) {
                this.countTableRowGroup(child);
                continue;
            }
            if (!sName.equals("table:table-header-rows")) continue;
            this.countTableHeaderRows(child);
        }
        if (this.nEmptyRowCount > 1) {
            this.nRowCount -= this.nEmptyRowCount - 1;
        }
    }

    private void countTableRow(Node node) {
        int nRepeat = Misc.getPosInteger(Misc.getAttribute(node, "table:number-rows-repeated"), 1);
        this.nRowCount += nRepeat;
        this.nEmptyRowCount = this.isEmptyRow(node) ? (this.nEmptyRowCount += nRepeat) : 0;
    }

    private boolean isEmptyRow(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element cell;
            String sName;
            if (child.getNodeType() != 1 || !(sName = (cell = (Element)child).getTagName()).equals("table:table-cell") || !cell.hasChildNodes()) continue;
            return false;
        }
        return true;
    }

    private void countTableRows(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String sName = child.getNodeName();
            if (sName.equals("table:table-row")) {
                this.countTableRow(child);
                continue;
            }
            if (!sName.equals("table:table-row-group")) continue;
            this.countTableRowGroup(child);
        }
    }

    private void countTableRowGroup(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String sName = child.getNodeName();
            if (sName.equals("table:table-header-rows")) {
                this.countTableHeaderRows(child);
                continue;
            }
            if (sName.equals("table:table-row")) {
                this.countTableRow(child);
                continue;
            }
            if (!sName.equals("table:table-row-group")) continue;
            this.countTableRowGroup(child);
        }
    }

    private void countTableHeaderRows(Node node) {
        this.countTableRows(node);
    }

    public String getTableName() {
        return this.tableNode.getAttribute("table:name");
    }

    public String getTableStyleName() {
        return this.tableNode.getAttribute("table:style-name");
    }

    public String getTableWidth() {
        return this.sTableWidth;
    }

    public String getRelTableWidth() {
        return this.sRelTableWidth;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getMaxRowCount() {
        return this.nMaxRows;
    }

    public int getFirstBodyRow() {
        int nRows = this.rows.size();
        for (int nRow = 0; nRow < nRows; ++nRow) {
            if (this.getRow(nRow).isHeader()) continue;
            return nRow;
        }
        return nRows;
    }

    public int getColCount() {
        return this.cols.size();
    }

    public int getMaxColCount() {
        return this.nMaxCols;
    }

    public String getColumnWidth(int nCol) {
        return 0 <= nCol && nCol <= this.cols.size() ? this.sColWidth[nCol] : null;
    }

    public String getRelColumnWidth(int nCol) {
        return 0 <= nCol && nCol <= this.cols.size() ? this.sRelColWidth[nCol] : null;
    }

    public Element getCell(int nRow, int nCol) {
        if (nRow < 0 || nRow >= this.cells.size()) {
            return null;
        }
        LinkedList<Element> row = this.cells.get(nRow);
        if (nCol < 0 || nCol >= row.size()) {
            return null;
        }
        return row.get(nCol);
    }

    public String getCellStyleName(int nRow, int nCol) {
        Element cell = this.getCell(nRow, nCol);
        if (cell == null) {
            return null;
        }
        String s = cell.getAttribute("table:style-name");
        if (s != null && s.length() > 0) {
            return s;
        }
        s = this.getRow(nRow).getDefaultCellStyleName();
        if (s != null && s.length() > 0) {
            return s;
        }
        s = this.getCol(nCol).getDefaultCellStyleName();
        return s;
    }

    public String getCellWidth(int nRow, int nCol) {
        Element cell = this.getCell(nRow, nCol);
        if (cell == null) {
            return null;
        }
        int nCols = Misc.getPosInteger(cell.getAttribute("table:number-columns-spanned"), 1);
        String sWidth = this.sColWidth[nCol];
        for (int i = nCol + 1; i < nCol + nCols; ++i) {
            sWidth = Calc.add(sWidth, this.sColWidth[i]);
        }
        return sWidth;
    }

    public TableLine getRow(int nRow) {
        if (nRow < 0 || nRow >= this.rows.size()) {
            return null;
        }
        return this.rows.get(nRow);
    }

    public TableLine getCol(int nCol) {
        if (nCol < 0 || nCol >= this.cols.size()) {
            return null;
        }
        return this.cols.get(nCol);
    }

    public int getPrintRangeCount() {
        return this.printRanges.size();
    }

    public TableRange getPrintRange(int nIndex) {
        if (0 <= nIndex && nIndex < this.printRanges.size()) {
            return this.printRanges.get(nIndex);
        }
        return null;
    }
}

