/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.office;

import org.w3c.dom.Element;
import writer2xhtml.util.Misc;

public class LoftReader {
    private Element loftSource = null;
    private Element indexBody = null;
    private String sName = null;
    private String sStyleName = null;
    private boolean bUseCaption = true;
    private String sCaptionSequenceName = null;
    private boolean bIsByChapter = false;
    private Element indexTitleTemplate = null;
    private Element loftEntryTemplate = null;
    private boolean bIsTableIndex;

    public LoftReader(Element onode) {
        this.bIsTableIndex = onode.getTagName().equals("text:table-index");
        this.sName = Misc.getAttribute(onode, "text:name");
        this.sStyleName = Misc.getAttribute(onode, "text:style-name");
        this.loftSource = this.bIsTableIndex ? Misc.getChildByTagName(onode, "text:table-index-source") : Misc.getChildByTagName(onode, "text:illustration-index-source");
        this.indexBody = Misc.getChildByTagName(onode, "text:index-body");
        if (this.loftSource != null) {
            this.bUseCaption = !"false".equals(this.loftSource.getAttribute("text:use-caption"));
            this.sCaptionSequenceName = this.loftSource.getAttribute("text:caption-sequence-name");
            this.bIsByChapter = "chapter".equals(this.loftSource.getAttribute("text:index-scope"));
            this.indexTitleTemplate = Misc.getChildByTagName(this.loftSource, "text:index-title-template");
            this.loftEntryTemplate = this.bIsTableIndex ? Misc.getChildByTagName(this.loftSource, "text:table-index-entry-template") : Misc.getChildByTagName(this.loftSource, "text:illustration-index-entry-template");
        }
    }

    public String getName() {
        return this.sName;
    }

    public String getStyleName() {
        return this.sStyleName;
    }

    public boolean isTableIndex() {
        return this.bIsTableIndex;
    }

    public boolean isByChapter() {
        return this.bIsByChapter;
    }

    public boolean useCaption() {
        return this.bUseCaption;
    }

    public String getCaptionSequenceName() {
        return this.sCaptionSequenceName;
    }

    public Element getIndexTitleTemplate() {
        return this.indexTitleTemplate;
    }

    public Element getLoftEntryTemplate(int nLevel) {
        return this.loftEntryTemplate;
    }

    public Element getIndexBody() {
        return this.indexBody;
    }
}

