/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.office;

import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2xhtml.office.FormReader;
import writer2xhtml.util.Misc;

public class ControlReader {
    private FormReader ownerForm;
    private String sId;
    private Element control;
    private Element controlType;
    private Vector<Node> items = new Vector();

    public ControlReader(Element control, FormReader ownerForm) {
        this.ownerForm = ownerForm;
        this.control = control;
        this.sId = control.getAttribute("form:id");
        this.controlType = control.getTagName().equals("form:control") ? Misc.getFirstChildElement(control) : control;
        if (this.controlType != null) {
            for (Node child = this.controlType.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.getNodeName().equals("form:option") && !child.getNodeName().equals("form:item")) continue;
                this.items.add(child);
            }
        }
    }

    public String getId() {
        return this.sId;
    }

    public FormReader getOwnerForm() {
        return this.ownerForm;
    }

    public String getAttribute(String sName) {
        return this.control.hasAttribute(sName) ? this.control.getAttribute(sName) : null;
    }

    public String getControlType() {
        return this.controlType.getTagName();
    }

    public String getTypeAttribute(String sName) {
        return this.controlType != null && this.controlType.hasAttribute(sName) ? this.controlType.getAttribute(sName) : null;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public String getItemAttribute(int nIndex, String sName) {
        if (0 <= nIndex && nIndex <= this.items.size()) {
            return ((Element)this.items.get(nIndex)).hasAttribute(sName) ? ((Element)this.items.get(nIndex)).getAttribute(sName) : null;
        }
        return null;
    }

    public String getItemValue(int nIndex) {
        if (0 <= nIndex && nIndex <= this.items.size()) {
            return Misc.getPCDATA((Element)this.items.get(nIndex));
        }
        return null;
    }
}

