/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.epub;

import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;
import writer2xhtml.api.ConverterResult;
import writer2xhtml.base.ConverterResultImpl;
import writer2xhtml.epub.EPUBWriter;
import writer2xhtml.xhtml.Converter;

public final class EPUB3Converter
extends Converter {
    public EPUB3Converter() {
        super(4);
    }

    @Override
    public ConverterResult convert(InputStream is, String sTargetFileName) throws IOException {
        this.setOPS(true);
        ConverterResult xhtmlResult = super.convert(is, "chapter");
        return this.createPackage(xhtmlResult, sTargetFileName);
    }

    @Override
    public ConverterResult convert(Document dom, String sTargetFileName, boolean bDestructive) throws IOException {
        this.setOPS(true);
        ConverterResult xhtmlResult = super.convert(dom, "chapter", bDestructive);
        return this.createPackage(xhtmlResult, sTargetFileName);
    }

    private ConverterResult createPackage(ConverterResult xhtmlResult, String sTargetFileName) {
        ConverterResultImpl epubResult = new ConverterResultImpl();
        epubResult.addDocument(new EPUBWriter(xhtmlResult, sTargetFileName, 3, this.getXhtmlConfig()));
        epubResult.setMetaData(xhtmlResult.getMetaData());
        return epubResult;
    }
}

