/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.base;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2xhtml.api.GraphicConverter;
import writer2xhtml.base.BinaryGraphicsDocument;
import writer2xhtml.office.EmbeddedBinaryObject;
import writer2xhtml.office.EmbeddedObject;
import writer2xhtml.office.MIMETypes;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.SVMReader;
import writer2xhtml.util.Misc;

public final class ImageConverter {
    private OfficeReader ofr;
    private boolean bDestructive;
    private boolean bUseBase64 = false;
    private String sBaseFileName = "";
    private String sSubDirName = "";
    private int nImageCount = 0;
    private NumberFormat formatter;
    private boolean bExtractEPS;
    private GraphicConverter gcv = null;
    private boolean bAcceptOtherFormats = true;
    private String sDefaultFormat = null;
    private String sDefaultVectorFormat = null;
    private HashSet<String> acceptedFormats = new HashSet();
    private HashMap<String, BinaryGraphicsDocument> recycledImages = new HashMap();

    public ImageConverter(OfficeReader ofr, boolean bDestructive, boolean bExtractEPS) {
        this.ofr = ofr;
        this.bDestructive = bDestructive;
        this.bExtractEPS = bExtractEPS;
        this.formatter = new DecimalFormat("000");
    }

    public void setBaseFileName(String sBaseFileName) {
        this.sBaseFileName = sBaseFileName;
    }

    public void setUseSubdir(String sSubDirName) {
        this.sSubDirName = sSubDirName + "/";
    }

    public void setAcceptOtherFormats(boolean b) {
        this.bAcceptOtherFormats = b;
    }

    public void setDefaultFormat(String sMime) {
        this.addAcceptedFormat(sMime);
        this.sDefaultFormat = sMime;
    }

    public void setDefaultVectorFormat(String sMime) {
        this.addAcceptedFormat(sMime);
        this.sDefaultVectorFormat = sMime;
    }

    public void addAcceptedFormat(String sMime) {
        this.acceptedFormats.add(sMime);
    }

    private boolean isAcceptedFormat(String sMime) {
        return this.acceptedFormats.contains(sMime);
    }

    public void setGraphicConverter(GraphicConverter gcv) {
        this.gcv = gcv;
    }

    public void setUseBase64(boolean b) {
        this.bUseBase64 = b;
    }

    public BinaryGraphicsDocument getImage(Element node) {
        BinaryGraphicsDocument altBgd;
        Element sibling;
        String sName = this.sSubDirName + this.sBaseFileName + this.formatter.format(++this.nImageCount);
        BinaryGraphicsDocument bgd = this.getImage(node, sName);
        if (bgd != null && (!bgd.isAcceptedFormat() || this.sDefaultVectorFormat != null && !this.sDefaultVectorFormat.equals(bgd.getMIMEType())) && (sibling = this.getAlternativeImage(node)) != null && (altBgd = this.getImage(sibling, sName)) != null && altBgd.isAcceptedFormat() && (!bgd.isAcceptedFormat() || this.sDefaultVectorFormat != null && !this.sDefaultVectorFormat.equals(bgd.getMIMEType()) && this.sDefaultVectorFormat.equals(altBgd.getMIMEType()))) {
            bgd = altBgd;
        }
        if (bgd == null || bgd.isLinked() || bgd.isRecycled()) {
            --this.nImageCount;
        }
        return bgd;
    }

    private BinaryGraphicsDocument getImage(Element node, String sName) {
        int[] offlen;
        String sHref;
        assert ("draw:image".equals(node.getTagName()) || "text:list-level-style-image".equals(node.getTagName()));
        String sExt = null;
        String sMIME = null;
        byte[] blob = null;
        String sId = null;
        if (node.hasAttribute("xlink:href") && (sHref = node.getAttribute("xlink:href")).length() > 0) {
            EmbeddedObject obj;
            if (this.recycledImages.containsKey(sHref)) {
                return this.recycledImages.get(sHref);
            }
            String sPath = sHref;
            if (sPath.startsWith("#")) {
                sPath = sPath.substring(1);
            }
            if (sPath.startsWith("./")) {
                sPath = sPath.substring(2);
            }
            if ((obj = this.ofr.getEmbeddedObject(sPath)) != null && obj instanceof EmbeddedBinaryObject) {
                EmbeddedBinaryObject object = (EmbeddedBinaryObject)obj;
                blob = object.getBinaryData();
                sMIME = object.getType();
                if (sMIME.length() == 0) {
                    sMIME = MIMETypes.getMagicMIMEType(blob);
                }
                sExt = MIMETypes.getFileExtension(sMIME);
                if (this.bDestructive) {
                    object.dispose();
                }
                sId = sHref;
            } else {
                String sFileName = this.ofr.fixRelativeLink(sHref);
                BinaryGraphicsDocument bgd = new BinaryGraphicsDocument(sFileName, null);
                return bgd;
            }
        }
        if (blob == null) {
            Element obd = Misc.getChildByTagName(node, "office:binary-data");
            if (obd != null) {
                StringBuilder buf = new StringBuilder();
                NodeList nl = obd.getChildNodes();
                int nLen = nl.getLength();
                for (int i = 0; i < nLen; ++i) {
                    if (nl.item(i).getNodeType() != 3) continue;
                    buf.append(nl.item(i).getNodeValue());
                }
                blob = Base64.getDecoder().decode(buf.toString());
                String sId1 = this.createId(blob);
                if (this.recycledImages.containsKey(sId1)) {
                    return this.recycledImages.get(sId1);
                }
                sMIME = MIMETypes.getMagicMIMEType(blob);
                sExt = MIMETypes.getFileExtension(sMIME);
                if (this.bDestructive) {
                    node.removeChild(obd);
                }
                sId = sId1;
            } else {
                return null;
            }
        }
        if (this.bExtractEPS && "application/x-openoffice-gdimetafile;windows_formatname=\"GDIMetaFile\"".equals(sMIME) && SVMReader.readSVM(blob, offlen = new int[2])) {
            String sFileName = sName + ".eps";
            BinaryGraphicsDocument bgd = new BinaryGraphicsDocument(sFileName, "image/x-eps");
            bgd.setData(blob, offlen[0], offlen[1], true);
            return bgd;
        }
        if (this.gcv != null && !this.isAcceptedFormat(sMIME) && this.sDefaultFormat != null) {
            byte[] newBlob = null;
            String sTargetMIME = null;
            if (MIMETypes.isVectorFormat(sMIME) && this.sDefaultVectorFormat != null && this.gcv.supportsConversion(sMIME, this.sDefaultVectorFormat, false, false)) {
                sTargetMIME = this.sDefaultVectorFormat;
                newBlob = this.gcv.convert(blob, sMIME, sTargetMIME);
            }
            if (newBlob == null && this.gcv.supportsConversion(sMIME, this.sDefaultFormat, false, false)) {
                sTargetMIME = this.sDefaultFormat;
                newBlob = this.gcv.convert(blob, sMIME, sTargetMIME);
            }
            if (newBlob != null) {
                blob = newBlob;
                sMIME = sTargetMIME;
                sExt = MIMETypes.getFileExtension(sMIME);
            }
        }
        if (this.isAcceptedFormat(sMIME) || this.bAcceptOtherFormats) {
            String sFileName = sName + sExt;
            BinaryGraphicsDocument bgd = new BinaryGraphicsDocument(sFileName, sMIME);
            bgd.setData(blob, this.isAcceptedFormat(sMIME));
            if (this.bUseBase64 && !"image/svg+xml".equals(sMIME)) {
                bgd.convertToBase64();
            }
            if (sId != null) {
                this.recycledImages.put(sId, new BinaryGraphicsDocument(bgd));
            }
            return bgd;
        }
        return null;
    }

    private Element getAlternativeImage(Element node) {
        Node sibling = node.getNextSibling();
        if (sibling != null && Misc.isElement(sibling, "draw:image")) {
            return (Element)sibling;
        }
        return null;
    }

    private String createId(byte[] blob) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        return Base64.getEncoder().encodeToString(md.digest(blob)) + Base64.getEncoder().encodeToString(Arrays.copyOf(blob, 10));
    }
}

