/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import writer2xhtml.api.OutputFile;

public class DOMDocument
implements OutputFile {
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private Document contentDoc = null;
    private String documentName = null;
    private String fileName = null;
    private String fileExt = null;

    public DOMDocument(String name, String ext) {
        this(name, ext, true, false);
    }

    protected String getFileExtension() {
        return this.fileExt;
    }

    public DOMDocument(String name, String ext, boolean namespaceAware, boolean validating) {
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceAware);
        this.fileExt = ext;
        this.documentName = this.trimDocumentName(name);
        this.fileName = this.documentName + this.getFileExtension();
    }

    private String trimDocumentName(String name) {
        String ext;
        String temp = name.toLowerCase();
        if (temp.endsWith(ext = this.getFileExtension())) {
            int nlen = name.length();
            int endIndex = nlen - ext.length();
            name = name.substring(0, endIndex);
        }
        return name;
    }

    public Document getContentDOM() {
        return this.contentDoc;
    }

    public void setContentDOM(Node newDom) {
        this.contentDoc = (Document)newDom;
    }

    public String getName() {
        return this.documentName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void read(InputStream is) throws IOException {
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex.getMessage());
        }
        try {
            this.contentDoc = builder.parse(is);
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void write(OutputStream os) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
        osw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        this.write(this.getContentDOM().getDocumentElement(), 0, osw);
        osw.flush();
        osw.close();
    }

    private void write(Node node, int nLevel, OutputStreamWriter osw) throws IOException {
        short nType = node.getNodeType();
        switch (nType) {
            case 1: {
                if (node.hasChildNodes()) {
                    int i;
                    NodeList list = node.getChildNodes();
                    int nLen = list.getLength();
                    boolean bBlockPrettyPrint = false;
                    if (nLevel >= 0) {
                        for (i = 0; i < nLen; ++i) {
                            bBlockPrettyPrint |= list.item(i).getNodeType() == 3;
                        }
                    }
                    if (nLevel >= 0) {
                        this.writeSpaces(nLevel, osw);
                    }
                    osw.write("<" + node.getNodeName());
                    this.writeAttributes(node, osw);
                    osw.write(">");
                    if (nLevel >= 0 && !bBlockPrettyPrint) {
                        osw.write("\n");
                    }
                    for (i = 0; i < nLen; ++i) {
                        int nNextLevel = bBlockPrettyPrint || nLevel < 0 ? -1 : nLevel + 1;
                        this.write(list.item(i), nNextLevel, osw);
                    }
                    if (nLevel >= 0 && !bBlockPrettyPrint) {
                        this.writeSpaces(nLevel, osw);
                    }
                    osw.write("</" + node.getNodeName() + ">");
                    if (nLevel < 0) break;
                    osw.write("\n");
                    break;
                }
                if (nLevel >= 0) {
                    this.writeSpaces(nLevel, osw);
                }
                osw.write("<" + node.getNodeName());
                this.writeAttributes(node, osw);
                osw.write(" />");
                if (nLevel < 0) break;
                osw.write("\n");
                break;
            }
            case 3: {
                this.write(node.getNodeValue(), osw);
                break;
            }
            case 8: {
                if (nLevel >= 0) {
                    this.writeSpaces(nLevel, osw);
                }
                osw.write("<!-- ");
                this.write(node.getNodeValue(), osw);
                osw.write(" -->");
                if (nLevel < 0) break;
                osw.write("\n");
            }
        }
    }

    private void writeAttributes(Node node, OutputStreamWriter osw) throws IOException {
        NamedNodeMap attr = node.getAttributes();
        int nLen = attr.getLength();
        for (int i = 0; i < nLen; ++i) {
            Node item = attr.item(i);
            osw.write(" ");
            this.write(item.getNodeName(), osw);
            osw.write("=\"");
            this.write(item.getNodeValue(), osw);
            osw.write("\"");
        }
    }

    private void writeSpaces(int nCount, OutputStreamWriter osw) throws IOException {
        for (int i = 0; i < nCount; ++i) {
            osw.write("  ");
        }
    }

    private void write(String s, OutputStreamWriter osw) throws IOException {
        int nLen = s.length();
        block7: for (int i = 0; i < nLen; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    osw.write("&lt;");
                    continue block7;
                }
                case '>': {
                    osw.write("&gt;");
                    continue block7;
                }
                case '&': {
                    osw.write("&amp;");
                    continue block7;
                }
                case '\"': {
                    osw.write("&quot;");
                    continue block7;
                }
                case '\'': {
                    osw.write("&apos;");
                    continue block7;
                }
                default: {
                    osw.write(c);
                }
            }
        }
    }

    public final void initContentDOM() throws IOException {
        this.contentDoc = this.createDOM("");
    }

    private final Document createDOM(String rootName) throws IOException {
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            System.err.println("Error:" + ex);
            throw new IOException(ex);
        }
        Element root = doc.createElement(rootName);
        doc.appendChild(root);
        return doc;
    }

    @Override
    public String getMIMEType() {
        return "";
    }

    @Override
    public boolean isMasterDocument() {
        return false;
    }

    @Override
    public boolean containsMath() {
        return false;
    }
}

