/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.base;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import writer2xhtml.api.OutputFile;

public class BinaryGraphicsDocument
implements OutputFile {
    private String sFileName;
    private String sMimeType;
    private boolean bAcceptedFormat;
    private boolean bRecycled = false;
    private byte[] blob = null;
    private int nOff = 0;
    private int nLen = 0;
    private String sBase64 = null;

    public BinaryGraphicsDocument(String sFileName, String sMimeType) {
        this.sFileName = sFileName;
        this.sMimeType = sMimeType;
        this.bAcceptedFormat = false;
    }

    public BinaryGraphicsDocument(BinaryGraphicsDocument bgd) {
        this.sFileName = bgd.getFileName();
        this.sMimeType = bgd.getMIMEType();
        this.bAcceptedFormat = bgd.isAcceptedFormat();
        this.bRecycled = true;
        this.sBase64 = bgd.getBase64();
    }

    public boolean isRecycled() {
        return this.bRecycled;
    }

    public void setData(byte[] data, boolean bIsAcceptedFormat) {
        this.setData(data, 0, data.length, bIsAcceptedFormat);
    }

    public void setData(byte[] data, int nOff, int nLen, boolean bIsAcceptedFormat) {
        this.blob = data;
        this.nOff = nOff;
        this.nLen = nLen;
        this.bAcceptedFormat = bIsAcceptedFormat;
    }

    public void convertToBase64() {
        this.sBase64 = Base64.getEncoder().encodeToString(this.blob);
        this.blob = null;
    }

    public boolean isLinked() {
        return this.blob == null && this.sBase64 == null && !this.bRecycled;
    }

    public boolean isAcceptedFormat() {
        return this.bAcceptedFormat;
    }

    public byte[] getData() {
        return this.blob;
    }

    public String getBase64() {
        return this.sBase64;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        if (this.blob != null) {
            os.write(this.blob, this.nOff, this.nLen);
        }
    }

    @Override
    public String getFileName() {
        return this.sFileName;
    }

    @Override
    public String getMIMEType() {
        return this.sMimeType;
    }

    @Override
    public boolean isMasterDocument() {
        return false;
    }

    @Override
    public boolean containsMath() {
        return false;
    }
}

