/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.util.Misc;
import writer2xhtml.util.StringComparator;

public abstract class BibliographyGenerator {
    private String sPrefix = "[";
    private String sSuffix = "]";
    private List<Element> bibMarkList = new ArrayList<Element>();
    private Map<String, String> bibMarkLabel = new HashMap<String, String>();
    private boolean bNumberedEntries = false;
    private boolean bSkipKey = false;

    protected BibliographyGenerator(OfficeReader ofr, boolean bSkipKey) {
        this.bSkipKey = bSkipKey;
        Element bibConfig = ofr.getBibliographyConfiguration();
        if (bibConfig != null) {
            if (bibConfig.hasAttribute("text:prefix")) {
                this.sPrefix = bibConfig.getAttribute("text:prefix");
            }
            if (bibConfig.hasAttribute("text:suffix")) {
                this.sSuffix = bibConfig.getAttribute("text:suffix");
            }
        }
        this.collectBibMarks(ofr.getBibliographyMarks());
        this.sortBibMarks(bibConfig);
        this.createLabels(bibConfig);
    }

    private void collectBibMarks(List<Element> bibMarks) {
        HashSet<String> keys = new HashSet<String>();
        for (Element bibMark : bibMarks) {
            String sKey = bibMark.getAttribute("text:identifier");
            if (keys.contains(sKey)) continue;
            this.bibMarkList.add(bibMark);
            keys.add(sKey);
        }
    }

    private void sortBibMarks(Element bibConfig) {
        if (bibConfig != null && "false".equals(bibConfig.getAttribute("text:sort-by-position"))) {
            ArrayList<String> sortKeys = new ArrayList<String>();
            ArrayList<Boolean> sortAscending = new ArrayList<Boolean>();
            for (Node child = bibConfig.getFirstChild(); child != null; child = child.getNextSibling()) {
                String sKey;
                if (child.getNodeType() != 1 || !child.getNodeName().equals("text:sort-key") || (sKey = Misc.getAttribute(child, "text:key")) == null) continue;
                sortKeys.add(sKey);
                sortAscending.add(!"false".equals(Misc.getAttribute(child, "text:sort-ascending")));
            }
            Comparator<Element> comparator = new StringComparator<Element>(Misc.getAttribute(bibConfig, "fo:language"), Misc.getAttribute(bibConfig, "fo:country")){
                private List<String> sortKeys;
                private List<Boolean> sortAscending;
                {
                    this.sortKeys = null;
                    this.sortAscending = null;
                }

                Comparator<Element> setSortKeys(List<String> sortKeys, List<Boolean> sortAscending) {
                    this.sortKeys = sortKeys;
                    this.sortAscending = sortAscending;
                    return this;
                }

                @Override
                public int compare(Element a, Element b) {
                    int nCount = this.sortKeys.size();
                    for (int i = 0; i < nCount; ++i) {
                        String sWorda = a.getAttribute("text:" + this.sortKeys.get(i));
                        String sWordb = b.getAttribute("text:" + this.sortKeys.get(i));
                        int nCompare = this.getCollator().compare(sWorda, sWordb) * (this.sortAscending.get(i) != false ? 1 : -1);
                        if (nCompare == 0) continue;
                        return nCompare;
                    }
                    return 0;
                }
            }.setSortKeys(sortKeys, sortAscending);
            Collections.sort(this.bibMarkList, comparator);
        }
    }

    private void createLabels(Element bibConfig) {
        this.bNumberedEntries = bibConfig != null && "true".equals(bibConfig.getAttribute("text:numbered-entries"));
        int nCount = this.bibMarkList.size();
        for (int i = 0; i < nCount; ++i) {
            Element item = this.bibMarkList.get(i);
            String sKey = item.getAttribute("text:identifier");
            if (this.bNumberedEntries) {
                this.bibMarkLabel.put(sKey, Integer.toString(i + 1));
                continue;
            }
            this.bibMarkLabel.put(sKey, sKey);
        }
    }

    protected Collection<String> getLabels() {
        return this.bibMarkLabel.values();
    }

    protected boolean isNumberedEntries() {
        return this.bNumberedEntries;
    }

    public String generateCitation(String sKey) {
        return this.sPrefix + this.bibMarkLabel.get(sKey) + this.sSuffix;
    }

    protected void generateBibliography(Element bibSource) {
        Map<String, Element> bibEntryTemplate = this.collectTemplates(bibSource);
        for (Element bibMark : this.bibMarkList) {
            String sKey = bibMark.getAttribute("text:identifier");
            String sType = bibMark.getAttribute("text:bibliography-type");
            if (bibEntryTemplate.containsKey(sType)) {
                Element template = bibEntryTemplate.get(sType);
                String sStyleName = template.getAttribute("text:style-name");
                this.insertBibliographyItem(sStyleName, sKey);
                this.applyTemplate(template, bibMark);
                continue;
            }
            String sAuthor = bibMark.getAttribute("text:author");
            String sTitle = bibMark.getAttribute("text:title");
            String sYear = bibMark.getAttribute("text:year");
            this.insertBibliographyItem(null, sKey);
            if (!this.bSkipKey) {
                this.insertBibliographyItemElement(null, this.bibMarkLabel.get(sKey));
                this.insertBibliographyItemElement(null, ": ");
            }
            this.insertBibliographyItemElement(null, sAuthor);
            this.insertBibliographyItemElement(null, ", ");
            this.insertBibliographyItemElement(null, sTitle);
            this.insertBibliographyItemElement(null, ", ");
            this.insertBibliographyItemElement(null, sYear);
        }
    }

    private Map<String, Element> collectTemplates(Element bibSource) {
        HashMap<String, Element> bibEntryTemplate = new HashMap<String, Element>();
        for (Node child = bibSource.getFirstChild(); child != null; child = child.getNextSibling()) {
            String sType;
            if (child.getNodeType() != 1 || !child.getNodeName().equals("text:bibliography-entry-template") || (sType = Misc.getAttribute(child, "text:bibliography-type")) == null) continue;
            bibEntryTemplate.put(sType, (Element)child);
        }
        return bibEntryTemplate;
    }

    private void applyTemplate(Element template, Element bibMark) {
        boolean bSkip = this.bSkipKey;
        for (Node child = template.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("text:index-entry-bibliography")) {
                String sField = Misc.getAttribute(child, "text:bibliography-data-field");
                if (sField == null) continue;
                String sValue = bibMark.getAttribute("text:" + sField);
                if (sField.equals("identifier")) {
                    sValue = this.bibMarkLabel.get(sValue);
                } else {
                    bSkip = false;
                }
                if (bSkip) continue;
                String sElementStyleName = Misc.getAttribute(child, "text:style-name");
                this.insertBibliographyItemElement(sElementStyleName, sValue);
                continue;
            }
            if (!child.getNodeName().equals("text:index-entry-span") || bSkip) continue;
            String sValue = Misc.getPCDATA(child);
            String sElementStyleName = Misc.getAttribute(child, "text:style-name");
            this.insertBibliographyItemElement(sElementStyleName, sValue);
        }
    }

    protected abstract void insertBibliographyItem(String var1, String var2);

    protected abstract void insertBibliographyItemElement(String var1, String var2);
}

