/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import writer2xhtml.api.Converter;
import writer2xhtml.api.ConverterFactory;
import writer2xhtml.api.ConverterResult;
import writer2xhtml.util.Misc;

public final class Application {
    private String sTargetMIME = "text/html5";
    private Vector<String> configFileNames = new Vector();
    private String sTemplateFileName = null;
    private String sStyleSheetFileName = null;
    private Set<String> resources = new HashSet<String>();
    private Hashtable<String, String> options = new Hashtable();
    private String sSource = null;
    private String sTarget = null;

    public static final void main(String[] args) {
        try {
            Application app = new Application();
            app.parseCommandLine(args);
            app.doConversion();
        }
        catch (IllegalArgumentException ex) {
            String msg = ex.getMessage();
            Application.showUsage(msg);
        }
    }

    private void doConversion() {
        File target;
        System.out.println();
        System.out.println("This is Writer2xhtml, Version " + ConverterFactory.getVersion() + " (" + ConverterFactory.getDate() + ")");
        System.out.println();
        System.out.println("Starting conversion...");
        File source = new File(this.sSource);
        if (!source.exists()) {
            System.out.println("I'm sorry, I can't find " + this.sSource);
            System.exit(1);
        }
        if (!source.canRead()) {
            System.out.println("I'm sorry, I can't read " + this.sSource);
            System.exit(1);
        }
        if (!source.isFile()) {
            System.out.println("I'm sorry, " + this.sSource + " is not a file");
            System.exit(1);
        }
        if (this.sTarget == null) {
            target = new File(source.getParent(), Misc.removeExtension(source.getName()));
        } else {
            target = new File(this.sTarget);
            if (this.sTarget.endsWith(File.separator)) {
                target = new File(target, Misc.removeExtension(source.getName()));
            }
        }
        Converter converter = ConverterFactory.createConverter(this.sTargetMIME);
        if (converter == null) {
            System.out.println("Failed to create converter for " + this.sTargetMIME);
            System.exit(1);
        }
        if (this.sTemplateFileName != null) {
            try {
                System.out.println("Reading template " + this.sTemplateFileName);
                byte[] templateBytes = Misc.inputStreamToByteArray(new FileInputStream(this.sTemplateFileName));
                converter.readTemplate(new ByteArrayInputStream(templateBytes));
            }
            catch (FileNotFoundException e) {
                System.out.println("--> This file does not exist!");
                System.out.println("    " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("--> Failed to read the template file!");
                System.out.println("    " + e.getMessage());
            }
        }
        if (this.sStyleSheetFileName != null) {
            try {
                System.out.println("Reading style sheet " + this.sStyleSheetFileName);
                byte[] styleSheetBytes = Misc.inputStreamToByteArray(new FileInputStream(this.sStyleSheetFileName));
                converter.readStyleSheet(new ByteArrayInputStream(styleSheetBytes));
            }
            catch (FileNotFoundException e) {
                System.out.println("--> This file does not exist!");
                System.out.println("    " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("--> Failed to read the style sheet file!");
                System.out.println("    " + e.getMessage());
            }
        }
        for (String sResource : this.resources) {
            String sMediaType;
            String sFileName;
            int nSeparator = sResource.indexOf("::");
            if (nSeparator > -1) {
                sFileName = sResource.substring(0, nSeparator);
                sMediaType = sResource.substring(nSeparator + 2);
            } else {
                sFileName = sResource;
                sMediaType = null;
            }
            System.out.println("Reading resource file " + sFileName);
            try {
                byte[] resourceBytes = Misc.inputStreamToByteArray(new FileInputStream(sFileName));
                converter.readResource(new ByteArrayInputStream(resourceBytes), sFileName, sMediaType);
            }
            catch (IOException e) {
                System.out.println("--> Failed to read the resource file!");
                System.out.println("    " + e.getMessage());
            }
        }
        for (int i = 0; i < this.configFileNames.size(); ++i) {
            String sConfigFileName = this.configFileNames.get(i);
            if (sConfigFileName.startsWith("*")) {
                sConfigFileName = sConfigFileName.substring(1);
                System.out.println("Reading default configuration " + sConfigFileName);
                try {
                    converter.getConfig().readDefaultConfig(sConfigFileName);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("--> This configuration is unknown!");
                    System.out.println("    " + e.getMessage());
                }
                continue;
            }
            System.out.println("Reading configuration file " + sConfigFileName);
            try {
                byte[] configBytes = Misc.inputStreamToByteArray(new FileInputStream(sConfigFileName));
                converter.getConfig().read(new ByteArrayInputStream(configBytes));
                continue;
            }
            catch (IOException e) {
                System.err.println("--> Failed to read the configuration!");
                System.out.println("    " + e.getMessage());
            }
        }
        Enumeration<String> keys = this.options.keys();
        while (keys.hasMoreElements()) {
            String sKey = keys.nextElement();
            String sValue = this.options.get(sKey);
            converter.getConfig().setOption(sKey, sValue);
        }
        System.out.println("Converting " + source.getPath());
        ConverterResult dataOut = null;
        try {
            dataOut = converter.convert(source, target.getName());
        }
        catch (FileNotFoundException e) {
            System.out.println("--> The file " + source.getPath() + " does not exist!");
            System.out.println("    " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("--> Failed to convert the file " + source.getPath() + "!");
            System.out.println("    " + e.getMessage());
            System.out.println("    Please make sure the file is in OpenDocument format");
            System.exit(1);
        }
        File targetDir = target.getParentFile();
        if (targetDir != null && !targetDir.exists()) {
            targetDir.mkdirs();
        }
        try {
            dataOut.write(targetDir);
        }
        catch (IOException e) {
            System.out.println("--> Error writing out file!");
            System.out.println("    " + e.getMessage());
            System.exit(1);
        }
        System.out.println("Done!");
    }

    private static void showUsage(String msg) {
        System.out.println();
        System.out.println("This is Writer2xhtml, Version " + ConverterFactory.getVersion() + " (" + ConverterFactory.getDate() + ")");
        System.out.println();
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println();
        System.out.println("Usage:");
        System.out.println("   java -jar <path>/writer2xhtml.jar <options> <source file/directory> [<target file/directory>]");
        System.out.println("where the available options are:");
        System.out.println("   -xhtml");
        System.out.println("   -xhtml11");
        System.out.println("   -xhtml+mathml");
        System.out.println("   -html5");
        System.out.println("   -epub");
        System.out.println("   -epub3");
        System.out.println("   -template[=]<template file>");
        System.out.println("   -stylesheet[=]<style sheet file>");
        System.out.println("   -resource[=]<resource file>[::<media type>]");
        System.out.println("   -cleanxhtml");
        System.out.println("   -config[=]<configuration file>");
        System.out.println("   -<configuration option>[=]<value>");
        System.out.println("See the documentation for the available configuration options");
    }

    private void parseCommandLine(String[] sArgs) throws IllegalArgumentException {
        int i = 0;
        while (i < sArgs.length) {
            String sArgument;
            String sArg;
            if ((sArg = this.getArg(i++, sArgs)).startsWith("-")) {
                String sArg2;
                if ("-html5".equals(sArg)) {
                    this.sTargetMIME = "text/html5";
                    continue;
                }
                if ("-xhtml".equals(sArg)) {
                    this.sTargetMIME = "text/html";
                    continue;
                }
                if ("-xhtml11".equals(sArg)) {
                    this.sTargetMIME = "application/xhtml11";
                    continue;
                }
                if ("-xhtml+mathml".equals(sArg)) {
                    this.sTargetMIME = "application/xhtml+xml";
                    continue;
                }
                if ("-epub".equals(sArg)) {
                    this.sTargetMIME = "application/epub+zip";
                    continue;
                }
                if ("-epub3".equals(sArg)) {
                    this.sTargetMIME = "epub3";
                    continue;
                }
                if ("-cleanxhtml".equals(sArg)) {
                    this.configFileNames.add("*cleanxhtml.xml");
                    continue;
                }
                int j = sArg.indexOf("=");
                if (j > -1) {
                    sArg2 = sArg.substring(j + 1);
                    sArg = sArg.substring(0, j);
                } else {
                    sArg2 = this.getArg(i++, sArgs);
                }
                if ("-config".equals(sArg)) {
                    this.configFileNames.add(sArg2);
                    continue;
                }
                if ("-template".equals(sArg)) {
                    this.sTemplateFileName = sArg2;
                    continue;
                }
                if ("-stylesheet".equals(sArg)) {
                    this.sStyleSheetFileName = sArg2;
                    continue;
                }
                if ("-resource".equals(sArg)) {
                    this.resources.add(sArg2);
                    continue;
                }
                this.options.put(sArg.substring(1), sArg2);
                continue;
            }
            this.sSource = sArg;
            if (i < sArgs.length && (sArgument = this.getArg(i++, sArgs)).length() > 0) {
                this.sTarget = sArgument;
            }
            while (i < sArgs.length) {
                if ((sArgument = this.getArg(i++, sArgs)).length() <= 0) continue;
                throw new IllegalArgumentException("I didn't expect " + sArgument + "?");
            }
        }
        if (this.sSource == null) {
            throw new IllegalArgumentException("Please specify a source document/directory!");
        }
    }

    private String getArg(int i, String[] args) throws IllegalArgumentException {
        if (i < args.length) {
            return args[i];
        }
        throw new IllegalArgumentException("I'm sorry, the commandline ended abnormally");
    }
}

