/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import org.w3c.dom.Element;
import writer2xhtml.base.BibliographyGenerator;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.xhtml.Converter;

class XhtmlBibliographyGenerator
extends BibliographyGenerator {
    private Converter converter;
    private Element ul;
    private Element currentPar;

    XhtmlBibliographyGenerator(OfficeReader ofr, Converter converter) {
        super(ofr, false);
        this.converter = converter;
    }

    void populateBibliography(Element bibliography, Element ul) {
        this.ul = ul;
        this.generateBibliography(bibliography);
    }

    @Override
    protected void insertBibliographyItem(String sStyleName, String sKey) {
        Element li = this.converter.createElement("li");
        this.converter.addTarget(li, "bib" + sKey);
        this.converter.addEpubType(li, "biblioentry");
        this.ul.appendChild(li);
        this.currentPar = this.converter.getTextCv().createParagraph(li, sStyleName);
    }

    @Override
    protected void insertBibliographyItemElement(String sStyleName, String sText) {
        if (sStyleName != null) {
            this.converter.getTextCv().createInline(this.currentPar, sStyleName).appendChild(this.converter.createTextNode(sText));
        } else {
            this.currentPar.appendChild(this.converter.createTextNode(sText));
        }
    }
}

