/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.OfficeStyleFamily;
import writer2xhtml.office.StyleWithProperties;
import writer2xhtml.util.CSVList;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.StyleWithPropertiesConverterHelper;
import writer2xhtml.xhtml.XhtmlConfig;

public class ParStyleConverter
extends StyleWithPropertiesConverterHelper {
    public ParStyleConverter(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        this.styleMap = config.getXParStyleMap();
        this.bConvertStyles = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 2;
        this.bConvertHard = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 1;
    }

    @Override
    public OfficeStyleFamily getStyles() {
        return this.ofr.getParStyles();
    }

    @Override
    public String getDefaultTagName(StyleWithProperties style) {
        return "p";
    }

    @Override
    public void applyProperties(StyleWithProperties style, CSVList props, boolean bInherit) {
        this.cssPageBreak(style, props, bInherit);
        this.getFrameSc().cssMargins(style, props, bInherit);
        this.getFrameSc().cssBorder(style, props, bInherit);
        this.getFrameSc().cssPadding(style, props, bInherit);
        this.getFrameSc().cssBackgroundCommon(style, props, bInherit);
        this.cssPar(style, props, bInherit);
        this.getTextSc().cssTextBlock(style, props, bInherit);
    }

    public String getTextBackground(String sStyleName) {
        CSVList props = new CSVList(";");
        StyleWithProperties style = this.ofr.getParStyle(sStyleName);
        if (style != null) {
            this.getTextSc().cssTextBackground(style, props, true);
        }
        return props.toString();
    }

    public String getRealParStyleName(String sStyleName) {
        if (sStyleName == null) {
            return sStyleName;
        }
        StyleWithProperties style = this.ofr.getParStyle(sStyleName);
        if (style == null || !style.isAutomatic()) {
            return sStyleName;
        }
        return style.getParentName();
    }

    public void cssPageBreak(StyleWithProperties style, CSVList props, boolean bInherit) {
        if ("page".equals(style.getProperty("fo:break-before", bInherit))) {
            props.addValue("page-break-before", "always");
        } else if ("page".equals(style.getProperty("fo:break-after", bInherit))) {
            props.addValue("page-break-after", "always");
        }
    }

    public void cssPar(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getParProperty("fo:background-color", bInherit);
        if (s != null) {
            props.addValue("background-color", s);
        }
        if (bInherit || style.getProperty("fo:text-indent", false) != null) {
            s = style.getAbsoluteProperty("fo:text-indent");
            if (s != null) {
                props.addValue("text-indent", this.scale(s));
            } else {
                s = style.getProperty("style:auto-text-indent");
                if ("true".equals(s)) {
                    props.addValue("text-indent", "2em");
                }
            }
        }
        if ((s = style.getProperty("fo:text-align", bInherit)) != null) {
            if (s.equals("start")) {
                s = "left";
            } else if (s.equals("end")) {
                s = "right";
            }
            props.addValue("text-align", s);
        }
        if (this.ofr.isSpreadsheet()) {
            s = style.getProperty("fo:wrap-option", bInherit);
            if ("no-wrap".equals(s)) {
                props.addValue("white-space", "nowrap");
            } else if ("wrap".equals(s)) {
                props.addValue("white-space", "normal");
            }
        }
    }
}

