/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import org.w3c.dom.Element;
import writer2xhtml.office.OfficeReader;
import writer2xhtml.util.Calc;
import writer2xhtml.xhtml.CellStyleConverter;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.DrawConverter;
import writer2xhtml.xhtml.FrameStyleConverter;
import writer2xhtml.xhtml.HeadingStyleConverter;
import writer2xhtml.xhtml.ListStyleConverter;
import writer2xhtml.xhtml.MathConverter;
import writer2xhtml.xhtml.PageStyleConverter;
import writer2xhtml.xhtml.ParStyleConverter;
import writer2xhtml.xhtml.RowStyleConverter;
import writer2xhtml.xhtml.SectionStyleConverter;
import writer2xhtml.xhtml.StyleConverter;
import writer2xhtml.xhtml.StyleInfo;
import writer2xhtml.xhtml.TableConverter;
import writer2xhtml.xhtml.TableStyleConverter;
import writer2xhtml.xhtml.TextConverter;
import writer2xhtml.xhtml.TextStyleConverter;
import writer2xhtml.xhtml.XhtmlConfig;

class ConverterHelper {
    OfficeReader ofr;
    XhtmlConfig config;
    Converter converter;
    private String sScale;
    private String sColScale;
    private int nUnits;

    ConverterHelper(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        this.ofr = ofr;
        this.config = config;
        this.converter = converter;
        this.sScale = config.getXhtmlScaling();
        this.sColScale = config.getXhtmlColumnScaling();
        this.nUnits = config.units();
    }

    StyleConverter getStyleCv() {
        return this.converter.getStyleCv();
    }

    TextStyleConverter getTextSc() {
        return this.converter.getStyleCv().getTextSc();
    }

    ParStyleConverter getParSc() {
        return this.converter.getStyleCv().getParSc();
    }

    HeadingStyleConverter getHeadingSc() {
        return this.converter.getStyleCv().getHeadingSc();
    }

    ListStyleConverter getListSc() {
        return this.converter.getStyleCv().getListSc();
    }

    SectionStyleConverter getSectionSc() {
        return this.converter.getStyleCv().getSectionSc();
    }

    TableStyleConverter getTableSc() {
        return this.converter.getStyleCv().getTableSc();
    }

    RowStyleConverter getRowSc() {
        return this.converter.getStyleCv().getRowSc();
    }

    CellStyleConverter getCellSc() {
        return this.converter.getStyleCv().getCellSc();
    }

    FrameStyleConverter getFrameSc() {
        return this.converter.getStyleCv().getFrameSc();
    }

    PageStyleConverter getPageSc() {
        return this.converter.getStyleCv().getPageSc();
    }

    TextConverter getTextCv() {
        return this.converter.getTextCv();
    }

    TableConverter getTableCv() {
        return this.converter.getTableCv();
    }

    DrawConverter getDrawCv() {
        return this.converter.getDrawCv();
    }

    MathConverter getMathCv() {
        return this.converter.getMathCv();
    }

    void applyStyle(StyleInfo info, Element hnode) {
        if (info.sClass != null) {
            hnode.setAttribute("class", info.sClass);
        }
        if (!info.props.isEmpty()) {
            hnode.setAttribute("style", info.props.toString());
        }
        if (info.sLang != null) {
            hnode.setAttribute("xml:lang", info.sLang);
            if (this.converter.getType() == 0 || this.converter.isHTML5()) {
                hnode.setAttribute("lang", info.sLang);
            }
        }
        if (info.sDir != null) {
            hnode.setAttribute("dir", info.sDir);
        }
    }

    protected String scale(String s) {
        switch (this.nUnits) {
            case 1: {
                return Calc.length2px(Calc.multiply(this.sScale, s));
            }
            case 2: {
                return Calc.length2rem(Calc.multiply(this.sScale, s));
            }
        }
        return Calc.multiply(this.sScale, s);
    }

    protected String colScale(String s) {
        return this.scale(Calc.multiply(this.sColScale, s));
    }
}

