/*
 * Decompiled with CFR 0.152.
 */
package writer2xhtml.xhtml;

import writer2xhtml.office.OfficeReader;
import writer2xhtml.office.OfficeStyleFamily;
import writer2xhtml.office.StyleWithProperties;
import writer2xhtml.util.CSVList;
import writer2xhtml.xhtml.Converter;
import writer2xhtml.xhtml.StyleWithPropertiesConverterHelper;
import writer2xhtml.xhtml.XhtmlConfig;
import writer2xhtml.xhtml.XhtmlStyleMap;

public class CellStyleConverter
extends StyleWithPropertiesConverterHelper {
    public CellStyleConverter(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        this.styleMap = new XhtmlStyleMap();
        this.bConvertStyles = config.xhtmlTableFormatting() == 3 || config.xhtmlTableFormatting() == 2;
        this.bConvertHard = config.xhtmlTableFormatting() == 3 || config.xhtmlTableFormatting() == 1;
    }

    @Override
    public OfficeStyleFamily getStyles() {
        return this.ofr.getCellStyles();
    }

    @Override
    public String getDefaultTagName(StyleWithProperties style) {
        return "td";
    }

    @Override
    public void applyProperties(StyleWithProperties style, CSVList props, boolean bInherit) {
        this.getFrameSc().cssBorder(style, props, bInherit);
        this.getFrameSc().cssPadding(style, props, bInherit);
        this.getFrameSc().cssBackground(style, props, bInherit);
        this.getParSc().cssPar(style, props, bInherit);
        this.getTextSc().cssTextBlock(style, props, bInherit);
        this.cssCell(style, props, bInherit);
    }

    private void cssCell(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s;
        String string = s = this.ofr.isOpenDocument() ? style.getProperty("style:vertical-align", bInherit) : style.getProperty("fo:vertical-align", bInherit);
        if ("middle".equals(s)) {
            props.addValue("vertical-align", "middle");
        } else if ("bottom".equals(s)) {
            props.addValue("vertical-align", "bottom");
        } else if ("top".equals(s)) {
            props.addValue("vertical-align", "top");
        } else {
            props.addValue("vertical-align", this.ofr.isSpreadsheet() ? "bottom" : "top");
        }
    }
}

